/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.date.button;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import tr.swing.date.chooser.DateChooser;
import tr.swing.date.chooser.DateChooserDialog;

public class DateButton
extends JButton {
    public static final DateFormat DATE_FORMAT_FIXED;
    public static final DateFormat DATE_FORMAT;
    private final DateChooser dateChooser;
    private Date date;
    private String noSelectionText = "";
    public Component component = null;

    public DateButton() {
        this.dateChooser = new DateChooser(new JFrame());
    }

    public DateButton(String title) {
        this.dateChooser = new DateChooser(new JFrame(), title);
    }

    public DateButton(Frame owner) {
        this.dateChooser = new DateChooser(owner);
    }

    public DateButton(Frame owner, String title) {
        this.dateChooser = new DateChooser(owner, title);
    }

    public DateButton(Dialog owner) {
        this.dateChooser = new DateChooser(owner);
    }

    public DateButton(Dialog owner, String title) {
        this.dateChooser = new DateChooser(owner, title);
    }

    public void setNoSelectionText(String text) {
        this.noSelectionText = text;
        this.setDate(this.date);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        Date old = this.date;
        this.date = date;
        this.setText(date == null ? this.noSelectionText : DATE_FORMAT.format(date));
        this.firePropertyChange("date", old, date);
    }

    protected void fireActionPerformed(ActionEvent event) {
        DateChooserDialog dialog = this.dateChooser.getDialog();
        if (this.component == null) {
            this.component = this;
        }
        Date newDate = dialog.select(this.date, this.component);
        if (dialog.cancelled()) {
            return;
        }
        this.setDate(newDate);
    }

    static {
        DATE_FORMAT = DATE_FORMAT_FIXED = new SimpleDateFormat("EEE, d MMM yyyy");
    }
}

