/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class IncludeObject
extends AbstractNamedAFPObject {
    private byte _objectType = (byte)-5;
    private int _orientation = 0;

    public IncludeObject(String name) {
        super(name);
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 90 && orientation != 180 && orientation != 270) {
            throw new IllegalArgumentException("The orientation must be one of the values 0, 90, 180, 270");
        }
        this._orientation = orientation;
    }

    public void writeDataStream(OutputStream os) throws IOException {
        byte[] data = new byte[37];
        data[0] = 90;
        byte[] rl1 = BinaryUtils.convert(36, 2);
        data[1] = rl1[0];
        data[2] = rl1[1];
        data[3] = -45;
        data[4] = -81;
        data[5] = -61;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        for (int i = 0; i < this._nameBytes.length; ++i) {
            data[9 + i] = this._nameBytes[i];
        }
        data[17] = 0;
        data[18] = this._objectType;
        data[20] = -1;
        data[21] = -1;
        data[22] = -1;
        data[23] = -1;
        data[24] = -1;
        data[25] = -1;
        switch (this._orientation) {
            case 90: {
                data[26] = 45;
                data[27] = 0;
                data[28] = 90;
                data[29] = 0;
                break;
            }
            case 180: {
                data[26] = 90;
                data[27] = 0;
                data[28] = -121;
                data[29] = 0;
                break;
            }
            case 270: {
                data[26] = -121;
                data[27] = 0;
                data[28] = 0;
                data[29] = 0;
                break;
            }
            default: {
                data[26] = 0;
                data[27] = 0;
                data[28] = 45;
                data[29] = 0;
            }
        }
        data[30] = -1;
        data[31] = -1;
        data[32] = -1;
        data[33] = -1;
        data[34] = -1;
        data[35] = -1;
        data[36] = 1;
        os.write(data);
    }
}

