/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.validation;

import com.thaiopensource.relaxng.impl.CombineValidator;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import nu.validator.checker.ConformingButObsoleteWarner;
import nu.validator.checker.MicrodataChecker;
import nu.validator.checker.NormalizationChecker;
import nu.validator.checker.TextContentChecker;
import nu.validator.checker.UncheckedSubtreeWarner;
import nu.validator.checker.UnsupportedFeatureChecker;
import nu.validator.checker.UsemapChecker;
import nu.validator.checker.XmlPiChecker;
import nu.validator.checker.jing.CheckerSchema;
import nu.validator.checker.jing.CheckerValidator;
import nu.validator.checker.table.TableChecker;
import nu.validator.gnu.xml.aelfred2.FatalSAXException;
import nu.validator.gnu.xml.aelfred2.SAXDriver;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.localentities.LocalCacheEntityResolver;
import nu.validator.source.SourceCode;
import nu.validator.xml.IdFilter;
import nu.validator.xml.NullEntityResolver;
import nu.validator.xml.PrudentHttpEntityResolver;
import nu.validator.xml.TypedInputSource;
import nu.validator.xml.WiretapXMLReaderWrapper;
import nu.validator.xml.customelements.NamespaceChangingSchemaWrapper;
import nu.validator.xml.dataattributes.DataAttributeDroppingSchemaWrapper;
import nu.validator.xml.langattributes.XmlLangAttributeDroppingSchemaWrapper;
import nu.validator.xml.roleattributes.RoleAttributeFilteringSchemaWrapper;
import nu.validator.xml.templateelement.TemplateElementDroppingSchemaWrapper;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SimpleDocumentValidator {
    private LocalCacheEntityResolver entityResolver;
    private Schema mainSchema;
    private String mainSchemaUrl;
    private boolean hasHtml5Schema;
    private Schema assertionSchema;
    private Schema langdetectSchema;
    private Validator validator;
    private SourceCode sourceCode = new SourceCode();
    private TypedInputSource documentInput;
    private PrudentHttpEntityResolver httpRes;
    private XMLReader htmlReader;
    private SAXDriver xmlParser;
    private XMLReader xmlReader;
    private LexicalHandler lexicalHandler;
    private boolean allowCss = false;
    private static final byte[] CSS_CHECKING_PROLOG;
    private static final byte[] CSS_CHECKING_EPILOG;

    private Schema schemaByUrl(String schemaUrl, ErrorHandler errorHandler) throws Exception, SchemaReadException {
        PropertyMapBuilder pmb = new PropertyMapBuilder();
        pmb.put(ValidateProperty.ERROR_HANDLER, errorHandler);
        pmb.put(ValidateProperty.ENTITY_RESOLVER, this.entityResolver);
        pmb.put(ValidateProperty.XML_READER_CREATOR, new Jaxp11XMLReaderCreator());
        RngProperty.CHECK_ID_IDREF.add(pmb);
        PropertyMap jingPropertyMap = pmb.toPropertyMap();
        try {
            TypedInputSource schemaInput = (TypedInputSource)this.entityResolver.resolveEntity(null, schemaUrl);
            SchemaReader sr = "application/relax-ng-compact-syntax".equals(schemaInput.getType()) ? CompactSchemaReader.getInstance() : new AutoSchemaReader();
            return sr.createSchema(schemaInput, jingPropertyMap);
        }
        catch (ClassCastException e) {
            throw new SchemaReadException(String.format("Failed to resolve schema URL \"%s\".", schemaUrl));
        }
    }

    public SimpleDocumentValidator() {
        this(true, true, true);
    }

    public SimpleDocumentValidator(boolean initializeLog4j) {
        this(initializeLog4j, true, true);
    }

    public SourceCode getSourceCode() {
        return this.sourceCode;
    }

    public String getMainSchemaUrl() {
        return this.mainSchemaUrl;
    }

    public SimpleDocumentValidator(boolean initializeLog4j, boolean logUrls, boolean enableLanguageDetection) {
        System.setProperty("nu.validator.checker.enableLangDetection", "0");
        if (enableLanguageDetection) {
            System.setProperty("nu.validator.checker.enableLangDetection", "1");
        }
        if (initializeLog4j) {
            Properties properties = new Properties();
            try {
                properties.load(SimpleDocumentValidator.class.getClassLoader().getResourceAsStream("nu/validator/localentities/files/log4j.properties"));
                if (!logUrls) {
                    properties.setProperty("log4j.logger.nu.validator.xml.PrudentHttpEntityResolver", "FATAL");
                }
                PropertyConfigurator.configure(properties);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.entityResolver = new LocalCacheEntityResolver(new NullEntityResolver());
        this.entityResolver.setAllowRnc(true);
    }

    public void setUpMainSchema(String schemaUrl, ErrorHandler errorHandler) throws SAXException, Exception, SchemaReadException {
        Schema schema = this.schemaByUrl(schemaUrl, errorHandler);
        if (schemaUrl.contains("html5")) {
            try {
                this.assertionSchema = CheckerSchema.ASSERTION_SCH;
            }
            catch (Exception e) {
                throw new SchemaReadException("Failed to retrieve secondary schema.");
            }
            try {
                this.langdetectSchema = CheckerSchema.LANGUAGE_DETECTING_CHECKER;
            }
            catch (Exception e) {
                throw new SchemaReadException("Failed to retrieve secondary schema.");
            }
            schema = new DataAttributeDroppingSchemaWrapper(schema);
            schema = new XmlLangAttributeDroppingSchemaWrapper(schema);
            schema = new RoleAttributeFilteringSchemaWrapper(schema);
            schema = new TemplateElementDroppingSchemaWrapper(schema);
            schema = new NamespaceChangingSchemaWrapper(schema);
            this.hasHtml5Schema = true;
            if ("http://s.validator.nu/html5-all.rnc".equals(schemaUrl)) {
                System.setProperty("nu.validator.schema.rdfa-full", "1");
            } else {
                System.setProperty("nu.validator.schema.rdfa-full", "0");
            }
        }
        this.mainSchemaUrl = schemaUrl;
        this.mainSchema = schema;
    }

    public void setUpValidatorAndParsers(ErrorHandler docValidationErrHandler, boolean noStream, boolean loadExternalEnts) throws SAXException {
        PropertyMapBuilder pmb = new PropertyMapBuilder();
        pmb.put(ValidateProperty.ERROR_HANDLER, docValidationErrHandler);
        pmb.put(ValidateProperty.XML_READER_CREATOR, new Jaxp11XMLReaderCreator());
        RngProperty.CHECK_ID_IDREF.add(pmb);
        PropertyMap jingPropertyMap = pmb.toPropertyMap();
        this.validator = this.mainSchema.createValidator(jingPropertyMap);
        if (this.hasHtml5Schema) {
            Validator assertionValidator = this.assertionSchema.createValidator(jingPropertyMap);
            this.validator = new CombineValidator(this.validator, assertionValidator);
            Validator langdetectValidator = this.langdetectSchema.createValidator(jingPropertyMap);
            this.validator = new CombineValidator(this.validator, langdetectValidator);
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new TableChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new ConformingButObsoleteWarner(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new MicrodataChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new NormalizationChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new TextContentChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new UncheckedSubtreeWarner(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new UnsupportedFeatureChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new UsemapChecker(), jingPropertyMap));
            this.validator = new CombineValidator(this.validator, new CheckerValidator(new XmlPiChecker(), jingPropertyMap));
        }
        HtmlParser htmlParser = new HtmlParser();
        htmlParser.addCharacterHandler(this.sourceCode);
        htmlParser.setCommentPolicy(XmlViolationPolicy.ALLOW);
        htmlParser.setContentNonXmlCharPolicy(XmlViolationPolicy.ALLOW);
        htmlParser.setContentSpacePolicy(XmlViolationPolicy.ALTER_INFOSET);
        htmlParser.setNamePolicy(XmlViolationPolicy.ALLOW);
        htmlParser.setXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
        htmlParser.setMappingLangToXmlLang(true);
        htmlParser.setHeuristics(Heuristics.ALL);
        htmlParser.setContentHandler(this.validator.getContentHandler());
        htmlParser.setErrorHandler(docValidationErrHandler);
        htmlParser.setNamePolicy(XmlViolationPolicy.ALLOW);
        htmlParser.setMappingLangToXmlLang(true);
        htmlParser.setFeature("http://xml.org/sax/features/unicode-normalization-checking", true);
        if (!noStream) {
            htmlParser.setStreamabilityViolationPolicy(XmlViolationPolicy.FATAL);
        }
        this.htmlReader = this.getWiretap(htmlParser);
        this.xmlParser = new SAXDriver();
        this.xmlParser.setContentHandler(this.validator.getContentHandler());
        if (this.lexicalHandler != null) {
            this.xmlParser.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
        }
        this.xmlReader = new IdFilter(this.xmlParser);
        this.xmlReader.setFeature("http://xml.org/sax/features/string-interning", true);
        this.xmlReader.setContentHandler(this.validator.getContentHandler());
        this.xmlReader.setFeature("http://xml.org/sax/features/unicode-normalization-checking", true);
        if (loadExternalEnts) {
            this.xmlReader.setEntityResolver(this.entityResolver);
        } else {
            this.xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            this.xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.xmlReader.setEntityResolver(new NullEntityResolver());
        }
        this.xmlReader = this.getWiretap(this.xmlParser);
        this.xmlParser.setErrorHandler(docValidationErrHandler);
        this.xmlParser.lockErrorHandler();
    }

    private WiretapXMLReaderWrapper getWiretap(XMLReader reader) {
        WiretapXMLReaderWrapper wiretap = new WiretapXMLReaderWrapper(reader);
        ContentHandler recorder = this.sourceCode.getLocationRecorder();
        wiretap.setWiretapContentHander(recorder);
        wiretap.setWiretapLexicalHandler((LexicalHandler)((Object)recorder));
        return wiretap;
    }

    public void setAllowCss(boolean allowCss) {
        this.allowCss = allowCss;
    }

    public void checkHtmlInputSource(InputSource is) throws IOException, SAXException {
        this.validator.reset();
        is.setEncoding("UTF-8");
        this.checkAsHTML(is);
    }

    public void checkXmlInputSource(InputSource is) throws IOException, SAXException {
        this.validator.reset();
        this.checkAsXML(is);
    }

    public void checkCssFile(File file, boolean asUTF8) throws IOException, SAXException {
        this.validator.reset();
        InputSource is = new InputSource(new FileInputStream(file));
        is.setSystemId(file.toURI().toURL().toString());
        if (asUTF8) {
            is.setEncoding("UTF-8");
        }
        this.checkAsCss(is);
    }

    public void checkHtmlFile(File file, boolean asUTF8) throws IOException, SAXException {
        this.validator.reset();
        InputSource is = new InputSource(new FileInputStream(file));
        is.setSystemId(file.toURI().toURL().toString());
        if (asUTF8) {
            is.setEncoding("UTF-8");
        }
        this.checkAsHTML(is);
    }

    public void checkXmlFile(File file) throws IOException, SAXException {
        this.validator.reset();
        InputSource is = new InputSource(new FileInputStream(file));
        is.setSystemId(file.toURI().toURL().toString());
        this.checkAsXML(is);
    }

    public void checkHttpURL(String document, String userAgent, ErrorHandler errorHandler) throws IOException, SAXException {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        this.validator.reset();
        this.httpRes = new PrudentHttpEntityResolver(-1L, true, errorHandler);
        if (this.allowCss) {
            this.httpRes.setAllowCss(true);
        }
        this.httpRes.setAllowHtml(true);
        this.httpRes.setUserAgent(userAgent);
        try {
            this.documentInput = (TypedInputSource)this.httpRes.resolveEntity(null, document);
            String contentType = this.documentInput.getType();
            this.documentInput.setSystemId(document);
            for (String param : contentType.replace(" ", "").split(";")) {
                if (!param.startsWith("charset=")) continue;
                this.documentInput.setEncoding(param.split("=", 2)[1]);
                break;
            }
            if (this.documentInput.getType().startsWith("text/css")) {
                this.checkAsCss(this.documentInput);
            } else if (this.documentInput.getType().startsWith("text/html")) {
                this.checkAsHTML(this.documentInput);
            } else {
                this.checkAsXML(this.documentInput);
            }
        }
        catch (PrudentHttpEntityResolver.ResourceNotRetrievableException resourceNotRetrievableException) {
            // empty catch block
        }
    }

    private void checkAsCss(InputSource is) throws IOException, SAXException {
        String charset = "UTF-8";
        if (is.getEncoding() != null) {
            charset = is.getEncoding();
        }
        ArrayList<InputStream> streamsList = new ArrayList<InputStream>();
        streamsList.add(new ByteArrayInputStream(CSS_CHECKING_PROLOG));
        streamsList.add(is.getByteStream());
        streamsList.add(new ByteArrayInputStream(CSS_CHECKING_EPILOG));
        Enumeration streams = Collections.enumeration(streamsList);
        is.setByteStream(new SequenceInputStream(streams));
        is.setEncoding(charset);
        this.sourceCode.setIsCss();
        this.sourceCode.initialize(is);
        try {
            this.htmlReader.parse(is);
        }
        catch (SAXParseException sAXParseException) {
            // empty catch block
        }
    }

    private void checkAsHTML(InputSource is) throws IOException, SAXException {
        this.sourceCode.initialize(is);
        try {
            this.htmlReader.parse(is);
        }
        catch (SAXParseException sAXParseException) {
            // empty catch block
        }
    }

    private void checkAsXML(InputSource is) throws IOException, SAXException {
        this.xmlParser.setCharacterHandler(this.sourceCode);
        this.sourceCode.initialize(is);
        try {
            this.xmlReader.parse(is);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (FatalSAXException fatalSAXException) {
            // empty catch block
        }
    }

    static {
        PrudentHttpEntityResolver.setParams(Integer.parseInt(System.getProperty("nu.validator.servlet.connection-timeout", "5000")), Integer.parseInt(System.getProperty("nu.validator.servlet.socket-timeout", "5000")), Integer.parseInt(System.getProperty("nu.validator.servlet.max-requests", "100")));
        CSS_CHECKING_PROLOG = "<!DOCTYPE html><html lang=''><title>s</title><style>\n".getBytes();
        CSS_CHECKING_EPILOG = "\n</style>".getBytes();
    }

    public class SchemaReadException
    extends Exception {
        public SchemaReadException() {
        }

        public SchemaReadException(String message) {
            super(message);
        }
    }
}

