/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class ImageFigure
extends AttributeFigure
implements ImageObserver {
    private String fFileName;
    private transient Image fImage;
    private Rectangle fDisplayBox;
    private static final long serialVersionUID = 148012030121282439L;
    private int imageFigureSerializedDataVersion = 1;

    public ImageFigure() {
        this.fFileName = null;
        this.fImage = null;
        this.fDisplayBox = null;
    }

    public ImageFigure(Image image, String string, Point point) {
        this.fFileName = string;
        this.fImage = image;
        this.fDisplayBox = new Rectangle(point.x, point.y, 0, 0);
        this.fDisplayBox.width = this.fImage.getWidth(this);
        this.fDisplayBox.height = this.fImage.getHeight(this);
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
    }

    public Vector handles() {
        Vector vector = new Vector();
        BoxHandleKit.addHandles(this, vector);
        return vector;
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    public void draw(Graphics graphics) {
        if (this.fImage == null) {
            this.fImage = Iconkit.instance().getImage(this.fFileName);
        }
        if (this.fImage != null) {
            graphics.drawImage(this.fImage, this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height, this);
        } else {
            this.drawGhost(graphics);
        }
    }

    private void drawGhost(Graphics graphics) {
        graphics.setColor(Color.gray);
        graphics.fillRect(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x30) != 0) {
            this.invalidate();
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent(this));
            }
        }
        return (n & 0xA0) == 0;
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
        storableOutput.writeString(this.fFileName);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fDisplayBox = new Rectangle(storableInput.readInt(), storableInput.readInt(), storableInput.readInt(), storableInput.readInt());
        this.fFileName = storableInput.readString();
        Iconkit.instance().registerImage(this.fFileName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Iconkit.instance().registerImage(this.fFileName);
        this.fImage = null;
    }
}

