"""Generated client library for logging version v2."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.logging.v2 import logging_v2_messages as messages


class LoggingV2(base_api.BaseApiClient):
  """Generated client library for service logging version v2."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://logging.googleapis.com/'

  _PACKAGE = u'logging'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/cloud-platform.read-only', u'https://www.googleapis.com/auth/logging.admin', u'https://www.googleapis.com/auth/logging.read', u'https://www.googleapis.com/auth/logging.write']
  _VERSION = u'v2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'LoggingV2'
  _URL_VERSION = u'v2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new logging handle."""
    url = url or self.BASE_URL
    super(LoggingV2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.billingAccounts_buckets = self.BillingAccountsBucketsService(self)
    self.billingAccounts_exclusions = self.BillingAccountsExclusionsService(self)
    self.billingAccounts_locations_buckets = self.BillingAccountsLocationsBucketsService(self)
    self.billingAccounts_locations = self.BillingAccountsLocationsService(self)
    self.billingAccounts_logs = self.BillingAccountsLogsService(self)
    self.billingAccounts_sinks = self.BillingAccountsSinksService(self)
    self.billingAccounts = self.BillingAccountsService(self)
    self.buckets = self.BucketsService(self)
    self.entries = self.EntriesService(self)
    self.exclusions = self.ExclusionsService(self)
    self.folders_exclusions = self.FoldersExclusionsService(self)
    self.folders_locations_buckets = self.FoldersLocationsBucketsService(self)
    self.folders_locations = self.FoldersLocationsService(self)
    self.folders_logs = self.FoldersLogsService(self)
    self.folders_sinks = self.FoldersSinksService(self)
    self.folders = self.FoldersService(self)
    self.locations_buckets = self.LocationsBucketsService(self)
    self.locations = self.LocationsService(self)
    self.logs = self.LogsService(self)
    self.monitoredResourceDescriptors = self.MonitoredResourceDescriptorsService(self)
    self.organizations_exclusions = self.OrganizationsExclusionsService(self)
    self.organizations_locations_buckets = self.OrganizationsLocationsBucketsService(self)
    self.organizations_locations = self.OrganizationsLocationsService(self)
    self.organizations_logs = self.OrganizationsLogsService(self)
    self.organizations_sinks = self.OrganizationsSinksService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects_exclusions = self.ProjectsExclusionsService(self)
    self.projects_locations_buckets = self.ProjectsLocationsBucketsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects_logs = self.ProjectsLogsService(self)
    self.projects_metrics = self.ProjectsMetricsService(self)
    self.projects_sinks = self.ProjectsSinksService(self)
    self.projects = self.ProjectsService(self)
    self.sinks = self.SinksService(self)
    self.v2 = self.V2Service(self)

  class BillingAccountsBucketsService(base_api.BaseApiService):
    """Service class for the billingAccounts_buckets resource."""

    _NAME = u'billingAccounts_buckets'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a bucket.

      Args:
        request: (LoggingBillingAccountsBucketsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/buckets/{bucketsId}',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.buckets.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsBucketsGetRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

  class BillingAccountsExclusionsService(base_api.BaseApiService):
    """Service class for the billingAccounts_exclusions resource."""

    _NAME = u'billingAccounts_exclusions'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsExclusionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new exclusion in a specified parent resource. Only log entries belonging to that resource can be excluded. You can have up to 10 exclusions in a resource.

      Args:
        request: (LoggingBillingAccountsExclusionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/exclusions',
        http_method=u'POST',
        method_id=u'logging.billingAccounts.exclusions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/exclusions',
        request_field=u'logExclusion',
        request_type_name=u'LoggingBillingAccountsExclusionsCreateRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an exclusion.

      Args:
        request: (LoggingBillingAccountsExclusionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/exclusions/{exclusionsId}',
        http_method=u'DELETE',
        method_id=u'logging.billingAccounts.exclusions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsExclusionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the description of an exclusion.

      Args:
        request: (LoggingBillingAccountsExclusionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/exclusions/{exclusionsId}',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.exclusions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsExclusionsGetRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the exclusions in a parent resource.

      Args:
        request: (LoggingBillingAccountsExclusionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExclusionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/exclusions',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.exclusions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/exclusions',
        request_field='',
        request_type_name=u'LoggingBillingAccountsExclusionsListRequest',
        response_type_name=u'ListExclusionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Changes one or more properties of an existing exclusion.

      Args:
        request: (LoggingBillingAccountsExclusionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/exclusions/{exclusionsId}',
        http_method=u'PATCH',
        method_id=u'logging.billingAccounts.exclusions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logExclusion',
        request_type_name=u'LoggingBillingAccountsExclusionsPatchRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

  class BillingAccountsLocationsBucketsService(base_api.BaseApiService):
    """Service class for the billingAccounts_locations_buckets resource."""

    _NAME = u'billingAccounts_locations_buckets'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsLocationsBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a bucket that can be used to store log entries. Once a bucket has been created, the region cannot be changed.

      Args:
        request: (LoggingBillingAccountsLocationsBucketsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/locations/{locationsId}/buckets',
        http_method=u'POST',
        method_id=u'logging.billingAccounts.locations.buckets.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'bucketId'],
        relative_path=u'v2/{+parent}/buckets',
        request_field=u'logBucket',
        request_type_name=u'LoggingBillingAccountsLocationsBucketsCreateRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a bucket. All views and logs in the bucket are deleted. If the bucket is non-empty and locked, FAILED_PRECONDITION will be returned. If the bucket has a sink in the same project pointing to it, FAILED_PRECONDITION will be returned.

      Args:
        request: (LoggingBillingAccountsLocationsBucketsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'DELETE',
        method_id=u'logging.billingAccounts.locations.buckets.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsLocationsBucketsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists buckets.

      Args:
        request: (LoggingBillingAccountsLocationsBucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBucketsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/locations/{locationsId}/buckets',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.locations.buckets.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/buckets',
        request_field='',
        request_type_name=u'LoggingBillingAccountsLocationsBucketsListRequest',
        response_type_name=u'ListBucketsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a bucket. This method replaces the following fields in the existing bucket with values from the new bucket: retention_periodIf the retention period is decreased and the bucket is locked, FAILED_PRECONDITION will be returned.A buckets region may not be modified after it is created.

      Args:
        request: (LoggingBillingAccountsLocationsBucketsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'PATCH',
        method_id=u'logging.billingAccounts.locations.buckets.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logBucket',
        request_type_name=u'LoggingBillingAccountsLocationsBucketsPatchRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

  class BillingAccountsLocationsService(base_api.BaseApiService):
    """Service class for the billingAccounts_locations resource."""

    _NAME = u'billingAccounts_locations'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class BillingAccountsLogsService(base_api.BaseApiService):
    """Service class for the billingAccounts_logs resource."""

    _NAME = u'billingAccounts_logs'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes all the log entries in a log. The log reappears if it receives new entries. Log entries written shortly before the delete operation might not be deleted.

      Args:
        request: (LoggingBillingAccountsLogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/logs/{logsId}',
        http_method=u'DELETE',
        method_id=u'logging.billingAccounts.logs.delete',
        ordered_params=[u'logName'],
        path_params=[u'logName'],
        query_params=[],
        relative_path=u'v2/{+logName}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsLogsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the logs in projects, organizations, folders, or billing accounts. Only logs that have entries are listed.

      Args:
        request: (LoggingBillingAccountsLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/logs',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.logs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'resourceNames'],
        relative_path=u'v2/{+parent}/logs',
        request_field='',
        request_type_name=u'LoggingBillingAccountsLogsListRequest',
        response_type_name=u'ListLogsResponse',
        supports_download=False,
    )

  class BillingAccountsSinksService(base_api.BaseApiService):
    """Service class for the billingAccounts_sinks resource."""

    _NAME = u'billingAccounts_sinks'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsSinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports specified log entries to a destination. The export of newly-ingested log entries begins immediately, unless the sink's writer_identity is not permitted to write to the destination. A sink can export log entries only from the resource owning the sink.

      Args:
        request: (LoggingBillingAccountsSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks',
        http_method=u'POST',
        method_id=u'logging.billingAccounts.sinks.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'uniqueWriterIdentity'],
        relative_path=u'v2/{+parent}/sinks',
        request_field=u'logSink',
        request_type_name=u'LoggingBillingAccountsSinksCreateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink. If the sink has a unique writer_identity, then that service account is also deleted.

      Args:
        request: (LoggingBillingAccountsSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}',
        http_method=u'DELETE',
        method_id=u'logging.billingAccounts.sinks.delete',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsSinksDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a sink.

      Args:
        request: (LoggingBillingAccountsSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.sinks.get',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingBillingAccountsSinksGetRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists sinks.

      Args:
        request: (LoggingBillingAccountsSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks',
        http_method=u'GET',
        method_id=u'logging.billingAccounts.sinks.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/sinks',
        request_field='',
        request_type_name=u'LoggingBillingAccountsSinksListRequest',
        response_type_name=u'ListSinksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter.The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingBillingAccountsSinksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}',
        http_method=u'PATCH',
        method_id=u'logging.billingAccounts.sinks.patch',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingBillingAccountsSinksPatchRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter.The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingBillingAccountsSinksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}',
        http_method=u'PUT',
        method_id=u'logging.billingAccounts.sinks.update',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingBillingAccountsSinksUpdateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

  class BillingAccountsService(base_api.BaseApiService):
    """Service class for the billingAccounts resource."""

    _NAME = u'billingAccounts'

    def __init__(self, client):
      super(LoggingV2.BillingAccountsService, self).__init__(client)
      self._upload_configs = {
          }

  class BucketsService(base_api.BaseApiService):
    """Service class for the buckets resource."""

    _NAME = u'buckets'

    def __init__(self, client):
      super(LoggingV2.BucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a bucket.

      Args:
        request: (LoggingBucketsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/buckets/{bucketsId}',
        http_method=u'GET',
        method_id=u'logging.buckets.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingBucketsGetRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists buckets.

      Args:
        request: (LoggingBucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBucketsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/buckets',
        http_method=u'GET',
        method_id=u'logging.buckets.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/buckets',
        request_field='',
        request_type_name=u'LoggingBucketsListRequest',
        response_type_name=u'ListBucketsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a bucket. This method replaces the following fields in the existing bucket with values from the new bucket: retention_periodIf the retention period is decreased and the bucket is locked, FAILED_PRECONDITION will be returned.A buckets region may not be modified after it is created.

      Args:
        request: (LoggingBucketsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/buckets/{bucketsId}',
        http_method=u'PATCH',
        method_id=u'logging.buckets.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logBucket',
        request_type_name=u'LoggingBucketsPatchRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

  class EntriesService(base_api.BaseApiService):
    """Service class for the entries resource."""

    _NAME = u'entries'

    def __init__(self, client):
      super(LoggingV2.EntriesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists log entries. Use this method to retrieve log entries that originated from a project/folder/organization/billing account. For ways to export log entries, see Exporting Logs.

      Args:
        request: (ListLogEntriesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogEntriesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'logging.entries.list',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v2/entries:list',
        request_field='<request>',
        request_type_name=u'ListLogEntriesRequest',
        response_type_name=u'ListLogEntriesResponse',
        supports_download=False,
    )

    def Write(self, request, global_params=None):
      r"""Writes log entries to Logging. This API method is the only way to send log entries to Logging. This method is used, directly or indirectly, by the Logging agent (fluentd) and all logging libraries configured to use Logging. A single request may contain log entries for a maximum of 1000 different resources (projects, organizations, billing accounts or folders).

      Args:
        request: (WriteLogEntriesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (WriteLogEntriesResponse) The response message.
      """
      config = self.GetMethodConfig('Write')
      return self._RunMethod(
          config, request, global_params=global_params)

    Write.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'logging.entries.write',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v2/entries:write',
        request_field='<request>',
        request_type_name=u'WriteLogEntriesRequest',
        response_type_name=u'WriteLogEntriesResponse',
        supports_download=False,
    )

  class ExclusionsService(base_api.BaseApiService):
    """Service class for the exclusions resource."""

    _NAME = u'exclusions'

    def __init__(self, client):
      super(LoggingV2.ExclusionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new exclusion in a specified parent resource. Only log entries belonging to that resource can be excluded. You can have up to 10 exclusions in a resource.

      Args:
        request: (LoggingExclusionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/exclusions',
        http_method=u'POST',
        method_id=u'logging.exclusions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/exclusions',
        request_field=u'logExclusion',
        request_type_name=u'LoggingExclusionsCreateRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an exclusion.

      Args:
        request: (LoggingExclusionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/exclusions/{exclusionsId}',
        http_method=u'DELETE',
        method_id=u'logging.exclusions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingExclusionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the description of an exclusion.

      Args:
        request: (LoggingExclusionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/exclusions/{exclusionsId}',
        http_method=u'GET',
        method_id=u'logging.exclusions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingExclusionsGetRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the exclusions in a parent resource.

      Args:
        request: (LoggingExclusionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExclusionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/exclusions',
        http_method=u'GET',
        method_id=u'logging.exclusions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/exclusions',
        request_field='',
        request_type_name=u'LoggingExclusionsListRequest',
        response_type_name=u'ListExclusionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Changes one or more properties of an existing exclusion.

      Args:
        request: (LoggingExclusionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/exclusions/{exclusionsId}',
        http_method=u'PATCH',
        method_id=u'logging.exclusions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logExclusion',
        request_type_name=u'LoggingExclusionsPatchRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

  class FoldersExclusionsService(base_api.BaseApiService):
    """Service class for the folders_exclusions resource."""

    _NAME = u'folders_exclusions'

    def __init__(self, client):
      super(LoggingV2.FoldersExclusionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new exclusion in a specified parent resource. Only log entries belonging to that resource can be excluded. You can have up to 10 exclusions in a resource.

      Args:
        request: (LoggingFoldersExclusionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/exclusions',
        http_method=u'POST',
        method_id=u'logging.folders.exclusions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/exclusions',
        request_field=u'logExclusion',
        request_type_name=u'LoggingFoldersExclusionsCreateRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an exclusion.

      Args:
        request: (LoggingFoldersExclusionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/exclusions/{exclusionsId}',
        http_method=u'DELETE',
        method_id=u'logging.folders.exclusions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingFoldersExclusionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the description of an exclusion.

      Args:
        request: (LoggingFoldersExclusionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/exclusions/{exclusionsId}',
        http_method=u'GET',
        method_id=u'logging.folders.exclusions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingFoldersExclusionsGetRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the exclusions in a parent resource.

      Args:
        request: (LoggingFoldersExclusionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExclusionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/exclusions',
        http_method=u'GET',
        method_id=u'logging.folders.exclusions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/exclusions',
        request_field='',
        request_type_name=u'LoggingFoldersExclusionsListRequest',
        response_type_name=u'ListExclusionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Changes one or more properties of an existing exclusion.

      Args:
        request: (LoggingFoldersExclusionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/exclusions/{exclusionsId}',
        http_method=u'PATCH',
        method_id=u'logging.folders.exclusions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logExclusion',
        request_type_name=u'LoggingFoldersExclusionsPatchRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

  class FoldersLocationsBucketsService(base_api.BaseApiService):
    """Service class for the folders_locations_buckets resource."""

    _NAME = u'folders_locations_buckets'

    def __init__(self, client):
      super(LoggingV2.FoldersLocationsBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a bucket that can be used to store log entries. Once a bucket has been created, the region cannot be changed.

      Args:
        request: (LoggingFoldersLocationsBucketsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/locations/{locationsId}/buckets',
        http_method=u'POST',
        method_id=u'logging.folders.locations.buckets.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'bucketId'],
        relative_path=u'v2/{+parent}/buckets',
        request_field=u'logBucket',
        request_type_name=u'LoggingFoldersLocationsBucketsCreateRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a bucket. All views and logs in the bucket are deleted. If the bucket is non-empty and locked, FAILED_PRECONDITION will be returned. If the bucket has a sink in the same project pointing to it, FAILED_PRECONDITION will be returned.

      Args:
        request: (LoggingFoldersLocationsBucketsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'DELETE',
        method_id=u'logging.folders.locations.buckets.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingFoldersLocationsBucketsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a bucket.

      Args:
        request: (LoggingFoldersLocationsBucketsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'GET',
        method_id=u'logging.folders.locations.buckets.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingFoldersLocationsBucketsGetRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists buckets.

      Args:
        request: (LoggingFoldersLocationsBucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBucketsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/locations/{locationsId}/buckets',
        http_method=u'GET',
        method_id=u'logging.folders.locations.buckets.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/buckets',
        request_field='',
        request_type_name=u'LoggingFoldersLocationsBucketsListRequest',
        response_type_name=u'ListBucketsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a bucket. This method replaces the following fields in the existing bucket with values from the new bucket: retention_periodIf the retention period is decreased and the bucket is locked, FAILED_PRECONDITION will be returned.A buckets region may not be modified after it is created.

      Args:
        request: (LoggingFoldersLocationsBucketsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'PATCH',
        method_id=u'logging.folders.locations.buckets.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logBucket',
        request_type_name=u'LoggingFoldersLocationsBucketsPatchRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

  class FoldersLocationsService(base_api.BaseApiService):
    """Service class for the folders_locations resource."""

    _NAME = u'folders_locations'

    def __init__(self, client):
      super(LoggingV2.FoldersLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class FoldersLogsService(base_api.BaseApiService):
    """Service class for the folders_logs resource."""

    _NAME = u'folders_logs'

    def __init__(self, client):
      super(LoggingV2.FoldersLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes all the log entries in a log. The log reappears if it receives new entries. Log entries written shortly before the delete operation might not be deleted.

      Args:
        request: (LoggingFoldersLogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/logs/{logsId}',
        http_method=u'DELETE',
        method_id=u'logging.folders.logs.delete',
        ordered_params=[u'logName'],
        path_params=[u'logName'],
        query_params=[],
        relative_path=u'v2/{+logName}',
        request_field='',
        request_type_name=u'LoggingFoldersLogsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the logs in projects, organizations, folders, or billing accounts. Only logs that have entries are listed.

      Args:
        request: (LoggingFoldersLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/logs',
        http_method=u'GET',
        method_id=u'logging.folders.logs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'resourceNames'],
        relative_path=u'v2/{+parent}/logs',
        request_field='',
        request_type_name=u'LoggingFoldersLogsListRequest',
        response_type_name=u'ListLogsResponse',
        supports_download=False,
    )

  class FoldersSinksService(base_api.BaseApiService):
    """Service class for the folders_sinks resource."""

    _NAME = u'folders_sinks'

    def __init__(self, client):
      super(LoggingV2.FoldersSinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports specified log entries to a destination. The export of newly-ingested log entries begins immediately, unless the sink's writer_identity is not permitted to write to the destination. A sink can export log entries only from the resource owning the sink.

      Args:
        request: (LoggingFoldersSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks',
        http_method=u'POST',
        method_id=u'logging.folders.sinks.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'uniqueWriterIdentity'],
        relative_path=u'v2/{+parent}/sinks',
        request_field=u'logSink',
        request_type_name=u'LoggingFoldersSinksCreateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink. If the sink has a unique writer_identity, then that service account is also deleted.

      Args:
        request: (LoggingFoldersSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks/{sinksId}',
        http_method=u'DELETE',
        method_id=u'logging.folders.sinks.delete',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingFoldersSinksDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a sink.

      Args:
        request: (LoggingFoldersSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks/{sinksId}',
        http_method=u'GET',
        method_id=u'logging.folders.sinks.get',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingFoldersSinksGetRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists sinks.

      Args:
        request: (LoggingFoldersSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks',
        http_method=u'GET',
        method_id=u'logging.folders.sinks.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/sinks',
        request_field='',
        request_type_name=u'LoggingFoldersSinksListRequest',
        response_type_name=u'ListSinksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter.The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingFoldersSinksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks/{sinksId}',
        http_method=u'PATCH',
        method_id=u'logging.folders.sinks.patch',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingFoldersSinksPatchRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter.The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingFoldersSinksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/folders/{foldersId}/sinks/{sinksId}',
        http_method=u'PUT',
        method_id=u'logging.folders.sinks.update',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingFoldersSinksUpdateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

  class FoldersService(base_api.BaseApiService):
    """Service class for the folders resource."""

    _NAME = u'folders'

    def __init__(self, client):
      super(LoggingV2.FoldersService, self).__init__(client)
      self._upload_configs = {
          }

  class LocationsBucketsService(base_api.BaseApiService):
    """Service class for the locations_buckets resource."""

    _NAME = u'locations_buckets'

    def __init__(self, client):
      super(LoggingV2.LocationsBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a bucket that can be used to store log entries. Once a bucket has been created, the region cannot be changed.

      Args:
        request: (LoggingLocationsBucketsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/locations/{locationsId}/buckets',
        http_method=u'POST',
        method_id=u'logging.locations.buckets.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'bucketId'],
        relative_path=u'v2/{+parent}/buckets',
        request_field=u'logBucket',
        request_type_name=u'LoggingLocationsBucketsCreateRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a bucket. All views and logs in the bucket are deleted. If the bucket is non-empty and locked, FAILED_PRECONDITION will be returned. If the bucket has a sink in the same project pointing to it, FAILED_PRECONDITION will be returned.

      Args:
        request: (LoggingLocationsBucketsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'DELETE',
        method_id=u'logging.locations.buckets.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingLocationsBucketsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

  class LocationsService(base_api.BaseApiService):
    """Service class for the locations resource."""

    _NAME = u'locations'

    def __init__(self, client):
      super(LoggingV2.LocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class LogsService(base_api.BaseApiService):
    """Service class for the logs resource."""

    _NAME = u'logs'

    def __init__(self, client):
      super(LoggingV2.LogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes all the log entries in a log. The log reappears if it receives new entries. Log entries written shortly before the delete operation might not be deleted.

      Args:
        request: (LoggingLogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/logs/{logsId}',
        http_method=u'DELETE',
        method_id=u'logging.logs.delete',
        ordered_params=[u'logName'],
        path_params=[u'logName'],
        query_params=[],
        relative_path=u'v2/{+logName}',
        request_field='',
        request_type_name=u'LoggingLogsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the logs in projects, organizations, folders, or billing accounts. Only logs that have entries are listed.

      Args:
        request: (LoggingLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/logs',
        http_method=u'GET',
        method_id=u'logging.logs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'resourceNames'],
        relative_path=u'v2/{+parent}/logs',
        request_field='',
        request_type_name=u'LoggingLogsListRequest',
        response_type_name=u'ListLogsResponse',
        supports_download=False,
    )

  class MonitoredResourceDescriptorsService(base_api.BaseApiService):
    """Service class for the monitoredResourceDescriptors resource."""

    _NAME = u'monitoredResourceDescriptors'

    def __init__(self, client):
      super(LoggingV2.MonitoredResourceDescriptorsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the descriptors for monitored resource types used by Logging.

      Args:
        request: (LoggingMonitoredResourceDescriptorsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMonitoredResourceDescriptorsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'logging.monitoredResourceDescriptors.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/monitoredResourceDescriptors',
        request_field='',
        request_type_name=u'LoggingMonitoredResourceDescriptorsListRequest',
        response_type_name=u'ListMonitoredResourceDescriptorsResponse',
        supports_download=False,
    )

  class OrganizationsExclusionsService(base_api.BaseApiService):
    """Service class for the organizations_exclusions resource."""

    _NAME = u'organizations_exclusions'

    def __init__(self, client):
      super(LoggingV2.OrganizationsExclusionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new exclusion in a specified parent resource. Only log entries belonging to that resource can be excluded. You can have up to 10 exclusions in a resource.

      Args:
        request: (LoggingOrganizationsExclusionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/exclusions',
        http_method=u'POST',
        method_id=u'logging.organizations.exclusions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/exclusions',
        request_field=u'logExclusion',
        request_type_name=u'LoggingOrganizationsExclusionsCreateRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an exclusion.

      Args:
        request: (LoggingOrganizationsExclusionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/exclusions/{exclusionsId}',
        http_method=u'DELETE',
        method_id=u'logging.organizations.exclusions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingOrganizationsExclusionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the description of an exclusion.

      Args:
        request: (LoggingOrganizationsExclusionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/exclusions/{exclusionsId}',
        http_method=u'GET',
        method_id=u'logging.organizations.exclusions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingOrganizationsExclusionsGetRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the exclusions in a parent resource.

      Args:
        request: (LoggingOrganizationsExclusionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExclusionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/exclusions',
        http_method=u'GET',
        method_id=u'logging.organizations.exclusions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/exclusions',
        request_field='',
        request_type_name=u'LoggingOrganizationsExclusionsListRequest',
        response_type_name=u'ListExclusionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Changes one or more properties of an existing exclusion.

      Args:
        request: (LoggingOrganizationsExclusionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/exclusions/{exclusionsId}',
        http_method=u'PATCH',
        method_id=u'logging.organizations.exclusions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logExclusion',
        request_type_name=u'LoggingOrganizationsExclusionsPatchRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

  class OrganizationsLocationsBucketsService(base_api.BaseApiService):
    """Service class for the organizations_locations_buckets resource."""

    _NAME = u'organizations_locations_buckets'

    def __init__(self, client):
      super(LoggingV2.OrganizationsLocationsBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a bucket that can be used to store log entries. Once a bucket has been created, the region cannot be changed.

      Args:
        request: (LoggingOrganizationsLocationsBucketsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/buckets',
        http_method=u'POST',
        method_id=u'logging.organizations.locations.buckets.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'bucketId'],
        relative_path=u'v2/{+parent}/buckets',
        request_field=u'logBucket',
        request_type_name=u'LoggingOrganizationsLocationsBucketsCreateRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a bucket. All views and logs in the bucket are deleted. If the bucket is non-empty and locked, FAILED_PRECONDITION will be returned. If the bucket has a sink in the same project pointing to it, FAILED_PRECONDITION will be returned.

      Args:
        request: (LoggingOrganizationsLocationsBucketsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'DELETE',
        method_id=u'logging.organizations.locations.buckets.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingOrganizationsLocationsBucketsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a bucket.

      Args:
        request: (LoggingOrganizationsLocationsBucketsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'GET',
        method_id=u'logging.organizations.locations.buckets.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingOrganizationsLocationsBucketsGetRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists buckets.

      Args:
        request: (LoggingOrganizationsLocationsBucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBucketsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/buckets',
        http_method=u'GET',
        method_id=u'logging.organizations.locations.buckets.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/buckets',
        request_field='',
        request_type_name=u'LoggingOrganizationsLocationsBucketsListRequest',
        response_type_name=u'ListBucketsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a bucket. This method replaces the following fields in the existing bucket with values from the new bucket: retention_periodIf the retention period is decreased and the bucket is locked, FAILED_PRECONDITION will be returned.A buckets region may not be modified after it is created.

      Args:
        request: (LoggingOrganizationsLocationsBucketsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'PATCH',
        method_id=u'logging.organizations.locations.buckets.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logBucket',
        request_type_name=u'LoggingOrganizationsLocationsBucketsPatchRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

  class OrganizationsLocationsService(base_api.BaseApiService):
    """Service class for the organizations_locations resource."""

    _NAME = u'organizations_locations'

    def __init__(self, client):
      super(LoggingV2.OrganizationsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsLogsService(base_api.BaseApiService):
    """Service class for the organizations_logs resource."""

    _NAME = u'organizations_logs'

    def __init__(self, client):
      super(LoggingV2.OrganizationsLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes all the log entries in a log. The log reappears if it receives new entries. Log entries written shortly before the delete operation might not be deleted.

      Args:
        request: (LoggingOrganizationsLogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/logs/{logsId}',
        http_method=u'DELETE',
        method_id=u'logging.organizations.logs.delete',
        ordered_params=[u'logName'],
        path_params=[u'logName'],
        query_params=[],
        relative_path=u'v2/{+logName}',
        request_field='',
        request_type_name=u'LoggingOrganizationsLogsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the logs in projects, organizations, folders, or billing accounts. Only logs that have entries are listed.

      Args:
        request: (LoggingOrganizationsLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/logs',
        http_method=u'GET',
        method_id=u'logging.organizations.logs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'resourceNames'],
        relative_path=u'v2/{+parent}/logs',
        request_field='',
        request_type_name=u'LoggingOrganizationsLogsListRequest',
        response_type_name=u'ListLogsResponse',
        supports_download=False,
    )

  class OrganizationsSinksService(base_api.BaseApiService):
    """Service class for the organizations_sinks resource."""

    _NAME = u'organizations_sinks'

    def __init__(self, client):
      super(LoggingV2.OrganizationsSinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports specified log entries to a destination. The export of newly-ingested log entries begins immediately, unless the sink's writer_identity is not permitted to write to the destination. A sink can export log entries only from the resource owning the sink.

      Args:
        request: (LoggingOrganizationsSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks',
        http_method=u'POST',
        method_id=u'logging.organizations.sinks.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'uniqueWriterIdentity'],
        relative_path=u'v2/{+parent}/sinks',
        request_field=u'logSink',
        request_type_name=u'LoggingOrganizationsSinksCreateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink. If the sink has a unique writer_identity, then that service account is also deleted.

      Args:
        request: (LoggingOrganizationsSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks/{sinksId}',
        http_method=u'DELETE',
        method_id=u'logging.organizations.sinks.delete',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingOrganizationsSinksDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a sink.

      Args:
        request: (LoggingOrganizationsSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks/{sinksId}',
        http_method=u'GET',
        method_id=u'logging.organizations.sinks.get',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingOrganizationsSinksGetRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists sinks.

      Args:
        request: (LoggingOrganizationsSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks',
        http_method=u'GET',
        method_id=u'logging.organizations.sinks.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/sinks',
        request_field='',
        request_type_name=u'LoggingOrganizationsSinksListRequest',
        response_type_name=u'ListSinksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter.The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingOrganizationsSinksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks/{sinksId}',
        http_method=u'PATCH',
        method_id=u'logging.organizations.sinks.patch',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingOrganizationsSinksPatchRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter.The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingOrganizationsSinksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/sinks/{sinksId}',
        http_method=u'PUT',
        method_id=u'logging.organizations.sinks.update',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingOrganizationsSinksUpdateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = u'organizations'

    def __init__(self, client):
      super(LoggingV2.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetCmekSettings(self, request, global_params=None):
      r"""Gets the Logs Router CMEK settings for the given resource.Note: CMEK for the Logs Router can currently only be configured for GCP organizations. Once configured, it applies to all projects and folders in the GCP organization.See Enabling CMEK for Logs Router for more information.

      Args:
        request: (LoggingOrganizationsGetCmekSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CmekSettings) The response message.
      """
      config = self.GetMethodConfig('GetCmekSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetCmekSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/cmekSettings',
        http_method=u'GET',
        method_id=u'logging.organizations.getCmekSettings',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}/cmekSettings',
        request_field='',
        request_type_name=u'LoggingOrganizationsGetCmekSettingsRequest',
        response_type_name=u'CmekSettings',
        supports_download=False,
    )

    def UpdateCmekSettings(self, request, global_params=None):
      r"""Updates the Logs Router CMEK settings for the given resource.Note: CMEK for the Logs Router can currently only be configured for GCP organizations. Once configured, it applies to all projects and folders in the GCP organization.UpdateCmekSettings will fail if 1) kms_key_name is invalid, or 2) the associated service account does not have the required roles/cloudkms.cryptoKeyEncrypterDecrypter role assigned for the key, or 3) access to the key is disabled.See Enabling CMEK for Logs Router for more information.

      Args:
        request: (LoggingOrganizationsUpdateCmekSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CmekSettings) The response message.
      """
      config = self.GetMethodConfig('UpdateCmekSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateCmekSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/organizations/{organizationsId}/cmekSettings',
        http_method=u'PATCH',
        method_id=u'logging.organizations.updateCmekSettings',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}/cmekSettings',
        request_field=u'cmekSettings',
        request_type_name=u'LoggingOrganizationsUpdateCmekSettingsRequest',
        response_type_name=u'CmekSettings',
        supports_download=False,
    )

  class ProjectsExclusionsService(base_api.BaseApiService):
    """Service class for the projects_exclusions resource."""

    _NAME = u'projects_exclusions'

    def __init__(self, client):
      super(LoggingV2.ProjectsExclusionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new exclusion in a specified parent resource. Only log entries belonging to that resource can be excluded. You can have up to 10 exclusions in a resource.

      Args:
        request: (LoggingProjectsExclusionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/exclusions',
        http_method=u'POST',
        method_id=u'logging.projects.exclusions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/exclusions',
        request_field=u'logExclusion',
        request_type_name=u'LoggingProjectsExclusionsCreateRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an exclusion.

      Args:
        request: (LoggingProjectsExclusionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/exclusions/{exclusionsId}',
        http_method=u'DELETE',
        method_id=u'logging.projects.exclusions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingProjectsExclusionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the description of an exclusion.

      Args:
        request: (LoggingProjectsExclusionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/exclusions/{exclusionsId}',
        http_method=u'GET',
        method_id=u'logging.projects.exclusions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingProjectsExclusionsGetRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the exclusions in a parent resource.

      Args:
        request: (LoggingProjectsExclusionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListExclusionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/exclusions',
        http_method=u'GET',
        method_id=u'logging.projects.exclusions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/exclusions',
        request_field='',
        request_type_name=u'LoggingProjectsExclusionsListRequest',
        response_type_name=u'ListExclusionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Changes one or more properties of an existing exclusion.

      Args:
        request: (LoggingProjectsExclusionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogExclusion) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/exclusions/{exclusionsId}',
        http_method=u'PATCH',
        method_id=u'logging.projects.exclusions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logExclusion',
        request_type_name=u'LoggingProjectsExclusionsPatchRequest',
        response_type_name=u'LogExclusion',
        supports_download=False,
    )

  class ProjectsLocationsBucketsService(base_api.BaseApiService):
    """Service class for the projects_locations_buckets resource."""

    _NAME = u'projects_locations_buckets'

    def __init__(self, client):
      super(LoggingV2.ProjectsLocationsBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a bucket that can be used to store log entries. Once a bucket has been created, the region cannot be changed.

      Args:
        request: (LoggingProjectsLocationsBucketsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/buckets',
        http_method=u'POST',
        method_id=u'logging.projects.locations.buckets.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'bucketId'],
        relative_path=u'v2/{+parent}/buckets',
        request_field=u'logBucket',
        request_type_name=u'LoggingProjectsLocationsBucketsCreateRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a bucket. All views and logs in the bucket are deleted. If the bucket is non-empty and locked, FAILED_PRECONDITION will be returned. If the bucket has a sink in the same project pointing to it, FAILED_PRECONDITION will be returned.

      Args:
        request: (LoggingProjectsLocationsBucketsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'DELETE',
        method_id=u'logging.projects.locations.buckets.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingProjectsLocationsBucketsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a bucket.

      Args:
        request: (LoggingProjectsLocationsBucketsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'GET',
        method_id=u'logging.projects.locations.buckets.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'LoggingProjectsLocationsBucketsGetRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists buckets.

      Args:
        request: (LoggingProjectsLocationsBucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBucketsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/buckets',
        http_method=u'GET',
        method_id=u'logging.projects.locations.buckets.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/buckets',
        request_field='',
        request_type_name=u'LoggingProjectsLocationsBucketsListRequest',
        response_type_name=u'ListBucketsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a bucket. This method replaces the following fields in the existing bucket with values from the new bucket: retention_periodIf the retention period is decreased and the bucket is locked, FAILED_PRECONDITION will be returned.A buckets region may not be modified after it is created.

      Args:
        request: (LoggingProjectsLocationsBucketsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogBucket) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}/buckets/{bucketsId}',
        http_method=u'PATCH',
        method_id=u'logging.projects.locations.buckets.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'logBucket',
        request_type_name=u'LoggingProjectsLocationsBucketsPatchRequest',
        response_type_name=u'LogBucket',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(LoggingV2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLogsService(base_api.BaseApiService):
    """Service class for the projects_logs resource."""

    _NAME = u'projects_logs'

    def __init__(self, client):
      super(LoggingV2.ProjectsLogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes all the log entries in a log. The log reappears if it receives new entries. Log entries written shortly before the delete operation might not be deleted.

      Args:
        request: (LoggingProjectsLogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/logs/{logsId}',
        http_method=u'DELETE',
        method_id=u'logging.projects.logs.delete',
        ordered_params=[u'logName'],
        path_params=[u'logName'],
        query_params=[],
        relative_path=u'v2/{+logName}',
        request_field='',
        request_type_name=u'LoggingProjectsLogsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the logs in projects, organizations, folders, or billing accounts. Only logs that have entries are listed.

      Args:
        request: (LoggingProjectsLogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/logs',
        http_method=u'GET',
        method_id=u'logging.projects.logs.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'resourceNames'],
        relative_path=u'v2/{+parent}/logs',
        request_field='',
        request_type_name=u'LoggingProjectsLogsListRequest',
        response_type_name=u'ListLogsResponse',
        supports_download=False,
    )

  class ProjectsMetricsService(base_api.BaseApiService):
    """Service class for the projects_metrics resource."""

    _NAME = u'projects_metrics'

    def __init__(self, client):
      super(LoggingV2.ProjectsMetricsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a logs-based metric.

      Args:
        request: (LoggingProjectsMetricsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogMetric) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/metrics',
        http_method=u'POST',
        method_id=u'logging.projects.metrics.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/metrics',
        request_field=u'logMetric',
        request_type_name=u'LoggingProjectsMetricsCreateRequest',
        response_type_name=u'LogMetric',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a logs-based metric.

      Args:
        request: (LoggingProjectsMetricsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/metrics/{metricsId}',
        http_method=u'DELETE',
        method_id=u'logging.projects.metrics.delete',
        ordered_params=[u'metricName'],
        path_params=[u'metricName'],
        query_params=[],
        relative_path=u'v2/{+metricName}',
        request_field='',
        request_type_name=u'LoggingProjectsMetricsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a logs-based metric.

      Args:
        request: (LoggingProjectsMetricsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogMetric) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/metrics/{metricsId}',
        http_method=u'GET',
        method_id=u'logging.projects.metrics.get',
        ordered_params=[u'metricName'],
        path_params=[u'metricName'],
        query_params=[],
        relative_path=u'v2/{+metricName}',
        request_field='',
        request_type_name=u'LoggingProjectsMetricsGetRequest',
        response_type_name=u'LogMetric',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists logs-based metrics.

      Args:
        request: (LoggingProjectsMetricsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLogMetricsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/metrics',
        http_method=u'GET',
        method_id=u'logging.projects.metrics.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/metrics',
        request_field='',
        request_type_name=u'LoggingProjectsMetricsListRequest',
        response_type_name=u'ListLogMetricsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Creates or updates a logs-based metric.

      Args:
        request: (LoggingProjectsMetricsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogMetric) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/metrics/{metricsId}',
        http_method=u'PUT',
        method_id=u'logging.projects.metrics.update',
        ordered_params=[u'metricName'],
        path_params=[u'metricName'],
        query_params=[],
        relative_path=u'v2/{+metricName}',
        request_field=u'logMetric',
        request_type_name=u'LoggingProjectsMetricsUpdateRequest',
        response_type_name=u'LogMetric',
        supports_download=False,
    )

  class ProjectsSinksService(base_api.BaseApiService):
    """Service class for the projects_sinks resource."""

    _NAME = u'projects_sinks'

    def __init__(self, client):
      super(LoggingV2.ProjectsSinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports specified log entries to a destination. The export of newly-ingested log entries begins immediately, unless the sink's writer_identity is not permitted to write to the destination. A sink can export log entries only from the resource owning the sink.

      Args:
        request: (LoggingProjectsSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks',
        http_method=u'POST',
        method_id=u'logging.projects.sinks.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'uniqueWriterIdentity'],
        relative_path=u'v2/{+parent}/sinks',
        request_field=u'logSink',
        request_type_name=u'LoggingProjectsSinksCreateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink. If the sink has a unique writer_identity, then that service account is also deleted.

      Args:
        request: (LoggingProjectsSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks/{sinksId}',
        http_method=u'DELETE',
        method_id=u'logging.projects.sinks.delete',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingProjectsSinksDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a sink.

      Args:
        request: (LoggingProjectsSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks/{sinksId}',
        http_method=u'GET',
        method_id=u'logging.projects.sinks.get',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingProjectsSinksGetRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists sinks.

      Args:
        request: (LoggingProjectsSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks',
        http_method=u'GET',
        method_id=u'logging.projects.sinks.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/sinks',
        request_field='',
        request_type_name=u'LoggingProjectsSinksListRequest',
        response_type_name=u'ListSinksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter.The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingProjectsSinksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks/{sinksId}',
        http_method=u'PATCH',
        method_id=u'logging.projects.sinks.patch',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingProjectsSinksPatchRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter.The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingProjectsSinksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/sinks/{sinksId}',
        http_method=u'PUT',
        method_id=u'logging.projects.sinks.update',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingProjectsSinksUpdateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(LoggingV2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class SinksService(base_api.BaseApiService):
    """Service class for the sinks resource."""

    _NAME = u'sinks'

    def __init__(self, client):
      super(LoggingV2.SinksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a sink that exports specified log entries to a destination. The export of newly-ingested log entries begins immediately, unless the sink's writer_identity is not permitted to write to the destination. A sink can export log entries only from the resource owning the sink.

      Args:
        request: (LoggingSinksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/sinks',
        http_method=u'POST',
        method_id=u'logging.sinks.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'uniqueWriterIdentity'],
        relative_path=u'v2/{+parent}/sinks',
        request_field=u'logSink',
        request_type_name=u'LoggingSinksCreateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a sink. If the sink has a unique writer_identity, then that service account is also deleted.

      Args:
        request: (LoggingSinksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/sinks/{sinksId}',
        http_method=u'DELETE',
        method_id=u'logging.sinks.delete',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingSinksDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a sink.

      Args:
        request: (LoggingSinksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/sinks/{sinksId}',
        http_method=u'GET',
        method_id=u'logging.sinks.get',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[],
        relative_path=u'v2/{+sinkName}',
        request_field='',
        request_type_name=u'LoggingSinksGetRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists sinks.

      Args:
        request: (LoggingSinksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSinksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/sinks',
        http_method=u'GET',
        method_id=u'logging.sinks.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/sinks',
        request_field='',
        request_type_name=u'LoggingSinksListRequest',
        response_type_name=u'ListSinksResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a sink. This method replaces the following fields in the existing sink with values from the new sink: destination, and filter.The updated sink might also have a new writer_identity; see the unique_writer_identity field.

      Args:
        request: (LoggingSinksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LogSink) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/sinks/{sinksId}',
        http_method=u'PUT',
        method_id=u'logging.sinks.update',
        ordered_params=[u'sinkName'],
        path_params=[u'sinkName'],
        query_params=[u'uniqueWriterIdentity', u'updateMask'],
        relative_path=u'v2/{+sinkName}',
        request_field=u'logSink',
        request_type_name=u'LoggingSinksUpdateRequest',
        response_type_name=u'LogSink',
        supports_download=False,
    )

  class V2Service(base_api.BaseApiService):
    """Service class for the v2 resource."""

    _NAME = u'v2'

    def __init__(self, client):
      super(LoggingV2.V2Service, self).__init__(client)
      self._upload_configs = {
          }

    def GetCmekSettings(self, request, global_params=None):
      r"""Gets the Logs Router CMEK settings for the given resource.Note: CMEK for the Logs Router can currently only be configured for GCP organizations. Once configured, it applies to all projects and folders in the GCP organization.See Enabling CMEK for Logs Router for more information.

      Args:
        request: (LoggingGetCmekSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CmekSettings) The response message.
      """
      config = self.GetMethodConfig('GetCmekSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetCmekSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/cmekSettings',
        http_method=u'GET',
        method_id=u'logging.getCmekSettings',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}/cmekSettings',
        request_field='',
        request_type_name=u'LoggingGetCmekSettingsRequest',
        response_type_name=u'CmekSettings',
        supports_download=False,
    )

    def UpdateCmekSettings(self, request, global_params=None):
      r"""Updates the Logs Router CMEK settings for the given resource.Note: CMEK for the Logs Router can currently only be configured for GCP organizations. Once configured, it applies to all projects and folders in the GCP organization.UpdateCmekSettings will fail if 1) kms_key_name is invalid, or 2) the associated service account does not have the required roles/cloudkms.cryptoKeyEncrypterDecrypter role assigned for the key, or 3) access to the key is disabled.See Enabling CMEK for Logs Router for more information.

      Args:
        request: (LoggingUpdateCmekSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CmekSettings) The response message.
      """
      config = self.GetMethodConfig('UpdateCmekSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateCmekSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/{v2Id}/{v2Id1}/cmekSettings',
        http_method=u'PATCH',
        method_id=u'logging.updateCmekSettings',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}/cmekSettings',
        request_field=u'cmekSettings',
        request_type_name=u'LoggingUpdateCmekSettingsRequest',
        response_type_name=u'CmekSettings',
        supports_download=False,
    )
