/**
 * @file layer.hpp
 * @author Marcus Edel
 *
 * This includes various layers to construct a model.
 *
 * mlpack is free software; you may redistribute it and/or modify it under the
 * terms of the 3-clause BSD license.  You should have received a copy of the
 * 3-clause BSD license along with mlpack.  If not, see
 * http://www.opensource.org/licenses/BSD-3-Clause for more information.
 */
#ifndef MLPACK_METHODS_ANN_LAYER_LAYER_HPP
#define MLPACK_METHODS_ANN_LAYER_LAYER_HPP

#include "add_merge.hpp"
#include "atrous_convolution.hpp"
#include "batch_norm.hpp"
#include "concat_performance.hpp"
#include "convolution.hpp"
#include "dropconnect.hpp"
#include "glimpse.hpp"
#include "layer_norm.hpp"
#include "layer_types.hpp"
#include "linear.hpp"
#include "linear_no_bias.hpp"
#include "lstm.hpp"
#include "multiply_merge.hpp"
#include "gru.hpp"
#include "fast_lstm.hpp"
#include "recurrent.hpp"
#include "recurrent_attention.hpp"
#include "reparametrization.hpp"
#include "sequential.hpp"
#include "subview.hpp"
#include "concat.hpp"
#include "vr_class_reward.hpp"
#include "transposed_convolution.hpp"

#endif
