/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.strings;

import com.projectlibre1.strings.DirectoryClassLoader;
import com.projectlibre1.util.ClassLoaderUtils;
import com.projectlibre1.util.Environment;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Messages {
    private static final String META_BUNDLE_NAME = "com.projectlibre1.configuration.meta";
    private static ResourceBundle metaBundle = null;
    static LinkedList<ResourceBundle> bundles = null;
    static DirectoryClassLoader directoryClassLoader = new DirectoryClassLoader();
    static Lock lock = new ReentrantLock();
    private static ResourceBundle[] bundleArray = null;

    public static void setMetaBundle(String string) {
        metaBundle = ResourceBundle.getBundle(string, Locale.getDefault(), ClassLoaderUtils.getLocalClassLoader());
    }

    public static String getMetaString(String string) {
        if (metaBundle == null) {
            lock.lock();
            try {
                if (metaBundle == null) {
                    metaBundle = ResourceBundle.getBundle(META_BUNDLE_NAME, Locale.getDefault(), ClassLoaderUtils.getLocalClassLoader());
                }
            }
            finally {
                lock.unlock();
            }
        }
        return metaBundle.getString(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromBundles(String string) {
        if (string == null) {
            return null;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        if (bundles == null) {
            lock.lock();
            try {
                if (bundles == null) {
                    Object object;
                    int n;
                    String[] stringArray = Messages.getMetaString("ResourceBundles").split(";");
                    String[] stringArray2 = Messages.getMetaString("DirectoryResourceBundles").split(";");
                    if (directoryClassLoader.isValid()) {
                        for (n = 0; n < stringArray2.length; ++n) {
                            try {
                                object = ResourceBundle.getBundle(stringArray2[n], Locale.getDefault(), directoryClassLoader);
                                linkedList.add(object);
                                linkedList2.add("com.projectlibre1.strings." + stringArray2[n]);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    } else {
                        linkedList = new LinkedList();
                    }
                    for (n = stringArray.length - 1; n >= 0; --n) {
                        String string2;
                        object = stringArray[n];
                        boolean bl = false;
                        int n2 = 0;
                        Iterator iterator = linkedList2.iterator();
                        while (iterator.hasNext() && !((String)object).equals(string2 = (String)iterator.next())) {
                            ++n2;
                        }
                        linkedList.add(n2, ResourceBundle.getBundle((String)object, Locale.getDefault(), ClassLoaderUtils.getLocalClassLoader()));
                        linkedList2.add(n2, object);
                    }
                }
            }
            finally {
                bundles = linkedList;
                lock.unlock();
            }
        }
        for (ResourceBundle resourceBundle : bundles) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }

    public static String getString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Messages.getStringFromBundles(string);
        if (string2 == null) {
            string2 = '!' + string + '!';
        }
        return string2;
    }

    public static String getStringOrSelf(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Messages.getStringFromBundles(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static Properties getTipProperties() {
        return Messages.getProperties(bundles.get(1));
    }

    public static Properties getProperties(ResourceBundle resourceBundle) {
        Properties properties = new Properties();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            properties.put(string, resourceBundle.getString(string));
        }
        return properties;
    }

    public static String getStringWithParam(String string, String string2) {
        return MessageFormat.format(Messages.getString(string), string2);
    }

    public static String getStringWithParam(String string, Object[] objectArray) {
        return MessageFormat.format(Messages.getString(string), objectArray);
    }

    public static String toAppletVersion(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < 4; ++i) {
            int n;
            int n2 = n = i >= stringArray.length ? 0 : Integer.parseInt(stringArray[i]);
            if (i > 0) {
                stringBuffer.append('.');
            }
            String string2 = Integer.toHexString(n);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String getContextString(String string) {
        if (Environment.isProjectLibre()) {
            String string2 = Messages.getStringFromBundles("Open_" + string);
            if (string2 == null) {
                System.out.println("getContextString not found Open_" + string);
            } else {
                return string2;
            }
        }
        return Messages.getStringFromBundles(string);
    }
}

