/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0016H\u0000\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001f"}, d2={"VARIABLE_MODIFIERS", "", "", "getVARIABLE_MODIFIERS", "()Ljava/util/Set;", "checkModifierIsNotAllowed", "", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "modifier", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "message", "checkVariableModifiers", "variableDeclaration", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariableDeclaration;", "registerLocalFix", "Lcom/intellij/lang/annotation/AnnotationBuilder;", "annotationBuilder", "fix", "Lcom/intellij/codeInspection/LocalQuickFix;", "place", "Lcom/intellij/psi/PsiElement;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "range", "Lcom/intellij/openapi/util/TextRange;", "createDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Lcom/intellij/lang/annotation/Annotation;", "element", "intellij.groovy.psi"})
public final class UtilKt {
    @NotNull
    private static final Set<String> VARIABLE_MODIFIERS = SetsKt.setOf((Object[])new String[]{"def", "final"});

    @NotNull
    public static final Set<String> getVARIABLE_MODIFIERS() {
        return VARIABLE_MODIFIERS;
    }

    public static final void checkVariableModifiers(@NotNull AnnotationHolder holder, @NotNull GrVariableDeclaration variableDeclaration) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)variableDeclaration, (String)"variableDeclaration");
        GrModifierList grModifierList = variableDeclaration.getModifierList();
        Intrinsics.checkExpressionValueIsNotNull((Object)grModifierList, (String)"variableDeclaration.modifierList");
        GrModifierList modifierList = grModifierList;
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (VARIABLE_MODIFIERS.contains(modifier)) continue;
            String string = modifier;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"modifier");
            String string2 = GroovyBundle.message("variable.cannot.be", modifier);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GroovyBundle.message(\"va\u2026ble.cannot.be\", modifier)");
            UtilKt.checkModifierIsNotAllowed(modifierList, string, string2, holder);
        }
    }

    public static final void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)modifierList, (String)"modifierList");
        Intrinsics.checkParameterIsNotNull((Object)modifier, (String)"modifier");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        String string = GroovyBundle.message("modifier.0.not.allowed", modifier);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GroovyBundle.message(\"mo\u20260.not.allowed\", modifier)");
        UtilKt.checkModifierIsNotAllowed(modifierList, modifier, string, holder);
    }

    public static final void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier, @NotNull String message, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)modifierList, (String)"modifierList");
        Intrinsics.checkParameterIsNotNull((Object)modifier, (String)"modifier");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiElement psiElement = modifierList.getModifier(modifier);
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"modifierList.getModifier(modifier) ?: return");
        PsiElement modifierElement = psiElement;
        AnnotationBuilder annotationBuilder = holder.newAnnotation(HighlightSeverity.ERROR, message).range(modifierElement);
        Intrinsics.checkExpressionValueIsNotNull((Object)annotationBuilder, (String)"holder.newAnnotation(Hig\u2026e).range(modifierElement)");
        AnnotationBuilder builder = annotationBuilder;
        GrRemoveModifierFix fix = new GrRemoveModifierFix(modifier, GroovyBundle.message("remove.modifier", modifier));
        LocalQuickFix localQuickFix = fix;
        TextRange textRange = modifierElement.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"modifierElement.textRange");
        builder = UtilKt.registerLocalFix(builder, localQuickFix, modifierElement, message, ProblemHighlightType.ERROR, textRange);
        builder.create();
    }

    @NotNull
    public static final AnnotationBuilder registerLocalFix(@NotNull AnnotationBuilder annotationBuilder, @NotNull LocalQuickFix fix, @NotNull PsiElement place, @NotNull String message, @NotNull ProblemHighlightType problemHighlightType, @NotNull TextRange range) {
        Intrinsics.checkParameterIsNotNull((Object)annotationBuilder, (String)"annotationBuilder");
        Intrinsics.checkParameterIsNotNull((Object)fix, (String)"fix");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)problemHighlightType, (String)"problemHighlightType");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        InspectionManager manager = InspectionManager.getInstance((Project)place.getProject());
        TextRange textRange = place.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"place.textRange");
        boolean bl = !textRange.isEmpty();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            PsiFile psiFile = place.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"place.containingFile");
            String string = psiFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"place.containingFile.name");
            String string2 = string;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(place, place, message, problemHighlightType, true, new LocalQuickFix[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026oblemHighlightType, true)");
        ProblemDescriptor descriptor2 = problemDescriptor;
        AnnotationBuilder annotationBuilder2 = annotationBuilder.newLocalQuickFix(fix, descriptor2).range(range).registerFix();
        Intrinsics.checkExpressionValueIsNotNull((Object)annotationBuilder2, (String)"annotationBuilder.newLoc\u2026ange(range).registerFix()");
        return annotationBuilder2;
    }

    @NotNull
    public static final ProblemDescriptor createDescriptor(@NotNull Annotation $this$createDescriptor, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createDescriptor, (String)"$this$createDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)element.getProject()).createProblemDescriptor(element, element, $this$createDescriptor.getMessage(), $this$createDescriptor.getHighlightType(), true, new LocalQuickFix[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"InspectionManager.getIns\u2026age, highlightType, true)");
        return problemDescriptor;
    }
}

