/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public class CreateLocalVariableFromUsageFix
extends Intention {
    private final GrVariableDeclarationOwner myOwner;
    private final GrReferenceExpression myRefExpression;

    public CreateLocalVariableFromUsageFix(GrReferenceExpression refExpression, GrVariableDeclarationOwner owner) {
        this.myRefExpression = refExpression;
        this.myOwner = owner;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.variable.from.usage.family.name", new Object[0]);
        if (string == null) {
            CreateLocalVariableFromUsageFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("create.variable.from.usage", this.myRefExpression.getReferenceName());
        if (string == null) {
            CreateLocalVariableFromUsageFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateLocalVariableFromUsageFix.$$$reportNull$$$0(2);
        }
        return this.myOwner.isValid() && this.myRefExpression.isValid();
    }

    @Nullable
    protected static Editor positionCursor(Project project, PsiFile targetFile, PsiElement element) {
        TextRange range = element.getTextRange();
        int textOffset = range.getStartOffset();
        VirtualFile vFile = targetFile.getVirtualFile();
        assert (vFile != null);
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, vFile, textOffset);
        return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            CreateLocalVariableFromUsageFix.$$$reportNull$$$0(3);
        }
        if (project == null) {
            CreateLocalVariableFromUsageFix.$$$reportNull$$$0(4);
        }
        PsiFile file = element.getContainingFile();
        PsiClassType type2 = JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeByFQClassName("Object", GlobalSearchScope.allScope((Project)project));
        GrVariableDeclaration decl = GroovyPsiElementFactory.getInstance(project).createVariableDeclaration(ArrayUtilRt.EMPTY_STRING_ARRAY, "", (PsiType)type2, this.myRefExpression.getReferenceName());
        int offset = this.myRefExpression.getTextRange().getStartOffset();
        GrStatement anchor = this.findAnchor(file, offset);
        TypeConstraint[] constraints = GroovyExpectedTypesProvider.calculateTypeConstraints(this.myRefExpression);
        decl = this.myRefExpression.equals(anchor) ? this.myRefExpression.replaceWithStatement(decl) : this.myOwner.addVariableDeclarationBefore(decl, anchor);
        GrTypeElement typeElement = decl.getTypeElementGroovy();
        assert (typeElement != null);
        ChooseTypeExpression expr = new ChooseTypeExpression(constraints, PsiManager.getInstance((Project)project), typeElement.getResolveScope());
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)decl);
        builder.replaceElement((PsiElement)typeElement, (Expression)expr);
        decl = (GrVariableDeclaration)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)decl);
        Template template = builder.buildTemplate();
        Editor newEditor = CreateLocalVariableFromUsageFix.positionCursor(project, this.myOwner.getContainingFile(), decl);
        TextRange range = decl.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        manager.startTemplate(newEditor, template);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return CreateLocalVariableFromUsageFix.this.myRefExpression.isValid() && CreateLocalVariableFromUsageFix.this.myOwner.isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/CreateLocalVariableFromUsageFix$1", "satisfiedBy"));
            }
        };
    }

    @Nullable
    private GrStatement findAnchor(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element == null && offset > 0) {
            element = file.findElementAt(offset - 1);
        }
        while (element != null) {
            if (this.myOwner.equals(element.getParent())) {
                return element instanceof GrStatement ? (GrStatement)element : null;
            }
            element = element.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateLocalVariableFromUsageFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateLocalVariableFromUsageFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

