/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;

public class ReplaceDelimiterFix
extends Intention {
    @Override
    @NotNull
    public String getText() {
        return "Replace ':' with 'in'";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return "Replace for-each operator";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ReplaceDelimiterFix.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        PsiFile file;
        PsiElement at;
        GrForStatement forStatement;
        if (element == null) {
            ReplaceDelimiterFix.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ReplaceDelimiterFix.$$$reportNull$$$0(2);
        }
        if ((forStatement = (GrForStatement)PsiTreeUtil.getParentOfType((PsiElement)(at = (file = element.getContainingFile()).findElementAt(editor.getCaretModel().getOffset())), GrForStatement.class)) == null) {
            return;
        }
        GrForClause clause = forStatement.getClause();
        if (clause instanceof GrForInClause) {
            GrForStatement stubFor = (GrForStatement)GroovyPsiElementFactory.getInstance(project).createStatementFromText("for (x in y){}");
            PsiElement newDelimiter = ((GrForInClause)stubFor.getClause()).getDelimiter();
            PsiElement delimiter = ((GrForInClause)clause).getDelimiter();
            delimiter.replace(newDelimiter);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/ReplaceDelimiterFix$1", "satisfiedBy"));
            }
        };
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/ReplaceDelimiterFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

