/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.bugs.RecursionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class RecursionUtils {
    private RecursionUtils() {
    }

    public static boolean statementMayReturnBeforeRecursing(@Nullable GrStatement statement, GrMethod method) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof GrBreakStatement || statement instanceof GrContinueStatement || statement instanceof GrThrowStatement || statement instanceof GrExpression || statement instanceof GrAssertStatement || statement instanceof GrVariableDeclaration) {
            return false;
        }
        if (statement instanceof GrReturnStatement) {
            GrReturnStatement returnStatement = (GrReturnStatement)statement;
            GrExpression returnValue = returnStatement.getReturnValue();
            return returnValue == null || !RecursionUtils.expressionDefinitelyRecurses(returnValue, method);
        }
        if (statement instanceof GrForStatement) {
            return RecursionUtils.forStatementMayReturnBeforeRecursing((GrForStatement)statement, method);
        }
        if (statement instanceof GrWhileStatement) {
            return RecursionUtils.whileStatementMayReturnBeforeRecursing((GrWhileStatement)statement, method);
        }
        if (statement instanceof GrSynchronizedStatement) {
            GrOpenBlock body = ((GrSynchronizedStatement)statement).getBody();
            return RecursionUtils.codeBlockMayReturnBeforeRecursing(body, method, false);
        }
        if (statement instanceof GrBlockStatement) {
            GrBlockStatement blockStatement = (GrBlockStatement)statement;
            GrOpenBlock codeBlock = blockStatement.getBlock();
            return RecursionUtils.codeBlockMayReturnBeforeRecursing(codeBlock, method, false);
        }
        if (statement instanceof GrIfStatement) {
            return RecursionUtils.ifStatementMayReturnBeforeRecursing((GrIfStatement)statement, method);
        }
        if (statement instanceof GrTryCatchStatement) {
            return RecursionUtils.tryStatementMayReturnBeforeRecursing((GrTryCatchStatement)statement, method);
        }
        if (statement instanceof GrSwitchStatement) {
            return RecursionUtils.switchStatementMayReturnBeforeRecursing((GrSwitchStatement)statement, method);
        }
        return true;
    }

    private static boolean whileStatementMayReturnBeforeRecursing(GrWhileStatement loopStatement, GrMethod method) {
        GrExpression condition = loopStatement.getCondition();
        if (condition == null) {
            return false;
        }
        if (RecursionUtils.expressionDefinitelyRecurses(condition, method)) {
            return false;
        }
        GrStatement body = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body, method);
    }

    private static boolean forStatementMayReturnBeforeRecursing(GrForStatement loopStatement, GrMethod method) {
        GrForClause forClause = loopStatement.getClause();
        if (forClause != null) {
            for (GrVariable var : forClause.getDeclaredVariables()) {
                GrExpression initializer = var.getInitializerGroovy();
                if (!RecursionUtils.expressionDefinitelyRecurses(initializer, method)) continue;
                return false;
            }
        }
        GrStatement body = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body, method);
    }

    private static boolean switchStatementMayReturnBeforeRecursing(GrSwitchStatement switchStatement, GrMethod method) {
        GrCaseSection[] caseSections;
        for (GrCaseSection caseSection : caseSections = switchStatement.getCaseSections()) {
            GrStatement[] statements2;
            for (GrStatement statement : statements2 = caseSection.getStatements()) {
                if (!RecursionUtils.statementMayReturnBeforeRecursing(statement, method)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryStatementMayReturnBeforeRecursing(GrTryCatchStatement tryStatement, GrMethod method) {
        GrCatchClause[] catchBlocks;
        GrOpenBlock tryBlock;
        GrFinallyClause finallyBlock = tryStatement.getFinallyClause();
        if (finallyBlock != null) {
            GrOpenBlock body = finallyBlock.getBody();
            if (RecursionUtils.codeBlockMayReturnBeforeRecursing(body, method, false)) {
                return true;
            }
            if (RecursionUtils.codeBlockDefinitelyRecurses(body, method)) {
                return false;
            }
        }
        if (RecursionUtils.codeBlockMayReturnBeforeRecursing(tryBlock = tryStatement.getTryBlock(), method, false)) {
            return true;
        }
        for (GrCatchClause catchBlock : catchBlocks = tryStatement.getCatchClauses()) {
            if (!RecursionUtils.codeBlockMayReturnBeforeRecursing(catchBlock.getBody(), method, false)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayReturnBeforeRecursing(GrIfStatement ifStatement, GrMethod method) {
        GrExpression condition = ifStatement.getCondition();
        if (condition == null) {
            return false;
        }
        if (RecursionUtils.expressionDefinitelyRecurses(condition, method)) {
            return false;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        if (RecursionUtils.statementMayReturnBeforeRecursing(thenBranch, method)) {
            return true;
        }
        GrStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch != null && RecursionUtils.statementMayReturnBeforeRecursing(elseBranch, method);
    }

    private static boolean codeBlockMayReturnBeforeRecursing(@Nullable GrCodeBlock block, GrMethod method, boolean endsInImplicitReturn) {
        GrStatement[] statements2;
        if (block == null) {
            return true;
        }
        for (GrStatement statement : statements2 = block.getStatements()) {
            if (RecursionUtils.statementMayReturnBeforeRecursing(statement, method)) {
                return true;
            }
            if (!RecursionUtils.statementDefinitelyRecurses(statement, method)) continue;
            return false;
        }
        return endsInImplicitReturn;
    }

    public static boolean methodMayRecurse(@NotNull GrMethod method) {
        if (method == null) {
            RecursionUtils.$$$reportNull$$$0(0);
        }
        RecursionVisitor recursionVisitor = new RecursionVisitor(method);
        method.accept(recursionVisitor);
        return recursionVisitor.isRecursive();
    }

    private static boolean expressionDefinitelyRecurses(@Nullable GrExpression exp, GrMethod method) {
        if (exp == null) {
            return false;
        }
        if (exp instanceof GrLiteral) {
            return false;
        }
        if (exp instanceof GrMethodCallExpression) {
            return RecursionUtils.methodCallExpressionDefinitelyRecurses((GrMethodCallExpression)exp, method);
        }
        if (exp instanceof GrNewExpression) {
            return RecursionUtils.callExpressionDefinitelyRecurses((GrNewExpression)exp, method);
        }
        if (exp instanceof GrAssignmentExpression) {
            return RecursionUtils.assignmentExpressionDefinitelyRecurses((GrAssignmentExpression)exp, method);
        }
        if (exp instanceof GrArrayDeclaration) {
            return RecursionUtils.arrayInitializerExpressionDefinitelyRecurses((GrArrayDeclaration)((Object)exp), method);
        }
        if (exp instanceof GrTypeCastExpression) {
            return RecursionUtils.typeCastExpressionDefinitelyRecurses((GrTypeCastExpression)exp, method);
        }
        if (exp instanceof GrIndexProperty) {
            return RecursionUtils.arrayAccessExpressionDefinitelyRecurses((GrIndexProperty)exp, method);
        }
        if (exp instanceof GrUnaryExpression) {
            return RecursionUtils.unaryExpressionDefinitelyRecurses((GrUnaryExpression)exp, method);
        }
        if (exp instanceof GrBinaryExpression) {
            return RecursionUtils.binaryExpressionDefinitelyRecurses((GrBinaryExpression)exp, method);
        }
        if (exp instanceof GrInstanceOfExpression) {
            return RecursionUtils.instanceOfExpressionDefinitelyRecurses((GrInstanceOfExpression)exp, method);
        }
        if (exp instanceof GrElvisExpression) {
            return RecursionUtils.elvisExpressionDefinitelyRecurses((GrElvisExpression)exp, method);
        }
        if (exp instanceof GrConditionalExpression) {
            return RecursionUtils.conditionalExpressionDefinitelyRecurses((GrConditionalExpression)exp, method);
        }
        if (exp instanceof GrParenthesizedExpression) {
            return RecursionUtils.parenthesizedExpressionDefinitelyRecurses((GrParenthesizedExpression)exp, method);
        }
        if (exp instanceof GrReferenceExpression) {
            return RecursionUtils.referenceExpressionDefinitelyRecurses((GrReferenceExpression)exp, method);
        }
        return false;
    }

    private static boolean conditionalExpressionDefinitelyRecurses(GrConditionalExpression expression, GrMethod method) {
        GrExpression condExpression = expression.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condExpression, method)) {
            return true;
        }
        GrExpression thenExpression = expression.getThenBranch();
        GrExpression elseExpression = expression.getElseBranch();
        return RecursionUtils.expressionDefinitelyRecurses(thenExpression, method) && RecursionUtils.expressionDefinitelyRecurses(elseExpression, method);
    }

    private static boolean elvisExpressionDefinitelyRecurses(GrElvisExpression expression, GrMethod method) {
        GrExpression condExpression = expression.getCondition();
        return RecursionUtils.expressionDefinitelyRecurses(condExpression, method);
    }

    private static boolean binaryExpressionDefinitelyRecurses(GrBinaryExpression expression, GrMethod method) {
        GrExpression lhs = expression.getLeftOperand();
        if (RecursionUtils.expressionDefinitelyRecurses(lhs, method)) {
            return true;
        }
        IElementType tokenType = expression.getOperationTokenType();
        if (GroovyTokenTypes.mLAND.equals(tokenType) || GroovyTokenTypes.mLOR.equals(tokenType)) {
            return false;
        }
        GrExpression rhs = expression.getRightOperand();
        return RecursionUtils.expressionDefinitelyRecurses(rhs, method);
    }

    private static boolean arrayAccessExpressionDefinitelyRecurses(GrIndexProperty expression, GrMethod method) {
        GrExpression arrayExp = expression.getInvokedExpression();
        return RecursionUtils.expressionDefinitelyRecurses(arrayExp, method);
    }

    private static boolean arrayInitializerExpressionDefinitelyRecurses(GrArrayDeclaration expression, GrMethod method) {
        GrExpression[] initializers;
        for (GrExpression initializer : initializers = expression.getBoundExpressions()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(initializer, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean unaryExpressionDefinitelyRecurses(GrUnaryExpression expression, GrMethod method) {
        GrExpression operand = expression.getOperand();
        return RecursionUtils.expressionDefinitelyRecurses(operand, method);
    }

    private static boolean instanceOfExpressionDefinitelyRecurses(GrInstanceOfExpression expression, GrMethod method) {
        GrExpression operand = expression.getOperand();
        return RecursionUtils.expressionDefinitelyRecurses(operand, method);
    }

    private static boolean parenthesizedExpressionDefinitelyRecurses(GrParenthesizedExpression expression, GrMethod method) {
        GrExpression innerExpression = expression.getOperand();
        return RecursionUtils.expressionDefinitelyRecurses(innerExpression, method);
    }

    private static boolean referenceExpressionDefinitelyRecurses(GrReferenceExpression expression, GrMethod method) {
        GrExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null) {
            return RecursionUtils.expressionDefinitelyRecurses(qualifierExpression, method);
        }
        return false;
    }

    private static boolean typeCastExpressionDefinitelyRecurses(GrTypeCastExpression expression, GrMethod method) {
        GrExpression operand = expression.getOperand();
        return RecursionUtils.expressionDefinitelyRecurses(operand, method);
    }

    private static boolean assignmentExpressionDefinitelyRecurses(GrAssignmentExpression assignmentExpression, GrMethod method) {
        GrExpression rhs = assignmentExpression.getRValue();
        GrExpression lhs = assignmentExpression.getLValue();
        return RecursionUtils.expressionDefinitelyRecurses(rhs, method) || RecursionUtils.expressionDefinitelyRecurses(lhs, method);
    }

    private static boolean callExpressionDefinitelyRecurses(GrCallExpression exp, GrMethod method) {
        GrArgumentList argumentList = exp.getArgumentList();
        if (argumentList != null) {
            GrNamedArgument[] namedArgs;
            GrExpression[] args;
            for (GrExpression arg : args = argumentList.getExpressionArguments()) {
                if (!RecursionUtils.expressionDefinitelyRecurses(arg, method)) continue;
                return true;
            }
            for (GrNamedArgument arg : namedArgs = argumentList.getNamedArguments()) {
                if (!RecursionUtils.expressionDefinitelyRecurses(arg.getExpression(), method)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean methodCallExpressionDefinitelyRecurses(GrMethodCallExpression exp, GrMethod method) {
        GrExpression invoked = exp.getInvokedExpression();
        if (invoked instanceof GrReferenceExpression) {
            GrReferenceExpression methodExpression = (GrReferenceExpression)invoked;
            PsiMethod referencedMethod = exp.resolveMethod();
            if (referencedMethod == null) {
                return false;
            }
            GrExpression qualifier = methodExpression.getQualifierExpression();
            if (referencedMethod.equals(method)) {
                if (method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
                    return true;
                }
                if (qualifier == null || qualifier instanceof GrReferenceExpression && PsiUtil.isThisReference(qualifier)) {
                    return true;
                }
            }
            if (RecursionUtils.expressionDefinitelyRecurses(qualifier, method)) {
                return true;
            }
        }
        return RecursionUtils.callExpressionDefinitelyRecurses(exp, method);
    }

    private static boolean statementDefinitelyRecurses(@Nullable GrStatement statement, GrMethod method) {
        if (statement == null) {
            return false;
        }
        if (statement instanceof GrBreakStatement || statement instanceof GrContinueStatement || statement instanceof GrThrowStatement || statement instanceof GrAssertStatement) {
            return false;
        }
        if (statement instanceof GrExpression) {
            GrExpression expression = (GrExpression)statement;
            return RecursionUtils.expressionDefinitelyRecurses(expression, method);
        }
        if (statement instanceof GrVariableDeclaration) {
            GrVariable[] declaredElements;
            GrVariableDeclaration declaration = (GrVariableDeclaration)statement;
            for (GrVariable variable : declaredElements = declaration.getVariables()) {
                GrExpression initializer = (GrExpression)variable.getInitializer();
                if (!RecursionUtils.expressionDefinitelyRecurses(initializer, method)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof GrReturnStatement) {
            GrReturnStatement returnStatement = (GrReturnStatement)statement;
            GrExpression returnValue = returnStatement.getReturnValue();
            return returnValue != null && RecursionUtils.expressionDefinitelyRecurses(returnValue, method);
        }
        if (statement instanceof GrForStatement) {
            return RecursionUtils.forStatementDefinitelyRecurses((GrForStatement)statement, method);
        }
        if (statement instanceof GrWhileStatement) {
            return RecursionUtils.whileStatementDefinitelyRecurses((GrWhileStatement)statement, method);
        }
        if (statement instanceof GrSynchronizedStatement) {
            GrOpenBlock body = ((GrSynchronizedStatement)statement).getBody();
            return RecursionUtils.codeBlockDefinitelyRecurses(body, method);
        }
        if (statement instanceof GrBlockStatement) {
            GrOpenBlock codeBlock = ((GrBlockStatement)statement).getBlock();
            return RecursionUtils.codeBlockDefinitelyRecurses(codeBlock, method);
        }
        if (statement instanceof GrIfStatement) {
            return RecursionUtils.ifStatementDefinitelyRecurses((GrIfStatement)statement, method);
        }
        if (statement instanceof GrTryCatchStatement) {
            return RecursionUtils.tryStatementDefinitelyRecurses((GrTryCatchStatement)statement, method);
        }
        if (statement instanceof GrSwitchStatement) {
            return RecursionUtils.switchStatementDefinitelyRecurses((GrSwitchStatement)statement, method);
        }
        return false;
    }

    private static boolean switchStatementDefinitelyRecurses(GrSwitchStatement switchStatement, GrMethod method) {
        GrExpression switchExpression = switchStatement.getCondition();
        return RecursionUtils.expressionDefinitelyRecurses(switchExpression, method);
    }

    private static boolean tryStatementDefinitelyRecurses(GrTryCatchStatement tryStatement, GrMethod method) {
        GrOpenBlock tryBlock = tryStatement.getTryBlock();
        if (RecursionUtils.codeBlockDefinitelyRecurses(tryBlock, method)) {
            return true;
        }
        GrFinallyClause finallyBlock = tryStatement.getFinallyClause();
        if (finallyBlock == null) {
            return false;
        }
        return RecursionUtils.codeBlockDefinitelyRecurses(finallyBlock.getBody(), method);
    }

    private static boolean codeBlockDefinitelyRecurses(GrCodeBlock block, GrMethod method) {
        GrStatement[] statements2;
        if (block == null) {
            return false;
        }
        for (GrStatement statement : statements2 = block.getStatements()) {
            if (!RecursionUtils.statementDefinitelyRecurses(statement, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementDefinitelyRecurses(GrIfStatement ifStatement, GrMethod method) {
        GrExpression condition = ifStatement.getCondition();
        if (condition == null) {
            return false;
        }
        if (RecursionUtils.expressionDefinitelyRecurses(condition, method)) {
            return true;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (thenBranch == null || elseBranch == null) {
            return false;
        }
        return RecursionUtils.statementDefinitelyRecurses(thenBranch, method) && RecursionUtils.statementDefinitelyRecurses(elseBranch, method);
    }

    private static boolean forStatementDefinitelyRecurses(GrForStatement forStatement, GrMethod method) {
        GrForClause clause = forStatement.getClause();
        if (clause == null) {
            return false;
        }
        for (GrVariable var : clause.getDeclaredVariables()) {
            GrExpression initializer = var.getInitializerGroovy();
            if (!RecursionUtils.expressionDefinitelyRecurses(initializer, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean whileStatementDefinitelyRecurses(GrWhileStatement whileStatement, GrMethod method) {
        GrExpression condition = whileStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition, method)) {
            return true;
        }
        if (BoolUtils.isTrue(condition)) {
            GrStatement body = whileStatement.getBody();
            return RecursionUtils.statementDefinitelyRecurses(body, method);
        }
        return false;
    }

    public static boolean methodDefinitelyRecurses(@NotNull GrMethod method) {
        GrOpenBlock body;
        if (method == null) {
            RecursionUtils.$$$reportNull$$$0(1);
        }
        if ((body = method.getBlock()) == null) {
            return false;
        }
        return !RecursionUtils.codeBlockMayReturnBeforeRecursing(body, method, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "method";
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/RecursionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "methodMayRecurse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "methodDefinitelyRecurses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

