/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyDoubleNegationInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return "Double negation #ref #loc";
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyDoubleNegationInspection.$$$reportNull$$$0(0);
        }
        return new DoubleNegationFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleNegationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection", "buildFix"));
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            IElementType tokenType;
            if (expression == null) {
                DoubleNegationVisitor.$$$reportNull$$$0(0);
            }
            if (!GroovyElementTypes.T_NOT.equals(tokenType = expression.getOperationTokenType())) {
                return;
            }
            this.checkParent(expression);
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            IElementType tokenType;
            if (expression == null) {
                DoubleNegationVisitor.$$$reportNull$$$0(1);
            }
            if (!GroovyElementTypes.T_NEQ.equals(tokenType = expression.getOperationTokenType())) {
                return;
            }
            this.checkParent(expression);
        }

        private void checkParent(GrExpression expression) {
            PsiElement parent2 = expression.getParent();
            while (parent2 instanceof GrParenthesizedExpression) {
                parent2 = parent2.getParent();
            }
            if (!(parent2 instanceof GrUnaryExpression)) {
                return;
            }
            GrUnaryExpression prefixExpression = (GrUnaryExpression)parent2;
            IElementType parentTokenType = prefixExpression.getOperationTokenType();
            if (!GroovyElementTypes.T_NOT.equals(parentTokenType)) {
                return;
            }
            this.registerError(prefixExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection$DoubleNegationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DoubleNegationFix
    extends GroovyFix {
        private DoubleNegationFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Remove double negation";
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            GrUnaryExpression expression;
            GrExpression operand;
            if (project == null) {
                DoubleNegationFix.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                DoubleNegationFix.$$$reportNull$$$0(1);
            }
            if ((operand = (GrExpression)PsiUtil.skipParentheses((expression = (GrUnaryExpression)descriptor2.getPsiElement()).getOperand(), false)) instanceof GrUnaryExpression) {
                GrUnaryExpression prefixExpression = (GrUnaryExpression)operand;
                GrExpression innerOperand = prefixExpression.getOperand();
                if (innerOperand == null) {
                    return;
                }
                DoubleNegationFix.replaceExpression(expression, innerOperand.getText());
            } else if (operand instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)operand;
                GrExpression lhs = binaryExpression.getLeftOperand();
                String lhsText = lhs.getText();
                StringBuilder builder = new StringBuilder(lhsText);
                builder.append("==");
                GrExpression rhs = binaryExpression.getRightOperand();
                if (rhs != null) {
                    String rhsText = rhs.getText();
                    builder.append(rhsText);
                }
                DoubleNegationFix.replaceExpression(expression, builder.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyDoubleNegationInspection$DoubleNegationFix";
            objectArray[2] = "doFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

