/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyConditionalWithIdenticalBranchesInspection
extends BaseInspection {
    @Override
    public String buildErrorString(Object ... args) {
        return "Conditional expression with identical branches #loc";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyConditionalWithIdenticalBranchesInspection.$$$reportNull$$$0(0);
        }
        return new CollapseConditionalFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection", "buildFix"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            GrExpression thenBranch = expression.getThenBranch();
            GrExpression elseBranch = expression.getElseBranch();
            if (thenBranch == null || elseBranch == null) {
                return;
            }
            if (EquivalenceChecker.expressionsAreEquivalent(thenBranch, elseBranch)) {
                this.registerStatementError(expression, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection$Visitor", "visitConditionalExpression"));
        }
    }

    private static class CollapseConditionalFix
    extends GroovyFix {
        private CollapseConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Collapse conditional expression";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                CollapseConditionalFix.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                CollapseConditionalFix.$$$reportNull$$$0(1);
            }
            if (!((element = descriptor2.getPsiElement()) instanceof GrConditionalExpression)) {
                return;
            }
            GrConditionalExpression expression = (GrConditionalExpression)element;
            GrExpression thenBranch = expression.getThenBranch();
            CollapseConditionalFix.replaceExpression(expression, thenBranch.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalWithIdenticalBranchesInspection$CollapseConditionalFix";
            objectArray[2] = "doFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

