/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyConstantIfStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        return "#ref statement can be simplified #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyConstantIfStatementInspection.$$$reportNull$$$0(0);
        }
        return new ConstantIfStatementFix();
    }

    private static boolean isFalse(GrExpression expression) {
        String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        String text = expression.getText();
        return "true".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection", "buildFix"));
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            if (statement == null) {
                ConstantIfStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (GroovyConstantIfStatementInspection.isTrue(condition) || GroovyConstantIfStatementInspection.isFalse(condition)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection$ConstantIfStatementVisitor", "visitIfStatement"));
        }
    }

    private static class ConstantIfStatementFix
    extends GroovyFix {
        private ConstantIfStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Simplify";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(1);
            }
            PsiElement ifKeyword = descriptor2.getPsiElement();
            GrIfStatement ifStatement = (GrIfStatement)ifKeyword.getParent();
            assert (ifStatement != null);
            GrStatement thenBranch = ifStatement.getThenBranch();
            GrStatement elseBranch = ifStatement.getElseBranch();
            GrExpression condition = ifStatement.getCondition();
            if (GroovyConstantIfStatementInspection.isFalse(condition)) {
                if (elseBranch != null) {
                    ConstantIfStatementFix.replaceStatement((GrStatement)ifStatement, (GrStatement)elseBranch.copy());
                } else {
                    ifStatement.delete();
                }
            } else {
                ConstantIfStatementFix.replaceStatement((GrStatement)ifStatement, (GrStatement)thenBranch.copy());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection$ConstantIfStatementFix";
            objectArray[2] = "doFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

