/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

public class GroovyTrivialConditionalInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        GrConditionalExpression exp = (GrConditionalExpression)args[0];
        return "'" + exp.getText() + "' can be simplified to '" + GroovyTrivialConditionalInspection.calculateReplacementExpression(exp) + "'  #loc";
    }

    private static String calculateReplacementExpression(GrConditionalExpression exp) {
        GrExpression thenExpression = exp.getThenBranch();
        GrExpression elseExpression = exp.getElseBranch();
        GrExpression condition = exp.getCondition();
        if (GroovyTrivialConditionalInspection.isFalse(thenExpression) && GroovyTrivialConditionalInspection.isTrue(elseExpression)) {
            return BoolUtils.getNegatedExpressionText(condition);
        }
        return condition.getText();
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyTrivialConditionalInspection.$$$reportNull$$$0(0);
        }
        return new TrivialConditionalFix();
    }

    private static boolean isFalse(GrExpression expression) {
        String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        String text = expression.getText();
        return "true".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection", "buildFix"));
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression exp) {
            if (exp == null) {
                UnnecessaryConditionalExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(exp);
            GrExpression condition = exp.getCondition();
            PsiType type2 = condition.getType();
            if (type2 == null || !PsiType.BOOLEAN.isAssignableFrom(type2)) {
                return;
            }
            if (ErrorUtil.containsError(exp)) {
                return;
            }
            GrExpression thenExpression = exp.getThenBranch();
            if (thenExpression == null) {
                return;
            }
            GrExpression elseExpression = exp.getElseBranch();
            if (elseExpression == null) {
                return;
            }
            if (GroovyTrivialConditionalInspection.isFalse(thenExpression) && GroovyTrivialConditionalInspection.isTrue(elseExpression) || GroovyTrivialConditionalInspection.isTrue(thenExpression) && GroovyTrivialConditionalInspection.isFalse(elseExpression)) {
                this.registerError(exp);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection$UnnecessaryConditionalExpressionVisitor", "visitConditionalExpression"));
        }
    }

    private static class TrivialConditionalFix
    extends GroovyFix {
        private TrivialConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Simplify";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                TrivialConditionalFix.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                TrivialConditionalFix.$$$reportNull$$$0(1);
            }
            GrConditionalExpression expression = (GrConditionalExpression)descriptor2.getPsiElement();
            String newExpression = GroovyTrivialConditionalInspection.calculateReplacementExpression(expression);
            TrivialConditionalFix.replaceExpression(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection$TrivialConditionalFix";
            objectArray[2] = "doFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

