/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyParameterNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyParameterNamingConventionInspection.$$$reportNull$$$0(0);
        }
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            return "Method parameter name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            return "Method parameter name '#ref' is too long";
        }
        String string = "Method parameter name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string == null) {
            GroovyParameterNamingConventionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyParameterNamingConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyParameterNamingConventionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitParameter(@NotNull GrParameter grParameter) {
            if (grParameter == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            super.visitParameter(grParameter);
            String name = grParameter.getName();
            PsiElement scope = grParameter.getDeclarationScope();
            if (scope instanceof GrCatchClause || scope instanceof GrForStatement) {
                return;
            }
            if (GroovyParameterNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError(grParameter, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grParameter", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyParameterNamingConventionInspection$NamingConventionsVisitor", "visitParameter"));
        }
    }
}

