/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GroovyEmptySyncBlockInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Empty '#ref' block #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSynchronizedStatement(@NotNull GrSynchronizedStatement synchronizedStatement) {
            if (synchronizedStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(synchronizedStatement);
            GrOpenBlock body = synchronizedStatement.getBody();
            if (body == null || !Visitor.isEmpty(body)) {
                return;
            }
            this.registerError(synchronizedStatement.getFirstChild());
        }

        private static boolean isEmpty(GrOpenBlock body) {
            GrStatement[] statements2 = body.getStatements();
            return statements2.length == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "synchronizedStatement", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyEmptySyncBlockInspection$Visitor", "visitSynchronizedStatement"));
        }
    }
}

