/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.ProcessorWithHints;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.BaseGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0016\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001!B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\nH\u0016R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/KindsResolverProcessor;", "Lcom/intellij/psi/scope/ProcessorWithHints;", "Lcom/intellij/psi/scope/NameHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind$Hint;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "kinds", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Ljava/util/Set;)V", "candidates", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "getKinds", "()Ljava/util/Set;", "getName", "()Ljava/lang/String;", "getPlace", "()Lcom/intellij/psi/PsiElement;", "execute", "", "element", "state", "Lcom/intellij/psi/ResolveState;", "executeInner", "", "getAllCandidates", "", "getCandidate", "kind", "shouldProcess", "Companion", "intellij.groovy.psi"})
public class KindsResolverProcessor
extends ProcessorWithHints
implements NameHint,
GroovyResolveKind.Hint {
    private final Map<GroovyResolveKind, GroovyResolveResult> candidates;
    @NotNull
    private final String name;
    @NotNull
    private final PsiElement place;
    @NotNull
    private final Set<GroovyResolveKind> kinds;
    private static final Set<GroovyResolveKind> propertyKinds;
    public static final Companion Companion;

    @Nullable
    public final String getName(@NotNull ResolveState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldProcess(@NotNull GroovyResolveKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        if (!this.kinds.contains((Object)kind)) return false;
        Map<GroovyResolveKind, GroovyResolveResult> map2 = this.candidates;
        boolean bl = false;
        Map<GroovyResolveKind, GroovyResolveResult> map3 = map2;
        boolean bl2 = false;
        if (map3.containsKey((Object)kind)) return false;
        return true;
    }

    private final void executeInner(PsiElement element, ResolveState state) {
        if (!(element instanceof PsiNamedElement)) {
            return;
        }
        boolean bl = ((PsiNamedElement)element).isValid();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid element. " + PsiUtilKt.elementInfo(element);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String elementName = ResolveUtilKt.getName(state, (PsiNamedElement)element);
        if (Intrinsics.areEqual((Object)this.name, (Object)elementName) ^ true) {
            return;
        }
        GroovyResolveKind kind = ResolveUtilKt.getResolveKind((PsiNamedElement)element);
        if (kind == null) {
            ResolveUtilKt.getLog().warn("Unknown kind. " + PsiUtilKt.elementInfo(element));
        } else if (!this.kinds.contains((Object)kind)) {
            if (Intrinsics.areEqual((Object)((Boolean)state.get(ResolveUtilKt.sorryCannotKnowElementKind)), (Object)true) ^ true) {
                ResolveUtilKt.getLog().error("Unneeded kind: " + (Object)((Object)kind) + ". " + PsiUtilKt.elementInfo(element));
            }
        } else {
            Map<GroovyResolveKind, GroovyResolveResult> map2 = this.candidates;
            boolean bl5 = false;
            Map<GroovyResolveKind, GroovyResolveResult> map3 = map2;
            boolean bl6 = false;
            if (!map3.containsKey((Object)kind)) {
                boolean invokedOnProperty = propertyKinds.contains((Object)kind);
                this.candidates.put(kind, new BaseGroovyResolveResult<PsiElement>(this, invokedOnProperty, element, state, element, this.place, state){
                    final /* synthetic */ KindsResolverProcessor this$0;
                    final /* synthetic */ boolean $invokedOnProperty;
                    final /* synthetic */ PsiElement $element;
                    final /* synthetic */ ResolveState $state;

                    public boolean isInvokedOnProperty() {
                        return this.$invokedOnProperty;
                    }
                    {
                        this.this$0 = $outer;
                        this.$invokedOnProperty = $captured_local_variable$1;
                        this.$element = $captured_local_variable$2;
                        this.$state = $captured_local_variable$3;
                        super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    }
                });
            }
        }
    }

    public final boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            this.executeInner(element, state);
            Iterable $this$any$iv = this.kinds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GroovyResolveKind it = (GroovyResolveKind)((Object)element$iv);
                    boolean bl2 = false;
                    Map<GroovyResolveKind, GroovyResolveResult> map2 = this.candidates;
                    boolean bl3 = false;
                    Map<GroovyResolveKind, GroovyResolveResult> map3 = map2;
                    boolean bl4 = false;
                    if (!(!map3.containsKey((Object)it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final GroovyResolveResult getCandidate(@NotNull GroovyResolveKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        return this.candidates.get((Object)kind);
    }

    @NotNull
    public final List<GroovyResolveResult> getAllCandidates() {
        return CollectionsKt.toList((Iterable)this.candidates.values());
    }

    @NotNull
    protected final String getName() {
        return this.name;
    }

    @NotNull
    protected final PsiElement getPlace() {
        return this.place;
    }

    @NotNull
    protected final Set<GroovyResolveKind> getKinds() {
        return this.kinds;
    }

    public KindsResolverProcessor(@NotNull String name, @NotNull PsiElement place, @NotNull Set<? extends GroovyResolveKind> kinds) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull(kinds, (String)"kinds");
        this.name = name;
        this.place = place;
        this.kinds = kinds;
        this.hint(NameHint.KEY, this);
        this.hint(GroovyResolveKind.HINT_KEY, this);
        KindsResolverProcessor kindsResolverProcessor = this;
        boolean $i$f$enumMapOf = false;
        kindsResolverProcessor.candidates = map2 = (Map)new EnumMap(GroovyResolveKind.class);
    }

    static {
        Companion = new Companion(null);
        propertyKinds = SetsKt.setOf((Object[])new GroovyResolveKind[]{GroovyResolveKind.VARIABLE, GroovyResolveKind.BINDING, GroovyResolveKind.FIELD, GroovyResolveKind.PROPERTY});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/KindsResolverProcessor$Companion;", "", "()V", "propertyKinds", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

