/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GrConstraintFormula;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/TypeConstraint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GrConstraintFormula;", "leftType", "Lcom/intellij/psi/PsiType;", "rightType", "context", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiType;Lcom/intellij/psi/PsiElement;)V", "reduce", "", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "constraints", "", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "intellij.groovy.psi"})
public final class TypeConstraint
extends GrConstraintFormula {
    private final PsiType leftType;
    private final PsiType rightType;
    private final PsiElement context;

    @Override
    public boolean reduce(@NotNull GroovyInferenceSession session, @NotNull List<ConstraintFormula> constraints) {
        PsiType psiType;
        PsiType argType;
        Intrinsics.checkParameterIsNotNull((Object)((Object)session), (String)"session");
        Intrinsics.checkParameterIsNotNull(constraints, (String)"constraints");
        PsiType psiType2 = this.rightType;
        if (psiType2 == null) {
            psiType2 = argType = (PsiType)PsiType.NULL;
        }
        if (argType instanceof GrTupleType && (psiType = TypesUtil.rawWildcard(argType, this.context)) == null) {
            psiType = argType = argType;
        }
        if (!(argType instanceof GrLiteralClassType)) {
            argType = PsiUtil.captureToplevelWildcards((PsiType)argType, (PsiElement)this.context);
        }
        if (argType instanceof GrMapType && session.getSkipClosureBlock()) {
            argType = (PsiType)TypesUtil.createTypeByFQClassName("java.util.Map", this.context);
        }
        PsiType t = session.getContextSubstitutor().substitute(session.substituteWithInferenceVariables(this.leftType));
        PsiType s = session.getContextSubstitutor().substitute(session.substituteWithInferenceVariables(argType));
        constraints.add((ConstraintFormula)new TypeCompatibilityConstraint(t, s));
        return true;
    }

    public TypeConstraint(@NotNull PsiType leftType, @Nullable PsiType rightType, @NotNull PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)leftType, (String)"leftType");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.leftType = leftType;
        this.rightType = rightType;
        this.context = context;
    }
}

