/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.lang.psi.impl.ApplicationStatementUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extract.ParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.extract.method.ExtractMethodInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;

public class ExtractUtil {
    private static final Logger LOG = Logger.getInstance(ExtractUtil.class);

    private ExtractUtil() {
    }

    public static GrStatement replaceStatement(@Nullable GrStatementOwner declarationOwner, @NotNull ExtractInfoHelper helper) {
        GrStatement realStatement;
        if (helper == null) {
            ExtractUtil.$$$reportNull$$$0(0);
        }
        if (declarationOwner != null && !ExtractUtil.isSingleExpression(helper.getStatements()) && helper.getStringPartInfo() == null) {
            GrStatement[] newStatement = ExtractUtil.createResultStatement(helper);
            GrStatement[] statements2 = helper.getStatements();
            LOG.assertTrue(statements2.length > 0);
            realStatement = null;
            for (GrStatement statement : newStatement) {
                realStatement = declarationOwner.addStatementBefore(statement, statements2[0]);
                JavaCodeStyleManager.getInstance((Project)realStatement.getProject()).shortenClassReferences((PsiElement)realStatement);
            }
            LOG.assertTrue(realStatement != null);
            ExtractUtil.removeOldStatements(declarationOwner, helper);
            PsiImplUtil.removeNewLineAfter(realStatement);
        } else {
            GrExpression oldExpr = helper.getStringPartInfo() != null ? helper.getStringPartInfo().replaceLiteralWithConcatenation("xyz") : (GrExpression)helper.getStatements()[0];
            GrMethodCallExpression methodCall = ExtractUtil.createMethodCall(helper);
            realStatement = oldExpr.replaceWithExpression(methodCall, true);
            JavaCodeStyleManager.getInstance((Project)realStatement.getProject()).shortenClassReferences((PsiElement)realStatement);
        }
        return realStatement;
    }

    private static GrStatement @NotNull [] createResultStatement(ExtractInfoHelper helper) {
        VariableInfo[] outputVars = helper.getOutputVariableInfos();
        PsiType type2 = helper.getOutputType();
        GrStatement[] statements2 = helper.getStatements();
        GrMethodCallExpression callExpression = ExtractUtil.createMethodCall(helper);
        if ((outputVars.length == 0 || PsiType.VOID.equals((Object)type2)) && !helper.hasReturnValue()) {
            GrStatement[] grStatementArray = new GrStatement[]{callExpression};
            if (grStatementArray == null) {
                ExtractUtil.$$$reportNull$$$0(1);
            }
            return grStatementArray;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(helper.getProject());
        if (helper.hasReturnValue()) {
            GrStatement[] grStatementArray = new GrStatement[]{factory.createStatementFromText("return " + callExpression.getText())};
            if (grStatementArray == null) {
                ExtractUtil.$$$reportNull$$$0(2);
            }
            return grStatementArray;
        }
        LOG.assertTrue(outputVars.length > 0);
        List<VariableInfo> mustAdd = ExtractUtil.mustAddVariableDeclaration(statements2, outputVars);
        if (mustAdd.isEmpty()) {
            GrStatement[] grStatementArray = new GrStatement[]{ExtractUtil.createAssignment(outputVars, callExpression, helper.getProject())};
            if (grStatementArray == null) {
                ExtractUtil.$$$reportNull$$$0(3);
            }
            return grStatementArray;
        }
        if (mustAdd.size() == outputVars.length && outputVars.length == 1) {
            GrStatement[] grStatementArray = new GrVariableDeclaration[]{factory.createVariableDeclaration(ArrayUtilRt.EMPTY_STRING_ARRAY, callExpression, outputVars[0].getType(), outputVars[0].getName())};
            if (grStatementArray == null) {
                ExtractUtil.$$$reportNull$$$0(4);
            }
            return grStatementArray;
        }
        if (ExtractUtil.varsAreEqual(mustAdd, outputVars)) {
            GrStatement[] grStatementArray = ExtractUtil.createTupleDeclaration(outputVars, callExpression, helper.getProject());
            if (grStatementArray == null) {
                ExtractUtil.$$$reportNull$$$0(5);
            }
            return grStatementArray;
        }
        List<GrStatement> result2 = ExtractUtil.generateVarDeclarations(mustAdd, helper.getProject(), null);
        result2.add(ExtractUtil.createAssignment(outputVars, callExpression, helper.getProject()));
        GrStatement[] grStatementArray = result2.toArray(GrStatement.EMPTY_ARRAY);
        if (grStatementArray == null) {
            ExtractUtil.$$$reportNull$$$0(6);
        }
        return grStatementArray;
    }

    private static boolean varsAreEqual(List<VariableInfo> toAdd, VariableInfo[] outputVars) {
        if (toAdd.size() != outputVars.length) {
            return false;
        }
        HashSet<String> names = new HashSet<String>();
        for (VariableInfo info : toAdd) {
            names.add(info.getName());
        }
        for (VariableInfo var : outputVars) {
            if (names.contains(var.getName())) continue;
            return false;
        }
        return true;
    }

    private static GrStatement[] createTupleDeclaration(VariableInfo[] infos, GrMethodCallExpression callExpression, Project project) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        StringBuilder tuple = new StringBuilder();
        tuple.append("def (");
        for (VariableInfo info : infos) {
            PsiType type2 = info.getType();
            if (type2 != null) {
                PsiType unboxed = TypesUtil.unboxPrimitiveTypeWrapper(type2);
                tuple.append(unboxed.getCanonicalText());
                tuple.append(' ');
            }
            tuple.append(info.getName());
            tuple.append(",");
        }
        StringUtil.trimEnd((StringBuilder)tuple, (CharSequence)",");
        tuple.append(")=");
        tuple.append(callExpression.getText());
        return new GrStatement[]{factory.createStatementFromText(tuple)};
    }

    private static List<GrStatement> generateVarDeclarations(List<VariableInfo> varInfos, Project project, @Nullable GrExpression initializer) {
        ArrayList<GrStatement> result2 = new ArrayList<GrStatement>();
        if (varInfos.isEmpty()) {
            return result2;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        boolean distinctDeclaration = ExtractUtil.haveDifferentTypes(varInfos);
        if (distinctDeclaration) {
            for (VariableInfo info : varInfos) {
                result2.add(factory.createVariableDeclaration(ArrayUtilRt.EMPTY_STRING_ARRAY, "", info.getType(), info.getName()));
            }
        } else {
            String[] names = new String[varInfos.size()];
            int mustAddLength = varInfos.size();
            for (int i = 0; i < mustAddLength; ++i) {
                names[i] = varInfos.get(i).getName();
            }
            result2.add(factory.createVariableDeclaration(ArrayUtilRt.EMPTY_STRING_ARRAY, initializer, varInfos.get(0).getType(), names));
        }
        return result2;
    }

    private static boolean haveDifferentTypes(List<VariableInfo> varInfos) {
        if (varInfos.size() < 2) {
            return true;
        }
        HashSet<String> diffTypes = new HashSet<String>();
        for (VariableInfo info : varInfos) {
            PsiType t = info.getType();
            diffTypes.add(t == null ? null : TypesUtil.unboxPrimitiveTypeWrapper(t).getCanonicalText());
        }
        return diffTypes.size() > 1;
    }

    private static GrStatement createAssignment(VariableInfo[] infos, GrMethodCallExpression callExpression, Project project) {
        StringBuilder text = new StringBuilder();
        if (infos.length > 1) {
            text.append('(');
        }
        for (VariableInfo info : infos) {
            text.append(info.getName()).append(", ");
        }
        if (infos.length > 1) {
            text.replace(text.length() - 2, text.length(), ") =");
        } else {
            text.replace(text.length() - 2, text.length(), " = ");
        }
        text.append(callExpression.getText());
        return GroovyPsiElementFactory.getInstance(project).createExpressionFromText(text.toString());
    }

    private static void removeOldStatements(GrStatementOwner owner, ExtractInfoHelper helper) throws IncorrectOperationException {
        owner.removeElements(helper.getInnerElements());
    }

    private static List<VariableInfo> mustAddVariableDeclaration(GrStatement @NotNull [] statements2, VariableInfo @NotNull [] vars) {
        if (statements2 == null) {
            ExtractUtil.$$$reportNull$$$0(7);
        }
        if (vars == null) {
            ExtractUtil.$$$reportNull$$$0(8);
        }
        HashMap<String, VariableInfo> names = new HashMap<String, VariableInfo>();
        for (VariableInfo var : vars) {
            names.put(var.getName(), var);
        }
        ArrayList<VariableInfo> result2 = new ArrayList<VariableInfo>();
        for (GrStatement statement : statements2) {
            if (!(statement instanceof GrVariableDeclaration)) continue;
            GrVariableDeclaration declaration = (GrVariableDeclaration)statement;
            for (GrVariable variable : declaration.getVariables()) {
                VariableInfo removed = (VariableInfo)names.remove(variable.getName());
                if (removed == null) continue;
                result2.add(removed);
            }
        }
        for (String varName : names.keySet()) {
            if (ResolveUtil.resolveProperty(statements2[statements2.length - 1], varName) != null) continue;
            result2.add((VariableInfo)names.get(varName));
        }
        return result2;
    }

    public static TextRange getRangeOfRefactoring(ExtractInfoHelper helper) {
        StringPartInfo stringPartInfo = helper.getStringPartInfo();
        if (stringPartInfo != null) {
            return stringPartInfo.getRange();
        }
        GrStatement[] statements2 = helper.getStatements();
        int start = statements2[0].getTextRange().getStartOffset();
        int end = statements2[statements2.length - 1].getTextRange().getEndOffset();
        return new TextRange(start, end);
    }

    private static Collection<GrVariable> collectUsedLocalVarsOrParamsDeclaredOutside(ExtractInfoHelper helper) {
        GrStatement[] statements2;
        final HashSet<GrVariable> result2 = new HashSet<GrVariable>();
        TextRange range = ExtractUtil.getRangeOfRefactoring(helper);
        final int start = range.getStartOffset();
        final int end = range.getEndOffset();
        GroovyRecursiveElementVisitor visitor2 = new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression ref) {
                int offset;
                PsiElement resolved;
                if (ref == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((resolved = ref.resolve()) instanceof GrParameter || PsiUtil.isLocalVariable(resolved)) && resolved.isPhysical() && ((offset = resolved.getTextRange().getStartOffset()) < start || end <= offset)) {
                    result2.add((GrVariable)resolved);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/refactoring/extract/ExtractUtil$1", "visitReferenceExpression"));
            }
        };
        for (GrStatement statement : statements2 = helper.getStatements()) {
            statement.accept(visitor2);
        }
        return result2;
    }

    public static GrMethod createMethod(ExtractMethodInfoHelper helper) {
        StringBuilder buffer = new StringBuilder();
        PsiType type2 = helper.getOutputType();
        PsiPrimitiveType outUnboxed = PsiPrimitiveType.getUnboxedType((PsiType)type2);
        if (outUnboxed != null) {
            type2 = outUnboxed;
        }
        String modifier = ExtractUtil.getModifierString(helper);
        String typeText = ExtractUtil.getTypeString(helper, false, modifier);
        buffer.append(modifier);
        buffer.append(typeText);
        ExtractUtil.appendName(buffer, helper.getName());
        buffer.append("(");
        for (String param : ExtractUtil.getParameterString(helper, true)) {
            buffer.append(param);
        }
        buffer.append(") { \n");
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(helper.getProject());
        ExtractUtil.generateBody(helper, PsiType.VOID.equals((Object)type2), buffer, helper.isForceReturn());
        buffer.append("\n}");
        String methodText = buffer.toString();
        return factory.createMethodFromText(methodText, helper.getContext());
    }

    public static void appendName(@NotNull StringBuilder buffer, @NotNull String name) {
        if (buffer == null) {
            ExtractUtil.$$$reportNull$$$0(9);
        }
        if (name == null) {
            ExtractUtil.$$$reportNull$$$0(10);
        }
        if (GroovyNamesUtil.isIdentifier(name)) {
            buffer.append(name);
        } else {
            buffer.append("'");
            buffer.append(GrStringUtil.escapeSymbolsForString(name, true, false));
            buffer.append("'");
        }
    }

    public static void generateBody(ExtractInfoHelper helper, boolean isVoid, StringBuilder buffer, boolean forceReturn) {
        VariableInfo[] outputInfos = helper.getOutputVariableInfos();
        ParameterInfo[] infos = helper.getParameterInfos();
        HashSet<String> declaredVars = new HashSet<String>();
        for (ParameterInfo parameterInfo : infos) {
            declaredVars.add(parameterInfo.getName());
        }
        for (VariableInfo info : ExtractUtil.mustAddVariableDeclaration(helper.getStatements(), outputInfos)) {
            declaredVars.add(info.getName());
        }
        ArrayList<VariableInfo> genDecl = new ArrayList<VariableInfo>();
        Collection<GrVariable> outside = ExtractUtil.collectUsedLocalVarsOrParamsDeclaredOutside(helper);
        for (final GrVariable grVariable : outside) {
            if (declaredVars.contains(grVariable.getName())) continue;
            genDecl.add(new VariableInfo(){

                @Override
                @NotNull
                public String getName() {
                    String string = grVariable.getName();
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                public PsiType getType() {
                    return grVariable.getDeclaredType();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/ExtractUtil$2", "getName"));
                }
            });
        }
        List<GrStatement> statements2 = ExtractUtil.generateVarDeclarations(genDecl, helper.getProject(), null);
        for (GrStatement grStatement : statements2) {
            buffer.append(grStatement.getText()).append('\n');
        }
        StringPartInfo stringPartInfo = helper.getStringPartInfo();
        if (!ExtractUtil.isSingleExpression(helper.getStatements()) && stringPartInfo == null) {
            for (PsiElement psiElement : helper.getInnerElements()) {
                buffer.append(psiElement.getText());
            }
            if (!isVoid && outputInfos.length > 0) {
                buffer.append('\n');
                if (forceReturn) {
                    buffer.append("return ");
                }
                if (outputInfos.length > 1) {
                    buffer.append('[');
                }
                for (VariableInfo variableInfo : outputInfos) {
                    buffer.append(variableInfo.getName()).append(", ");
                }
                buffer.delete(buffer.length() - 2, buffer.length());
                if (outputInfos.length > 1) {
                    buffer.append(']');
                }
            }
        } else {
            boolean addReturn;
            GrLiteral grLiteral = stringPartInfo != null ? stringPartInfo.createLiteralFromSelected() : (GrExpression)PsiUtil.skipParentheses(helper.getStatements()[0], false);
            boolean bl = addReturn = !isVoid && forceReturn && !PsiUtil.isVoidMethodCall(grLiteral);
            if (addReturn) {
                buffer.append("return ");
                GrExpression methodCall = ApplicationStatementUtil.convertToMethodCallExpression(grLiteral);
                buffer.append(methodCall.getText());
            } else {
                buffer.append(grLiteral != null ? grLiteral.getText() : "");
            }
        }
    }

    public static String[] getParameterString(ExtractInfoHelper helper, boolean useCanonicalText) {
        int i = 0;
        ParameterInfo[] infos = helper.getParameterInfos();
        int number = 0;
        for (ParameterInfo info : infos) {
            if (!info.passAsParameter) continue;
            ++number;
        }
        ArrayList<String> params = new ArrayList<String>();
        for (ParameterInfo info : infos) {
            if (!info.passAsParameter) continue;
            PsiType paramType = info.type;
            PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)paramType);
            if (unboxed != null) {
                paramType = unboxed;
            }
            String paramTypeText = paramType == null || paramType.equalsToText("java.lang.Object") || paramType.equals(PsiType.NULL) ? "" : (useCanonicalText ? paramType.getCanonicalText() : paramType.getPresentableText()) + " ";
            params.add(paramTypeText + info.getName() + (i < number - 1 ? ", " : ""));
            ++i;
        }
        return ArrayUtilRt.toStringArray(params);
    }

    @NotNull
    public static String getTypeString(@NotNull ExtractMethodInfoHelper helper, boolean forPresentation, @NotNull String modifier) {
        String returnType2;
        if (helper == null) {
            ExtractUtil.$$$reportNull$$$0(11);
        }
        if (modifier == null) {
            ExtractUtil.$$$reportNull$$$0(12);
        }
        if (!helper.specifyType()) {
            return modifier.isEmpty() ? "def " : "";
        }
        PsiType type2 = helper.getOutputType();
        PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type2);
        if (unboxed != null) {
            type2 = unboxed;
        }
        if (StringUtil.isEmptyOrSpaces((String)(returnType2 = StringUtil.notNullize((String)(forPresentation ? type2.getPresentableText() : type2.getCanonicalText())))) || "null".equals(returnType2)) {
            return modifier.isEmpty() ? "def " : "";
        }
        String string = returnType2 + " ";
        if (string == null) {
            ExtractUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static boolean isSingleExpression(GrStatement[] statements2) {
        return statements2.length == 1 && statements2[0] instanceof GrExpression && (!(statements2[0].getParent() instanceof GrVariableDeclarationOwner) || !(statements2[0] instanceof GrAssignmentExpression));
    }

    private static GrMethodCallExpression createMethodCall(ExtractInfoHelper helper) {
        String[] argumentNames;
        StringBuilder buffer = new StringBuilder();
        ExtractUtil.appendName(buffer, helper.getName());
        buffer.append("(");
        int number = 0;
        for (ParameterInfo info : helper.getParameterInfos()) {
            if (!info.passAsParameter) continue;
            ++number;
        }
        int i = 0;
        for (String argName : argumentNames = helper.getArgumentNames()) {
            if (argName.isEmpty()) continue;
            buffer.append(argName);
            if (i < number - 1) {
                buffer.append(",");
            }
            ++i;
        }
        buffer.append(")");
        String callText = buffer.toString();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(helper.getProject());
        GrExpression expr = factory.createExpressionFromText(callText);
        LOG.assertTrue(expr instanceof GrMethodCallExpression, (Object)callText);
        return (GrMethodCallExpression)expr;
    }

    public static int getCaretOffset(@NotNull GrStatement statement) {
        GrExpression value;
        if (statement == null) {
            ExtractUtil.$$$reportNull$$$0(14);
        }
        if (statement instanceof GrVariableDeclaration) {
            GrExpression initializer;
            GrVariable[] variables = ((GrVariableDeclaration)statement).getVariables();
            if (variables.length > 0 && (initializer = variables[0].getInitializerGroovy()) != null) {
                return initializer.getTextOffset();
            }
        } else if (statement instanceof GrAssignmentExpression && (value = ((GrAssignmentExpression)statement).getRValue()) != null) {
            return value.getTextOffset();
        }
        return statement.getTextOffset();
    }

    public static String getModifierString(ExtractMethodInfoHelper helper) {
        String visibility = helper.getVisibility();
        LOG.assertTrue(visibility != null && !visibility.isEmpty());
        StringBuilder builder = new StringBuilder();
        builder.append(visibility);
        builder.append(" ");
        if (helper.isStatic()) {
            builder.append("static ");
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/extract/ExtractUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/extract/ExtractUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createResultStatement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mustAddVariableDeclaration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTypeString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCaretOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

