/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.memberPullUp;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.memberPullUp.PullUpDialogBase;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.refactoring.ui.ClassCellRenderer;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.classMembers.InterfaceContainmentVerifier;
import com.intellij.refactoring.util.classMembers.UsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.refactoring.classMembers.GrMemberInfo;
import org.jetbrains.plugins.groovy.refactoring.classMembers.GrMemberInfoStorage;
import org.jetbrains.plugins.groovy.refactoring.classMembers.GrMemberSelectionTable;
import org.jetbrains.plugins.groovy.refactoring.memberPullUp.GrPullUpHandler;

class GrPullUpDialog
extends PullUpDialogBase<GrMemberInfoStorage, GrMemberInfo, GrMember, PsiClass> {
    private final Callback myCallback;
    private DocCommentPanel myJavaDocPanel;
    private final InterfaceContainmentVerifier myInterfaceContainmentVerifier = new InterfaceContainmentVerifier(){

        public boolean checkedInterfacesContain(PsiMethod psiMethod) {
            return PullUpProcessor.checkedInterfacesContain((Collection)GrPullUpDialog.this.myMemberInfos, (PsiMethod)psiMethod);
        }
    };
    private static final String PULL_UP_STATISTICS_KEY = "pull.up##";

    GrPullUpDialog(Project project, PsiClass typeDefinition, List<PsiClass> superClasses, GrMemberInfoStorage storage, GrPullUpHandler handler) {
        super(project, (PsiElement)typeDefinition, superClasses, (AbstractMemberInfoStorage)storage, GrPullUpHandler.getRefactoringName());
        this.myCallback = handler;
        this.init();
    }

    public int getJavaDocPolicy() {
        return this.myJavaDocPanel.getPolicy();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.memberPullUp.PullUpDialog";
    }

    InterfaceContainmentVerifier getContainmentVerifier() {
        return this.myInterfaceContainmentVerifier;
    }

    protected void updateMemberInfo() {
        super.updateMemberInfo();
        this.getRefactorAction().setEnabled(((Object)((Object)GroovyLanguage.INSTANCE)).equals(((PsiClass)this.getSuperClass()).getLanguage()));
        ((MyMemberInfoModel)this.myMemberInfoModel).setSuperClass((PsiClass)this.getSuperClass());
        this.myMemberSelectionPanel.getTable().setMemberInfos((Collection)this.myMemberInfos);
        this.myMemberSelectionPanel.getTable().fireExternalDataChange();
    }

    protected void initClassCombo(JComboBox classCombo) {
        classCombo.setRenderer(new ClassCellRenderer(classCombo.getRenderer()));
    }

    protected PsiClass getPreselection() {
        PsiClass preselection = RefactoringHierarchyUtil.getNearestBaseClass((PsiClass)((PsiClass)this.myClass), (boolean)false);
        String statKey = PULL_UP_STATISTICS_KEY + ((PsiClass)this.myClass).getQualifiedName();
        for (StatisticsInfo info : StatisticsManager.getInstance().getAllValues(statKey)) {
            String superClassName = info.getValue();
            PsiClass superClass = null;
            for (PsiClass aClass : this.mySuperClasses) {
                if (!Comparing.strEqual((String)superClassName, (String)aClass.getQualifiedName())) continue;
                superClass = aClass;
                break;
            }
            if (superClass == null || StatisticsManager.getInstance().getUseCount(info) <= 0) continue;
            preselection = superClass;
            break;
        }
        return preselection;
    }

    protected String getHelpId() {
        return "refactoring.pullMembersUp";
    }

    protected void doAction() {
        if (!this.myCallback.checkConflicts(this)) {
            return;
        }
        JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC = this.myJavaDocPanel.getPolicy();
        PsiClass superClass = (PsiClass)this.getSuperClass();
        String name = superClass.getQualifiedName();
        if (name != null) {
            StatisticsManager.getInstance().incUseCount(new StatisticsInfo(PULL_UP_STATISTICS_KEY + ((PsiClass)this.myClass).getQualifiedName(), name));
        }
        List infos = this.getSelectedMemberInfos();
        this.close(0);
    }

    protected void addCustomElementsToCentralPanel(JPanel panel) {
        this.myJavaDocPanel = new DocCommentPanel(JavaRefactoringBundle.message((String)"javadoc.for.abstracts", (Object[])new Object[0]));
        this.myJavaDocPanel.setPolicy(JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC);
        boolean hasJavadoc = false;
        for (GrMemberInfo info : this.myMemberInfos) {
            PsiMember member = (PsiMember)info.getMember();
            if (!this.myMemberInfoModel.isAbstractEnabled((MemberInfoBase)info) || !(member instanceof PsiDocCommentOwner) || ((PsiDocCommentOwner)member).getDocComment() == null) continue;
            hasJavadoc = true;
            break;
        }
        UIUtil.setEnabled((Component)this.myJavaDocPanel, (boolean)hasJavadoc, (boolean)true);
        panel.add((Component)this.myJavaDocPanel, "East");
    }

    protected AbstractMemberSelectionTable<GrMember, GrMemberInfo> createMemberSelectionTable(List<GrMemberInfo> infos) {
        return new GrMemberSelectionTable(infos, RefactoringBundle.message((String)"make.abstract"));
    }

    protected MemberInfoModel<GrMember, GrMemberInfo> createMemberInfoModel() {
        return new MyMemberInfoModel((PsiClass)this.myClass, (PsiClass)this.getSuperClass(), false);
    }

    private class MyMemberInfoModel
    extends UsesAndInterfacesDependencyMemberInfoModel<GrMember, GrMemberInfo> {
        MyMemberInfoModel(PsiClass aClass, PsiClass superClass, boolean recursive) {
            super(aClass, superClass, recursive, GrPullUpDialog.this.myInterfaceContainmentVerifier);
        }

        public boolean isMemberEnabled(GrMemberInfo member) {
            PsiClass currentSuperClass = (PsiClass)GrPullUpDialog.this.getSuperClass();
            if (currentSuperClass == null) {
                return true;
            }
            if (((GrMemberInfoStorage)GrPullUpDialog.this.myMemberInfoStorage).getDuplicatedMemberInfos((PsiElement)currentSuperClass).contains((Object)member)) {
                return false;
            }
            if (((GrMemberInfoStorage)GrPullUpDialog.this.myMemberInfoStorage).getExtending((PsiElement)currentSuperClass).contains(member.getMember())) {
                return false;
            }
            if (!currentSuperClass.isInterface()) {
                return true;
            }
            GrMember element = (GrMember)member.getMember();
            if (element instanceof PsiClass && ((PsiClass)element).isInterface()) {
                return true;
            }
            if (element instanceof PsiField) {
                return element.hasModifierProperty("static");
            }
            if (element instanceof PsiMethod) {
                PsiSubstitutor superSubstitutor;
                MethodSignature signature;
                PsiMethod superClassMethod;
                if (currentSuperClass.isInterface() && (superClassMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)currentSuperClass, (MethodSignature)(signature = ((PsiMethod)element).getSignature(superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)currentSuperClass, (PsiClass)((PsiClass)GrPullUpDialog.this.myClass), (PsiSubstitutor)PsiSubstitutor.EMPTY))), (boolean)false)) != null) {
                    return false;
                }
                return !element.hasModifierProperty("static");
            }
            return true;
        }

        public boolean isAbstractEnabled(GrMemberInfo member) {
            PsiClass currentSuperClass = (PsiClass)GrPullUpDialog.this.getSuperClass();
            return currentSuperClass == null || !currentSuperClass.isInterface();
        }

        public boolean isAbstractWhenDisabled(GrMemberInfo member) {
            PsiClass currentSuperClass = (PsiClass)GrPullUpDialog.this.getSuperClass();
            if (currentSuperClass == null) {
                return false;
            }
            return currentSuperClass.isInterface() && member.getMember() instanceof PsiMethod;
        }

        public int checkForProblems(@NotNull GrMemberInfo member) {
            if (member == null) {
                MyMemberInfoModel.$$$reportNull$$$0(0);
            }
            if (member.isChecked()) {
                return 0;
            }
            PsiClass currentSuperClass = (PsiClass)GrPullUpDialog.this.getSuperClass();
            if (currentSuperClass != null && currentSuperClass.isInterface()) {
                PsiMember element = (PsiMember)member.getMember();
                if (element.hasModifierProperty("static")) {
                    return super.checkForProblems((MemberInfoBase)member);
                }
                return 0;
            }
            return super.checkForProblems((MemberInfoBase)member);
        }

        public Boolean isFixedAbstract(GrMemberInfo member) {
            return Boolean.TRUE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/refactoring/memberPullUp/GrPullUpDialog$MyMemberInfoModel", "checkForProblems"));
        }
    }

    public static interface Callback {
        public boolean checkConflicts(GrPullUpDialog var1);
    }
}

