/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.template.expressions;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class ChooseTypeExpression
extends Expression {
    public static final InsertHandler<PsiTypeLookupItem> IMPORT_FIXER = new InsertHandler<PsiTypeLookupItem>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull PsiTypeLookupItem item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            GroovyCompletionUtil.addImportForItem(context.getFile(), context.getStartOffset(), (LookupElement)item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/template/expressions/ChooseTypeExpression$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    protected final SmartTypePointer myTypePointer;
    private final List<SmartTypePointer> myItems;
    private final boolean myAddDefType;
    private final boolean mySelectDef;

    public ChooseTypeExpression(TypeConstraint @NotNull [] constraints, PsiManager manager, GlobalSearchScope resolveScope) {
        if (constraints == null) {
            ChooseTypeExpression.$$$reportNull$$$0(0);
        }
        this(constraints, manager, resolveScope, true);
    }

    public ChooseTypeExpression(TypeConstraint[] constraints, PsiManager manager, GlobalSearchScope resolveScope, boolean addDefType) {
        this(constraints, manager, resolveScope, addDefType, false);
    }

    public ChooseTypeExpression(TypeConstraint[] constraints, PsiManager manager, GlobalSearchScope resolveScope, boolean addDefType, boolean selectDef) {
        this.myAddDefType = addDefType;
        SmartTypePointerManager typePointerManager = SmartTypePointerManager.getInstance((Project)manager.getProject());
        this.myTypePointer = typePointerManager.createSmartTypePointer(ChooseTypeExpression.chooseType(constraints, resolveScope, manager));
        this.myItems = ChooseTypeExpression.createItems(constraints, typePointerManager);
        this.mySelectDef = selectDef;
    }

    @NotNull
    private static List<SmartTypePointer> createItems(TypeConstraint @NotNull [] constraints, @NotNull SmartTypePointerManager typePointerManager) {
        if (typePointerManager == null) {
            ChooseTypeExpression.$$$reportNull$$$0(1);
        }
        if (constraints == null) {
            ChooseTypeExpression.$$$reportNull$$$0(2);
        }
        ArrayList<SmartTypePointer> result2 = new ArrayList<SmartTypePointer>();
        for (TypeConstraint constraint : constraints) {
            if (constraint instanceof SubtypeConstraint) {
                PsiType type2 = constraint.getDefaultType();
                result2.add(typePointerManager.createSmartTypePointer(type2));
                continue;
            }
            if (!(constraint instanceof SupertypeConstraint)) continue;
            ChooseTypeExpression.processSuperTypes(constraint.getType(), result2, typePointerManager);
        }
        ArrayList<SmartTypePointer> arrayList = result2;
        if (arrayList == null) {
            ChooseTypeExpression.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void processSuperTypes(@NotNull PsiType type2, @NotNull List<SmartTypePointer> result2, @NotNull SmartTypePointerManager typePointerManager) {
        PsiType[] superTypes;
        if (type2 == null) {
            ChooseTypeExpression.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            ChooseTypeExpression.$$$reportNull$$$0(5);
        }
        if (typePointerManager == null) {
            ChooseTypeExpression.$$$reportNull$$$0(6);
        }
        result2.add(typePointerManager.createSmartTypePointer(type2));
        for (PsiType superType : superTypes = type2.getSuperTypes()) {
            ChooseTypeExpression.processSuperTypes(superType, result2, typePointerManager);
        }
    }

    @NotNull
    private static PsiType chooseType(TypeConstraint @NotNull [] constraints, @NotNull GlobalSearchScope scope, @NotNull PsiManager manager) {
        if (scope == null) {
            ChooseTypeExpression.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            ChooseTypeExpression.$$$reportNull$$$0(8);
        }
        if (constraints == null) {
            ChooseTypeExpression.$$$reportNull$$$0(9);
        }
        if (constraints.length > 0) {
            PsiType psiType = constraints[0].getDefaultType();
            if (psiType == null) {
                ChooseTypeExpression.$$$reportNull$$$0(10);
            }
            return psiType;
        }
        PsiClassType psiClassType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope);
        if (psiClassType == null) {
            ChooseTypeExpression.$$$reportNull$$$0(11);
        }
        return psiClassType;
    }

    public Result calculateResult(ExpressionContext context) {
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        PsiType type2 = this.myTypePointer.getType();
        if (type2 != null) {
            if (this.myAddDefType && (type2.equalsToText("java.lang.Object") || this.mySelectDef)) {
                return new TextResult("def");
            }
            if ((type2 = TypesUtil.unboxPrimitiveTypeWrapper(type2)) == null) {
                return null;
            }
            final PsiType finalType = type2;
            return new PsiTypeResult(finalType, context.getProject()){

                public void handleRecalc(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
                    if (ChooseTypeExpression.this.myItems.size() <= 1) {
                        super.handleRecalc(psiFile, document, segmentStart, segmentEnd);
                    } else {
                        JavaTemplateUtil.updateTypeBindings((Object)this.getType(), (PsiFile)psiFile, (Document)document, (int)segmentStart, (int)segmentEnd, (boolean)true);
                    }
                }

                public String toString() {
                    return ChooseTypeExpression.this.myItems.size() == 1 ? super.toString() : finalType.getPresentableText();
                }
            };
        }
        return null;
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (SmartTypePointer item : this.myItems) {
            PsiType type2 = TypesUtil.unboxPrimitiveTypeWrapper(item.getType());
            if (type2 == null) continue;
            PsiTypeLookupItem lookupItem = PsiTypeLookupItem.createLookupItem((PsiType)type2, null, (boolean)PsiTypeLookupItem.isDiamond((PsiType)type2), IMPORT_FIXER);
            result2.add(lookupItem);
        }
        if (this.myAddDefType) {
            LookupElementBuilder def = LookupElementBuilder.create((String)"def").bold();
            if (this.mySelectDef) {
                result2.add(0, def);
            } else {
                result2.add(def);
            }
        }
        return result2.toArray(LookupElement.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePointerManager";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/template/expressions/ChooseTypeExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/template/expressions/ChooseTypeExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createItems";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createItems";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processSuperTypes";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "chooseType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

