/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.transformations.dsl.MemberBuilder;

public interface TransformationContext {
    @NotNull
    public Project getProject();

    @NotNull
    public PsiManager getManager();

    @NotNull
    public JavaPsiFacade getPsiFacade();

    @NotNull
    public GrTypeDefinition getCodeClass();

    @NotNull
    public PsiClass getHierarchyView();

    @NotNull
    public PsiClassType getClassType();

    @NotNull
    public Collection<PsiMethod> getMethods();

    @NotNull
    public Collection<GrField> getFields();

    @NotNull
    public Collection<PsiField> getAllFields(boolean var1);

    @NotNull
    public Collection<PsiClass> getInnerClasses();

    @NotNull
    public List<PsiClassType> getImplementsTypes();

    @NotNull
    public List<PsiClassType> getExtendsTypes();

    @NotNull
    default public List<PsiClassType> getSuperTypes() {
        List list = ContainerUtil.concat(this.getExtendsTypes(), this.getImplementsTypes());
        if (list == null) {
            TransformationContext.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.getCodeClass().getResolveScope();
        if (globalSearchScope == null) {
            TransformationContext.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @Nullable
    public String getClassName();

    @Nullable
    public PsiClass getSuperClass();

    @Nullable
    public PsiAnnotation getAnnotation(@NotNull String var1);

    default public boolean isInheritor(@NotNull String fqn) {
        PsiClass baseClass;
        if (fqn == null) {
            TransformationContext.$$$reportNull$$$0(2);
        }
        return (baseClass = this.getPsiFacade().findClass(fqn, this.getResolveScope())) != null && this.isInheritor(baseClass);
    }

    public boolean isInheritor(@NotNull PsiClass var1);

    @NotNull
    public Collection<PsiMethod> findMethodsByName(@NotNull String var1, boolean var2);

    default public void addMethod(@NotNull PsiMethod method) {
        if (method == null) {
            TransformationContext.$$$reportNull$$$0(3);
        }
        this.addMethod(method, false);
    }

    public void addMethod(@NotNull PsiMethod var1, boolean var2);

    public void addMethods(PsiMethod @NotNull [] var1);

    public void addMethods(@NotNull Collection<? extends PsiMethod> var1);

    public void removeMethod(@NotNull PsiMethod var1);

    public void addField(@NotNull GrField var1);

    public void addInnerClass(@NotNull PsiClass var1);

    public void setSuperType(@NotNull String var1);

    public void setSuperType(@NotNull PsiClassType var1);

    public void addInterface(@NotNull String var1);

    public void addInterface(@NotNull PsiClassType var1);

    @NotNull
    public MemberBuilder getMemberBuilder();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/transformations/TransformationContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/transformations/TransformationContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

