/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class EdtInvocationManager {
    private static final AtomicReference<EdtInvocationManager> ourInstance = new AtomicReference();

    public abstract boolean isEventDispatchThread();

    public abstract void invokeLater(@NotNull Runnable var1);

    public abstract void invokeAndWait(@NotNull Runnable var1) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static EdtInvocationManager getInstance() {
        EdtInvocationManager result = ourInstance.get();
        if (result == null && !ourInstance.compareAndSet(null, result = new SwingEdtInvocationManager())) {
            result = ourInstance.get();
        }
        EdtInvocationManager edtInvocationManager = result;
        if (edtInvocationManager == null) {
            EdtInvocationManager.$$$reportNull$$$0(0);
        }
        return edtInvocationManager;
    }

    public static void setEdtInvocationManager(@NotNull EdtInvocationManager edtInvocationManager) {
        if (edtInvocationManager == null) {
            EdtInvocationManager.$$$reportNull$$$0(1);
        }
        ourInstance.set(edtInvocationManager);
    }

    public void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            EdtInvocationManager.$$$reportNull$$$0(2);
        }
        if (this.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                this.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.getInstance((String)"#com.intellij.util.ui.EdtInvocationManager").error((Throwable)e);
            }
        }
    }

    public static void executeWithCustomManager(@NotNull EdtInvocationManager manager, @NotNull Runnable runnable) {
        if (manager == null) {
            EdtInvocationManager.$$$reportNull$$$0(3);
        }
        if (runnable == null) {
            EdtInvocationManager.$$$reportNull$$$0(4);
        }
        EdtInvocationManager old = null;
        try {
            old = ourInstance.getAndSet(manager);
            runnable.run();
        }
        finally {
            ourInstance.compareAndSet(manager, old);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/EdtInvocationManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtInvocationManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/EdtInvocationManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEdtInvocationManager";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeWithCustomManager";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        @Override
        public boolean isEventDispatchThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        public void invokeLater(@NotNull Runnable task) {
            if (task == null) {
                SwingEdtInvocationManager.$$$reportNull$$$0(0);
            }
            EventQueue.invokeLater(task);
        }

        @Override
        public void invokeAndWait(@NotNull Runnable task) throws InvocationTargetException, InterruptedException {
            if (task == null) {
                SwingEdtInvocationManager.$$$reportNull$$$0(1);
            }
            EventQueue.invokeAndWait(task);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "task";
            objectArray2[1] = "com/intellij/util/ui/EdtInvocationManager$SwingEdtInvocationManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeLater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeAndWait";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

