/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction;

import com.intellij.filePrediction.FilePredictionFeature;
import com.intellij.filePrediction.FilePredictionFeatureProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/filePrediction/FilePredictionGeneralFeatures;", "Lcom/intellij/filePrediction/FilePredictionFeatureProvider;", "()V", "calculateFileFeatures", "", "", "Lcom/intellij/filePrediction/FilePredictionFeature;", "project", "Lcom/intellij/openapi/project/Project;", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "prevFile", "getName", "unify", "path", "intellij.filePrediction"})
public final class FilePredictionGeneralFeatures
implements FilePredictionFeatureProvider {
    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    @NotNull
    public Map<String, FilePredictionFeature> calculateFileFeatures(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable VirtualFile prevFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
        HashMap result = new HashMap();
        ApplicationManager.getApplication().runReadAction(new Runnable(newFile, project, result, prevFile){
            final /* synthetic */ VirtualFile $newFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ HashMap $result;
            final /* synthetic */ VirtualFile $prevFile;

            public final void run() {
                if (this.$newFile.isValid()) {
                    FileIndexFacade fileIndex = FileIndexFacade.getInstance((Project)this.$project);
                    ((Map)this.$result).put("in_project", FilePredictionFeature.Companion.binary(fileIndex.isInProjectScope(this.$newFile)));
                    ((Map)this.$result).put("in_source", FilePredictionFeature.Companion.binary(fileIndex.isInSource(this.$newFile)));
                    ((Map)this.$result).put("in_library", FilePredictionFeature.Companion.binary(fileIndex.isInLibraryClasses(this.$newFile) || fileIndex.isInLibrarySource(this.$newFile)));
                    ((Map)this.$result).put("excluded", FilePredictionFeature.Companion.binary(fileIndex.isExcludedFile(this.$newFile)));
                    if (this.$prevFile != null && this.$prevFile.isValid()) {
                        Module newModule = fileIndex.getModuleForFile(this.$newFile);
                        ((Map)this.$result).put("same_module", FilePredictionFeature.Companion.binary(newModule != null && Intrinsics.areEqual((Object)newModule, (Object)fileIndex.getModuleForFile(this.$prevFile))));
                    }
                }
            }
            {
                this.$newFile = virtualFile;
                this.$project = project;
                this.$result = hashMap;
                this.$prevFile = virtualFile2;
            }
        });
        if (prevFile != null) {
            String baseDir;
            String string;
            String string2 = newFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"newFile.name");
            String newFileName = this.unify(string2);
            String string3 = newFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"newFile.path");
            String newFilePath = this.unify(string3);
            String string4 = prevFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"prevFile.name");
            String prevFileName = this.unify(string4);
            ((Map)result).put("name_prefix", FilePredictionFeature.Companion.numerical(StringUtil.commonPrefixLength((CharSequence)newFileName, (CharSequence)prevFileName)));
            String string5 = prevFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"prevFile.path");
            String prevFilePath = this.unify(string5);
            ((Map)result).put("path_prefix", FilePredictionFeature.Companion.numerical(StringUtil.commonPrefixLength((CharSequence)newFilePath, (CharSequence)prevFilePath)));
            Object object = ProjectUtil.guessProjectDir((Project)project);
            if (object != null && (object = object.getPath()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                Object object3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                string = this.unify((String)object3);
            } else {
                string = baseDir = null;
            }
            if (baseDir != null) {
                String newRelativePath = FileUtil.getRelativePath(baseDir, (String)newFilePath, (char)File.separatorChar, (boolean)false);
                String prevRelativePath = FileUtil.getRelativePath(baseDir, (String)prevFilePath, (char)File.separatorChar, (boolean)false);
                if (newRelativePath != null && prevRelativePath != null) {
                    ((Map)result).put("relative_path_prefix", FilePredictionFeature.Companion.numerical(StringUtil.commonPrefixLength((CharSequence)newRelativePath, (CharSequence)prevRelativePath)));
                }
            }
            ((Map)result).put("same_dir", FilePredictionFeature.Companion.binary(Intrinsics.areEqual((Object)PathUtil.getParentPath((String)newFilePath), (Object)PathUtil.getParentPath((String)prevFilePath))));
        }
        return result;
    }

    private final String unify(String path) {
        String string;
        boolean caseSensitive = SystemInfo.isFileSystemCaseSensitive;
        if (caseSensitive) {
            String string2 = FileUtil.getNameWithoutExtension((String)path);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtil.getNameWithoutExtension(path)");
        } else {
            String string3 = FileUtil.getNameWithoutExtension((String)StringUtil.toLowerCase((String)path));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"FileUtil.getNameWithoutE\u2026ension(toLowerCase(path))");
        }
        return string;
    }
}

