/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RelocateNodeJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ClipboardDecoder;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;

public class PasteJob
extends BatchSelectionJob {
    private FXOMObject targetObject;
    private List<FXOMObject> newObjects;

    public PasteJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (fxomDocument != null) {
            ClipboardDecoder clipboardDecoder = new ClipboardDecoder(Clipboard.getSystemClipboard());
            this.newObjects = clipboardDecoder.decode(fxomDocument);
            assert (this.newObjects != null);
            if (!this.newObjects.isEmpty()) {
                if (fxomDocument.getFxomRoot() == null) {
                    this.targetObject = null;
                } else {
                    Selection selection = this.getEditorController().getSelection();
                    FXOMObject rootObject = fxomDocument.getFxomRoot();
                    this.targetObject = selection.isEmpty() || selection.isSelected(rootObject) ? rootObject : selection.getAncestor();
                }
                assert (this.targetObject != null || fxomDocument.getFxomRoot() == null);
                if (this.targetObject == null) {
                    if (this.newObjects.size() == 1) {
                        FXOMObject newObject0 = this.newObjects.get(0);
                        SetDocumentRootJob subJob = new SetDocumentRootJob(newObject0, this.getEditorController());
                        result.add(subJob);
                    }
                } else {
                    DesignHierarchyMask targetMask = new DesignHierarchyMask(this.targetObject);
                    if (targetMask.isAcceptingSubComponent(this.newObjects)) {
                        double relocateDelta;
                        if (targetMask.isFreeChildPositioning()) {
                            int pasteJobCount = this.countPasteJobs();
                            relocateDelta = 10.0 * (double)(pasteJobCount + 1);
                        } else {
                            relocateDelta = 0.0;
                        }
                        for (FXOMObject newObject : this.newObjects) {
                            InsertAsSubComponentJob subJob = new InsertAsSubComponentJob(newObject, this.targetObject, targetMask.getSubComponentCount(), this.getEditorController());
                            result.add(0, subJob);
                            if (relocateDelta == 0.0 || !newObject.isNode()) continue;
                            Node sceneGraphNode = (Node)newObject.getSceneGraphObject();
                            RelocateNodeJob relocateJob = new RelocateNodeJob((FXOMInstance)newObject, sceneGraphNode.getLayoutX() + relocateDelta, sceneGraphNode.getLayoutY() + relocateDelta, this.getEditorController());
                            result.add(relocateJob);
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result = this.newObjects.size() == 1 ? this.makeSingleSelectionDescription() : this.makeMultipleSelectionDescription();
        return result;
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        assert (this.newObjects != null);
        if (this.newObjects.isEmpty()) {
            return null;
        }
        return new ObjectSelectionGroup(this.newObjects, this.newObjects.iterator().next(), null);
    }

    private String makeSingleSelectionDescription() {
        String result;
        assert (this.newObjects.size() == 1);
        FXOMObject newObject = this.newObjects.get(0);
        if (newObject instanceof FXOMInstance) {
            Object sceneGraphObject = newObject.getSceneGraphObject();
            result = sceneGraphObject != null ? I18N.getString("label.action.edit.paste.1", sceneGraphObject.getClass().getSimpleName()) : I18N.getString("label.action.edit.paste.unresolved");
        } else if (newObject instanceof FXOMCollection) {
            result = I18N.getString("label.action.edit.paste.collection");
        } else {
            assert (false);
            result = I18N.getString("label.action.edit.paste.1", newObject.getClass().getSimpleName());
        }
        return result;
    }

    private String makeMultipleSelectionDescription() {
        int objectCount = this.newObjects.size();
        return I18N.getString("label.action.edit.paste.n", objectCount);
    }

    private int countPasteJobs() {
        int result = 0;
        List<Job> undoStack = this.getEditorController().getJobManager().getUndoStack();
        for (Job job : undoStack) {
            if (!(job instanceof PasteJob)) break;
            PasteJob pasteJob = (PasteJob)job;
            if (this.targetObject != pasteJob.targetObject) break;
            ++result;
        }
        return result;
    }
}

