/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.reference;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.InlineDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCloner;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import java.util.LinkedList;
import java.util.List;

public class ExpandExpressionReferenceJob
extends InlineDocumentJob {
    private final FXOMPropertyT reference;
    private final FXOMCloner cloner;

    public ExpandExpressionReferenceJob(FXOMPropertyT reference, FXOMCloner cloner, EditorController editorController) {
        super(editorController);
        assert (reference != null);
        assert (reference.getFxomDocument() == editorController.getFxomDocument());
        assert (cloner == null || cloner.getTargetDocument() == editorController.getFxomDocument());
        this.reference = reference;
        this.cloner = cloner;
    }

    @Override
    protected List<Job> makeAndExecuteSubJobs() {
        LinkedList<Job> result = new LinkedList<Job>();
        FXOMInstance parentInstance = this.reference.getParentInstance();
        RemovePropertyJob removeReference = new RemovePropertyJob(this.reference, this.getEditorController());
        ((Job)removeReference).execute();
        result.add(removeReference);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        String fxId = FXOMNodes.extractReferenceSource(this.reference);
        FXOMObject referee = fxomDocument.searchWithFxId(fxId);
        FXOMObject refereeClone = this.cloner.clone(referee);
        FXOMPropertyC cloneProperty = new FXOMPropertyC(fxomDocument, this.reference.getName(), refereeClone);
        AddPropertyJob addCloneJob = new AddPropertyJob(cloneProperty, parentInstance, -1, this.getEditorController());
        ((Job)addCloneJob).execute();
        result.add(addCloneJob);
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isExecutable() {
        PrefixedValue pv = new PrefixedValue(this.reference.getValue());
        return pv.isExpression();
    }
}

