/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.util;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public abstract class AbstractWindowController {
    private final Window owner;
    private Parent root;
    private Scene scene;
    private Stage stage;
    private final double CLAMP_FACTOR = 0.9;
    private final boolean sizeToScene;
    private String toolStylesheet = EditorController.getBuiltinToolStylesheet();
    private final EventHandler<WindowEvent> closeRequestHandler = event -> {
        this.onCloseRequest((WindowEvent)event);
        event.consume();
    };

    public AbstractWindowController() {
        this(null, true);
    }

    public AbstractWindowController(Window owner) {
        this(owner, true);
    }

    public AbstractWindowController(Window owner, boolean sizeToScene) {
        this.owner = owner;
        this.sizeToScene = sizeToScene;
    }

    public Parent getRoot() {
        if (this.root == null) {
            this.makeRoot();
            assert (this.root != null);
            this.toolStylesheetDidChange(null);
        }
        return this.root;
    }

    public Scene getScene() {
        assert (Platform.isFxApplicationThread());
        if (this.scene == null) {
            this.scene = new Scene(this.getRoot());
            this.controllerDidCreateScene();
        }
        return this.scene;
    }

    public Stage getStage() {
        assert (Platform.isFxApplicationThread());
        if (this.stage == null) {
            this.stage = new Stage();
            this.stage.initOwner(this.owner);
            this.stage.setOnCloseRequest(this.closeRequestHandler);
            this.stage.setScene(this.getScene());
            this.clampWindow();
            if (this.sizeToScene) {
                this.stage.sizeToScene();
            }
            this.controllerDidCreateStage();
        }
        return this.stage;
    }

    public void openWindow() {
        assert (Platform.isFxApplicationThread());
        this.getStage().show();
        this.getStage().toFront();
    }

    public void closeWindow() {
        assert (Platform.isFxApplicationThread());
        this.getStage().close();
    }

    public String getToolStylesheet() {
        return this.toolStylesheet;
    }

    public void setToolStylesheet(String toolStylesheet) {
        String oldStylesheet = this.toolStylesheet;
        this.toolStylesheet = toolStylesheet;
        if (this.root != null) {
            this.toolStylesheetDidChange(oldStylesheet);
        }
    }

    protected abstract void makeRoot();

    public abstract void onCloseRequest(WindowEvent var1);

    protected void controllerDidCreateScene() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() != null);
        assert (this.getRoot().getScene().getWindow() == null);
    }

    protected void controllerDidCreateStage() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() != null);
        assert (this.getRoot().getScene().getWindow() != null);
    }

    protected final void setRoot(Parent root) {
        assert (root != null);
        this.root = root;
    }

    protected void toolStylesheetDidChange(String oldStylesheet) {
        ObservableList stylesheets = this.root.getStylesheets();
        if (oldStylesheet != null) {
            stylesheets.remove(oldStylesheet);
        }
        stylesheets.add(this.toolStylesheet);
    }

    private void clampWindow() {
        if (this.getRoot() instanceof Region) {
            Rectangle2D vBounds = Screen.getPrimary().getVisualBounds();
            double primaryScreenHeight = vBounds.getHeight();
            double primaryScreenWidth = vBounds.getWidth();
            double currentHeight = this.getRoot().prefHeight(-1.0);
            double currentWidth = this.getRoot().prefWidth(-1.0);
            if (currentHeight > primaryScreenHeight) {
                double newHeight = primaryScreenHeight * 0.9;
                assert (this.getRoot() instanceof Region);
                ((Region)this.getRoot()).setPrefHeight(newHeight);
            }
            if (currentWidth > primaryScreenWidth) {
                double newWidth = primaryScreenWidth * 0.9;
                assert (this.getRoot() instanceof Region);
                ((Region)this.getRoot()).setPrefWidth(newWidth);
            }
        }
    }

    protected Rectangle2D getBiggestViewableRectangle() {
        Rectangle2D res;
        assert (this.stage != null);
        if (Screen.getScreens().size() == 1) {
            res = Screen.getPrimary().getVisualBounds();
        } else {
            Rectangle2D stageRect = new Rectangle2D(this.stage.getX(), this.stage.getY(), this.stage.getWidth(), this.stage.getHeight());
            ObservableList screens = Screen.getScreensForRectangle((Rectangle2D)stageRect);
            res = ((Screen)screens.get(0)).getVisualBounds();
        }
        return res;
    }
}

