/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class FXOMArchive
implements Serializable {
    private static final long serialVersionUID = 7777L;
    private final List<Entry> entries = new ArrayList<Entry>();

    public FXOMArchive(List<FXOMObject> fxomObjects) {
        assert (fxomObjects != null);
        for (FXOMObject o : fxomObjects) {
            URL location = o.getFxomDocument().getLocation();
            String fxmlText = FXOMNodes.newDocument(o).getFxmlText();
            this.entries.add(new Entry(fxmlText, location));
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public List<FXOMObject> decode(FXOMDocument targetDocument) throws IOException {
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        assert (targetDocument != null);
        for (Entry e : this.entries) {
            URL location = e.getLocation();
            String fxmlText = e.getFxmlText();
            FXOMDocument d = new FXOMDocument(fxmlText, location, targetDocument.getClassLoader(), targetDocument.getResources());
            FXOMObject fxomRoot = d.getFxomRoot();
            assert (fxomRoot != null);
            fxomRoot.moveToFxomDocument(targetDocument);
            result.add(fxomRoot);
        }
        return result;
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 8888L;
        private final String fxmlText;
        private final URL location;

        public Entry(String fxmlText, URL location) {
            this.fxmlText = fxmlText;
            this.location = location;
        }

        public String getFxmlText() {
            return this.fxmlText;
        }

        public URL getLocation() {
            return this.location;
        }
    }
}

