/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.glue;

import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueAuxiliary;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueCharacters;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueInstruction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

class GlueLoader
implements ContentHandler,
ErrorHandler,
LexicalHandler {
    private final GlueDocument document;
    private GlueElement currentElement;
    private int currentElementDepth = -1;
    private final List<GlueAuxiliary> auxiliaries = new ArrayList<GlueAuxiliary>();
    private final Map<String, String> prefixMappings = new HashMap<String, String>();

    public GlueLoader(GlueDocument document) {
        this.document = document;
    }

    public void load(String xmlText) throws IOException {
        assert (xmlText != null);
        assert (!GlueDocument.isEmptyXmlText(xmlText));
        Charset utf8 = Charset.forName("UTF-8");
        try (ByteArrayInputStream is = new ByteArrayInputStream(xmlText.getBytes(utf8));){
            this.load(is);
        }
    }

    public void load(InputStream is) throws IOException {
        assert (this.currentElement == null);
        assert (this.currentElementDepth == -1);
        assert (this.auxiliaries.isEmpty());
        assert (this.prefixMappings.isEmpty());
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            xr.parse(new InputSource(is));
        }
        catch (SAXException x) {
            throw new IOException(x);
        }
        assert (this.currentElement == null);
        assert (this.currentElementDepth == -1);
        assert (this.auxiliaries.isEmpty());
        assert (this.prefixMappings.isEmpty());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        assert (this.currentElement == null);
        assert (this.currentElementDepth == -1);
        assert (this.auxiliaries.isEmpty());
    }

    @Override
    public void endDocument() throws SAXException {
        assert (this.document != null);
        assert (this.currentElement == null);
        assert (this.currentElementDepth == -1);
        assert (this.auxiliaries.isEmpty());
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMappings.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        assert (this.prefixMappings.isEmpty());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.currentElementDepth;
        GlueElement newElement = new GlueElement(this.document, qName, this.currentElementDepth, false);
        Map<String, String> attributes = newElement.getAttributes();
        int count = atts.getLength();
        for (int i = 0; i < count; ++i) {
            attributes.put(atts.getQName(i), atts.getValue(i));
        }
        for (Map.Entry<String, String> e : this.prefixMappings.entrySet()) {
            if (e.getKey().isEmpty()) {
                newElement.getAttributes().put("xmlns", e.getValue());
                continue;
            }
            newElement.getAttributes().put("xmlns:" + e.getKey(), e.getValue());
        }
        newElement.getFront().addAll(this.auxiliaries);
        if (this.currentElement == null) {
            assert (this.currentElementDepth == 0);
            this.document.setRootElement(newElement);
        } else {
            newElement.addToParent(this.currentElement);
        }
        this.currentElement = newElement;
        this.auxiliaries.clear();
        this.prefixMappings.clear();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        assert (this.currentElement != null);
        assert (this.currentElement.getTagName().equals(qName));
        assert (this.currentElementDepth >= 0);
        if (this.currentElement.getChildren().isEmpty()) {
            this.currentElement.getContent().addAll(this.auxiliaries);
        } else {
            this.currentElement.getTail().addAll(this.auxiliaries);
        }
        this.currentElement = this.currentElement.getParent();
        --this.currentElementDepth;
        this.auxiliaries.clear();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length);
        GlueCharacters auxiliary = new GlueCharacters(this.document, GlueCharacters.Type.TEXT, data);
        if (this.currentElement == null) {
            this.document.getHeader().add(auxiliary);
        } else {
            this.auxiliaries.add(auxiliary);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        assert (this.currentElement == null);
        assert (this.currentElementDepth == -1);
        this.document.getHeader().add(new GlueInstruction(this.document, target, data));
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        throw new UnsupportedOperationException("name=" + name);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        throw new UnsupportedOperationException("name=" + name + ", publicId=" + publicId + ", systemId=" + systemId);
    }

    @Override
    public void endDTD() throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        throw new UnsupportedOperationException("name=" + name);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startCDATA() throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void endCDATA() throws SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length);
        GlueCharacters auxiliary = new GlueCharacters(this.document, GlueCharacters.Type.COMMENT, data);
        if (this.currentElement == null) {
            this.document.getHeader().add(auxiliary);
        } else {
            this.auxiliaries.add(auxiliary);
        }
    }
}

