/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.ant.model.impl;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ant.model.JpsAntInstallation;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;

public class JpsAntInstallationImpl
extends JpsElementBase<JpsAntInstallationImpl>
implements JpsAntInstallation {
    private final File myAntHome;
    private final String myName;
    private final List<String> myClasspath;
    private final List<String> myJarDirectories;
    private static final JpsElementChildRoleBase<JpsAntInstallation> ROLE = JpsElementChildRoleBase.create((String)"ant installation");
    public static final JpsElementCollectionRole<JpsAntInstallation> COLLECTION_ROLE = JpsElementCollectionRole.create(ROLE);

    public JpsAntInstallationImpl(File antHome, String name, List<String> classpath, List<String> jarDirectories) {
        this.myAntHome = antHome;
        this.myName = name;
        this.myClasspath = classpath;
        this.myJarDirectories = jarDirectories;
    }

    @NotNull
    public JpsAntInstallationImpl createCopy() {
        return new JpsAntInstallationImpl(this.myAntHome, this.myName, this.myClasspath, this.myJarDirectories);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public void applyChanges(@NotNull JpsAntInstallationImpl modified) {
        if (modified == null) {
            JpsAntInstallationImpl.$$$reportNull$$$0(0);
        }
    }

    @Override
    public File getAntHome() {
        return this.myAntHome;
    }

    @Override
    public List<String> getClasspath() {
        return JpsAntInstallationImpl.getClasspath(this.myClasspath, this.myJarDirectories);
    }

    public static List<String> getClasspath(List<String> classpath, List<String> jarDirectories) {
        ArrayList<String> result = new ArrayList<String>(classpath);
        for (String directory : jarDirectories) {
            JpsAntInstallationImpl.addAllJarsFromDirectory(result, new File(directory));
        }
        return result;
    }

    public static void addAllJarsFromDirectory(List<? super String> classpath, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".jar")) continue;
                classpath.add(file.getAbsolutePath());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/ant/model/impl/JpsAntInstallationImpl", "applyChanges"));
    }
}

