/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateStringLiteral;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.StringSearcher;
import com.siyeh.ig.style.UnnecessarilyQualifiedStaticUsageInspection;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateStringLiteralInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final int MAX_FILES_TO_ON_THE_FLY_SEARCH = 10;
    public int MIN_STRING_LENGTH = 5;
    public boolean IGNORE_PROPERTY_KEYS;
    @NonNls
    private static final String BR = "<br>";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                DuplicateStringLiteralInspection.this.checkStringLiteralExpression(expression, holder, isOnTheFly);
            }
        };
    }

    @NotNull
    public String getShortName() {
        return "DuplicateStringLiteralInspection";
    }

    @NotNull
    private static List<PsiLiteralExpression> findDuplicateLiterals(final @NotNull StringLiteralSearchQuery query, final @NotNull Project project) {
        if (query == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(2);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List words = ContainerUtil.filter((Collection)StringUtil.getWordsInStringLongestFirst((String)query.stringToFind), s -> s.length() >= query.minStringLength);
        if (words.isEmpty()) {
            List<PsiLiteralExpression> list = Collections.emptyList();
            if (list == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(3);
            }
            return list;
        }
        final ArrayList<PsiLiteralExpression> foundExpressions = new ArrayList<PsiLiteralExpression>();
        List indexKeys = ContainerUtil.map((Collection)words, word -> new IdIndexEntry(word, true));
        FileBasedIndex.getInstance().processFilesContainingAllKeys(IdIndex.NAME, (Collection)indexKeys, scope, mask -> (mask & 4) != 0, (Processor)new Processor<VirtualFile>(){
            int filesWithLiterals;

            public boolean process(VirtualFile f) {
                List duplicateLiteralsInFile;
                FileViewProvider viewProvider = PsiManager.getInstance((Project)project).findViewProvider(f);
                if (viewProvider == null || viewProvider.getPsi((Language)JavaLanguage.INSTANCE) == null) {
                    return true;
                }
                PsiFile psiFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
                if (psiFile != null && !(duplicateLiteralsInFile = DuplicateStringLiteralInspection.findDuplicateLiteralsInFile(query.stringToFind, query.ignorePropertyKeys, psiFile)).isEmpty()) {
                    foundExpressions.addAll(duplicateLiteralsInFile);
                    if (query.isOnFlySearch && ++this.filesWithLiterals >= 10) {
                        return false;
                    }
                }
                ProgressManager.checkCanceled();
                return true;
            }
        });
        ArrayList<PsiLiteralExpression> arrayList = foundExpressions;
        if (arrayList == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiLiteralExpression> findDuplicateLiteralsInFile(@NotNull String stringToFind, boolean ignorePropertyKeys, @NotNull PsiFile file) {
        if (stringToFind == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(6);
        }
        ProgressManager.checkCanceled();
        CharSequence text = file.getViewProvider().getContents();
        StringSearcher searcher = new StringSearcher(stringToFind, true, true);
        SmartList foundExpr = new SmartList();
        LowLevelSearchUtil.processTextOccurrences((CharSequence)text, (int)0, (int)text.length(), (StringSearcher)searcher, arg_0 -> DuplicateStringLiteralInspection.lambda$findDuplicateLiteralsInFile$3(file, stringToFind, ignorePropertyKeys, (List)foundExpr, arg_0));
        SmartList smartList = foundExpr;
        if (smartList == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private void checkStringLiteralExpression(@NotNull PsiLiteralExpression originalExpression, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiExpression[] foundExpr;
        if (originalExpression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(9);
        }
        if ((foundExpr = this.getDuplicateLiterals(holder.getProject(), originalExpression, isOnTheFly)).length == 0) {
            return;
        }
        THashSet classes = new THashSet();
        for (PsiExpression aClass2 : foundExpr) {
            if (aClass2 == originalExpression) continue;
            ProgressManager.checkCanceled();
            while ((aClass2 = PsiTreeUtil.getParentOfType((PsiElement)aClass2, PsiClass.class)) != null && ((PsiClass)aClass2).getQualifiedName() == null) {
            }
            if (aClass2 == null) continue;
            classes.add((PsiClass)aClass2);
        }
        if (classes.isEmpty()) {
            return;
        }
        List tenClassesMost = ContainerUtil.getFirstItems(Arrays.asList(classes.toArray(PsiClass.EMPTY_ARRAY)), (int)10);
        String classList = isOnTheFly ? StringUtil.join((Collection)tenClassesMost, aClass -> {
            boolean thisFile = aClass.getContainingFile() == originalExpression.getContainingFile();
            return "&nbsp;&nbsp;&nbsp;'<b>" + aClass.getQualifiedName() + "</b>'" + (thisFile ? " " + JavaI18nBundle.message("inspection.duplicates.message.in.this.file", new Object[0]) : "");
        }, (String)", <br>") : StringUtil.join((Collection)tenClassesMost, aClass -> "'" + aClass.getQualifiedName() + "'", (String)", ");
        if (classes.size() > tenClassesMost.size()) {
            classList = classList + BR + JavaI18nBundle.message("inspection.duplicates.message.more", classes.size() - 10);
        }
        String msg = JavaI18nBundle.message("inspection.duplicates.message", classList);
        SmartList fixes = new SmartList();
        if (isOnTheFly) {
            fixes.add(new IntroduceLiteralConstantFix(originalExpression));
            fixes.add(new NavigateToOccurrencesFix(originalExpression));
        }
        DuplicateStringLiteralInspection.createReplaceFixes(foundExpr, (PsiExpression)originalExpression, (Collection<? super LocalQuickFix>)fixes);
        LocalQuickFix[] array = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem((PsiElement)originalExpression, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, array);
    }

    private PsiExpression @NotNull [] getDuplicateLiterals(@NotNull Project project, @NotNull PsiLiteralExpression place, boolean isOnTheFly) {
        Object value;
        if (project == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(10);
        }
        if (place == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(11);
        }
        if (!((value = place.getValue()) instanceof String)) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(12);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        if (!DuplicateStringLiteralInspection.shouldCheck(place, this.IGNORE_PROPERTY_KEYS)) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(13);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        String stringToFind = (String)value;
        if (stringToFind.isEmpty()) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                DuplicateStringLiteralInspection.$$$reportNull$$$0(14);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap duplicates = ConcurrentFactoryMap.createMap(q -> DuplicateStringLiteralInspection.findDuplicateLiterals(q, project).toArray(PsiExpression.EMPTY_ARRAY));
            return CachedValueProvider.Result.create((Object)duplicates, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        PsiExpression[] psiExpressionArray = (PsiExpression[])map.get(new StringLiteralSearchQuery(stringToFind, this.IGNORE_PROPERTY_KEYS, this.MIN_STRING_LENGTH, isOnTheFly));
        if (psiExpressionArray == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(15);
        }
        return psiExpressionArray;
    }

    private static boolean shouldCheck(@NotNull PsiLiteralExpression expression, boolean ignorePropertyKeys) {
        if (expression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(16);
        }
        if (ignorePropertyKeys && JavaI18nUtil.mustBePropertyKey((PsiExpression)expression, null)) {
            return false;
        }
        return !SuppressManager.isSuppressedInspectionName((PsiLiteralExpression)expression);
    }

    private static void createReplaceFixes(PsiExpression @NotNull [] foundExpr, @NotNull PsiExpression originalExpression, @NotNull Collection<? super LocalQuickFix> fixes) {
        if (originalExpression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(17);
        }
        if (fixes == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(18);
        }
        if (foundExpr == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(19);
        }
        for (PsiExpression expr : foundExpr) {
            boolean isAccessible;
            PsiClass containingClass;
            PsiField field;
            PsiElement parent;
            if (expr == originalExpression || !((parent = expr.getParent()) instanceof PsiField) || (field = (PsiField)parent).getInitializer() != expr || !field.hasModifierProperty("static") || (containingClass = field.getContainingClass()) == null || !(isAccessible = JavaPsiFacade.getInstance((Project)field.getProject()).getResolveHelper().isAccessible((PsiMember)field, (PsiElement)originalExpression, containingClass)) && containingClass.getQualifiedName() == null) continue;
            fixes.add((LocalQuickFix)new ReplaceFix(field, originalExpression));
        }
    }

    @Nullable
    private static PsiReferenceExpression createReferenceTo(@NotNull PsiField constant) throws IncorrectOperationException {
        if (constant == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(20);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)constant.getProject()).getElementFactory();
        PsiReferenceExpression reference = (PsiReferenceExpression)factory.createExpressionFromText("XXX." + constant.getName(), null);
        PsiReferenceExpression classQualifier = (PsiReferenceExpression)reference.getQualifierExpression();
        PsiClass containingClass = constant.getContainingClass();
        if (containingClass.getQualifiedName() == null) {
            return null;
        }
        classQualifier.bindToElement((PsiElement)containingClass);
        if (reference.isReferenceTo((PsiElement)constant)) {
            return reference;
        }
        return null;
    }

    public JComponent createOptionsPanel() {
        final OptionsPanel optionsPanel = new OptionsPanel();
        optionsPanel.myIgnorePropertyKeyExpressions.addActionListener(e -> {
            this.IGNORE_PROPERTY_KEYS = optionsPanel.myIgnorePropertyKeyExpressions.isSelected();
        });
        optionsPanel.myMinStringLengthField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    DuplicateStringLiteralInspection.this.MIN_STRING_LENGTH = Integer.parseInt(optionsPanel.myMinStringLengthField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$3", "textChanged"));
            }
        });
        optionsPanel.myIgnorePropertyKeyExpressions.setSelected(this.IGNORE_PROPERTY_KEYS);
        optionsPanel.myMinStringLengthField.setText(Integer.toString(this.MIN_STRING_LENGTH));
        return optionsPanel.myPanel;
    }

    private PsiExpression @Nullable [] getDuplicateLiteralsUnderProgress(@NotNull PsiElement literalExpression) {
        if (literalExpression == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(21);
        }
        if (!(literalExpression instanceof PsiLiteralExpression)) {
            return null;
        }
        Project project = literalExpression.getProject();
        return (PsiExpression[])ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.getDuplicateLiterals(project, (PsiLiteralExpression)literalExpression, false), JavaI18nBundle.message("progress.title.searching.for.duplicates.of.0", ((PsiLiteralExpression)literalExpression).getValue()), true, project);
    }

    private static void introduceConstant(final PsiExpression @NotNull [] expressions, @NotNull Project project) {
        if (project == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(22);
        }
        if (expressions == null) {
            DuplicateStringLiteralInspection.$$$reportNull$$$0(23);
        }
        new IntroduceConstantHandler(){

            protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
                return new BaseOccurrenceManager(occurrence -> true){

                    protected PsiExpression @NotNull [] defaultOccurrences() {
                        if (expressions == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return expressions;
                    }

                    protected PsiExpression @NotNull [] findOccurrences() {
                        if (expressions == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return expressions;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$4$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "defaultOccurrences";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "findOccurrences";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }
        }.invoke(project, expressions);
    }

    private static /* synthetic */ boolean lambda$findDuplicateLiteralsInFile$3(PsiFile file, String stringToFind, boolean ignorePropertyKeys, List foundExpr, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element == null || !(element.getParent() instanceof PsiLiteralExpression)) {
            return true;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)element.getParent();
        if (Comparing.equal((Object)stringToFind, (Object)expression.getValue()) && DuplicateStringLiteralInspection.shouldCheck(expression, ignorePropertyKeys)) {
            foundExpr.add(expression);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: 
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToFind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundExpr";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findDuplicateLiterals";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findDuplicateLiteralsInFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicateLiterals";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicateLiterals";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicateLiteralsInFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkStringLiteralExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateLiterals";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheck";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceFixes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceTo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateLiteralsUnderProgress";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "introduceConstant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringLiteralSearchQuery {
        @NotNull
        private final String stringToFind;
        private final boolean ignorePropertyKeys;
        private final int minStringLength;
        private final boolean isOnFlySearch;

        private StringLiteralSearchQuery(@NotNull String stringToFind, boolean ignorePropertyKeys, int minStringLength, boolean isOnFlySearch) {
            if (stringToFind == null) {
                StringLiteralSearchQuery.$$$reportNull$$$0(0);
            }
            this.stringToFind = stringToFind;
            this.ignorePropertyKeys = ignorePropertyKeys;
            this.minStringLength = minStringLength;
            this.isOnFlySearch = isOnFlySearch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringLiteralSearchQuery query = (StringLiteralSearchQuery)o;
            return this.ignorePropertyKeys == query.ignorePropertyKeys && this.minStringLength == query.minStringLength && this.isOnFlySearch == query.isOnFlySearch && Objects.equals(this.stringToFind, query.stringToFind);
        }

        public int hashCode() {
            return Objects.hash(this.stringToFind, this.ignorePropertyKeys, this.minStringLength, this.isOnFlySearch);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToFind", "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$StringLiteralSearchQuery", "<init>"));
        }
    }

    private class NavigateToOccurrencesFix
    extends LocalQuickFixOnPsiElement {
        NavigateToOccurrencesFix(PsiLiteralExpression representative) {
            super((PsiElement)representative);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, final @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiExpression[] literalExpressions;
            if (project == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(3);
            }
            if ((literalExpressions = DuplicateStringLiteralInspection.this.getDuplicateLiteralsUnderProgress(startElement)) == null) {
                return;
            }
            Usage[] usages = (Usage[])Stream.of(literalExpressions).map(UsageInfo::new).map(UsageInfo2UsageAdapter::new).toArray(Usage[]::new);
            UsageViewPresentation presentation = new UsageViewPresentation();
            String title = JavaI18nBundle.message("inspection.duplicates.occurrences.view.title", ((PsiLiteralExpression)startElement).getValue());
            presentation.setUsagesString(title);
            presentation.setTabName(title);
            presentation.setTabText(title);
            presentation.setShowCancelButton(true);
            UsageView view = UsageViewManager.getInstance((Project)project).showUsages(new UsageTarget[]{new PsiElement2UsageTargetAdapter(startElement){

                public String getPresentableText() {
                    return "String literal: '" + ((PsiLiteralExpression)startElement).getValue() + "'";
                }
            }}, usages, presentation);
            view.addButtonToLowerPane(() -> {
                DuplicateStringLiteralInspection.introduceConstant(literalExpressions, project);
                view.close();
            }, JavaI18nBundle.message("introduce.constant.across.the.project", new Object[0]));
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("inspection.duplicates.navigate.to.occurrences", new Object[0]);
            if (string == null) {
                NavigateToOccurrencesFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$NavigateToOccurrencesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$NavigateToOccurrencesFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myText;
        private final SmartPsiElementPointer<PsiField> myConst;

        private ReplaceFix(PsiField constant, PsiExpression originalExpression) {
            super((PsiElement)originalExpression);
            this.myText = JavaI18nBundle.message("inspection.duplicates.replace.quickfix", PsiFormatUtil.formatVariable((PsiVariable)constant, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            this.myConst = SmartPointerManager.getInstance((Project)constant.getProject()).createSmartPsiElementPointer((PsiElement)constant);
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ReplaceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                ReplaceFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                ReplaceFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                ReplaceFix.$$$reportNull$$$0(4);
            }
            PsiLiteralExpression myOriginalExpression = (PsiLiteralExpression)startElement;
            PsiField myConstant = (PsiField)this.myConst.getElement();
            if (myConstant == null) {
                return;
            }
            PsiExpression initializer = myConstant.getInitializer();
            if (!(initializer instanceof PsiLiteralExpression)) {
                return;
            }
            try {
                PsiReferenceExpression newReference;
                PsiReferenceExpression reference = DuplicateStringLiteralInspection.createReferenceTo(myConstant);
                if (reference != null && UnnecessarilyQualifiedStaticUsageInspection.isUnnecessarilyQualifiedAccess((PsiJavaCodeReferenceElement)(newReference = (PsiReferenceExpression)myOriginalExpression.replace((PsiElement)reference)), (boolean)false, (boolean)false, (boolean)true)) {
                    newReference.getChildren()[0].delete();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("inspection.duplicates.replace.family.quickfix", new Object[0]);
            if (string == null) {
                ReplaceFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$ReplaceFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class IntroduceLiteralConstantFix
    extends LocalQuickFixOnPsiElement {
        IntroduceLiteralConstantFix(PsiLiteralExpression representative) {
            super((PsiElement)representative);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("introduce.constant.across.the.project", new Object[0]);
            if (string == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiExpression[] literalExpressions;
            if (project == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                IntroduceLiteralConstantFix.$$$reportNull$$$0(5);
            }
            if ((literalExpressions = DuplicateStringLiteralInspection.this.getDuplicateLiteralsUnderProgress(startElement)) == null) {
                return;
            }
            DuplicateStringLiteralInspection.introduceConstant(literalExpressions, project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$IntroduceLiteralConstantFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/duplicateStringLiteral/DuplicateStringLiteralInspection$IntroduceLiteralConstantFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class OptionsPanel {
        private JTextField myMinStringLengthField;
        private JPanel myPanel;
        private JCheckBox myIgnorePropertyKeyExpressions;

        public OptionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JTextField jTextField;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myMinStringLengthField = jTextField = new JTextField();
            jTextField.setColumns(3);
            jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(40, -1), null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaI18nBundle", OptionsPanel.class).getString("inspection.duplicates.option"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myIgnorePropertyKeyExpressions = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaI18nBundle", OptionsPanel.class).getString("inspection.duplicates.option.report.propertykey.expressions"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

