/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.externalAnnotation.NonNlsAnnotationProvider;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.i18n.I18nizeBatchQuickFix;
import com.intellij.codeInspection.i18n.I18nizeConcatenationQuickFix;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.SuppressByCommentOutAction;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.ui.AddDeleteListPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class I18nInspection
extends AbstractBaseUastLocalInspectionTool
implements CustomSuppressableInspectionTool {
    private static final HashSet<String> NON_NLS_NAMES = new HashSet<String>(Arrays.asList("org.jetbrains.annotations.Nls", "org.jetbrains.annotations.NonNls"));
    public boolean ignoreForAssertStatements = true;
    public boolean ignoreForExceptionConstructors = true;
    @NonNls
    public String ignoreForSpecifiedExceptionConstructors = "";
    public boolean ignoreForJUnitAsserts = true;
    public boolean ignoreForClassReferences = true;
    public boolean ignoreForPropertyKeyReferences = true;
    public boolean ignoreForNonAlpha = true;
    private boolean ignoreForAllButNls = false;
    public boolean ignoreAssignedToConstants;
    public boolean ignoreToString;
    @NonNls
    public String nonNlsCommentPattern = "NON-NLS";
    private boolean ignoreForEnumConstants;
    @Nullable
    private Pattern myCachedNonNlsPattern;
    @NonNls
    private static final String TO_STRING = "toString";
    private static final String SKIP_FOR_ENUM = "ignoreForEnumConstant";
    private static final String IGNORE_ALL_BUT_NLS = "ignoreAllButNls";

    public I18nInspection() {
        this.cacheNonNlsCommentPattern();
    }

    public SuppressIntentionAction @NotNull [] getSuppressActions(PsiElement element) {
        Object[] suppressActions = this.getBatchSuppressActions(element);
        if (this.myCachedNonNlsPattern == null) {
            SuppressIntentionAction[] suppressIntentionActionArray = (SuppressIntentionAction[])ContainerUtil.map2Array((Object[])suppressActions, SuppressIntentionAction.class, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction);
            if (suppressIntentionActionArray == null) {
                I18nInspection.$$$reportNull$$$0(0);
            }
            return suppressIntentionActionArray;
        }
        ArrayList<SuppressByCommentOutAction> suppressors = new ArrayList<SuppressByCommentOutAction>(suppressActions.length + 1);
        suppressors.add(new SuppressByCommentOutAction(this.nonNlsCommentPattern));
        suppressors.addAll(ContainerUtil.map((Object[])suppressActions, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction));
        SuppressIntentionAction[] suppressIntentionActionArray = suppressors.toArray(SuppressIntentionAction.EMPTY_ARRAY);
        if (suppressIntentionActionArray == null) {
            I18nInspection.$$$reportNull$$$0(1);
        }
        return suppressIntentionActionArray;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            I18nInspection.$$$reportNull$$$0(2);
        }
        super.writeSettings(node);
        if (this.ignoreForEnumConstants) {
            node.addContent(new Element("option").setAttribute("name", SKIP_FOR_ENUM).setAttribute("value", Boolean.toString(this.ignoreForEnumConstants)));
        }
        if (this.ignoreForAllButNls) {
            node.addContent(new Element("option").setAttribute("name", IGNORE_ALL_BUT_NLS).setAttribute("value", Boolean.toString(this.ignoreForAllButNls)));
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            I18nInspection.$$$reportNull$$$0(3);
        }
        super.readSettings(node);
        for (Element o : node.getChildren()) {
            String nameAttr = o.getAttributeValue("name");
            String valueAttr = o.getAttributeValue("value");
            if (Comparing.strEqual((String)nameAttr, (String)SKIP_FOR_ENUM)) {
                if (valueAttr == null) continue;
                this.ignoreForEnumConstants = Boolean.parseBoolean(valueAttr);
                continue;
            }
            if (!Comparing.strEqual((String)nameAttr, (String)IGNORE_ALL_BUT_NLS) || valueAttr == null) continue;
            this.ignoreForAllButNls = Boolean.parseBoolean(valueAttr);
        }
        this.cacheNonNlsCommentPattern();
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.internationalization.issues", (Object[])new Object[0]);
        if (string == null) {
            I18nInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "HardCodedStringLiteral";
    }

    public boolean setIgnoreForEnumConstants(boolean ignoreForEnumConstants) {
        boolean old = this.ignoreForEnumConstants;
        this.ignoreForEnumConstants = ignoreForEnumConstants;
        return old;
    }

    public boolean setIgnoreForAllButNls(boolean ignoreForAllButNls) {
        boolean old = this.ignoreForAllButNls;
        this.ignoreForAllButNls = ignoreForAllButNls;
        return old;
    }

    public JComponent createOptionsPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        final JCheckBox assertStatementsCheckbox = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.assert", new Object[0]), this.ignoreForAssertStatements);
        assertStatementsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForAssertStatements = assertStatementsCheckbox.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$1", "stateChanged"));
            }
        });
        final JCheckBox exceptionConstructorCheck = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.for.exception.constructor.arguments", new Object[0]), this.ignoreForExceptionConstructors);
        exceptionConstructorCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForExceptionConstructors = exceptionConstructorCheck.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$2", "stateChanged"));
            }
        });
        final JTextField specifiedExceptions = new JTextField(this.ignoreForSpecifiedExceptionConstructors);
        specifiedExceptions.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForSpecifiedExceptionConstructors = specifiedExceptions.getText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$3", "textChanged"));
            }
        });
        final JCheckBox junitAssertCheckbox = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.for.junit.assert.arguments", new Object[0]), this.ignoreForJUnitAsserts);
        junitAssertCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForJUnitAsserts = junitAssertCheckbox.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$4", "stateChanged"));
            }
        });
        final JCheckBox classRef = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.qualified.class.names", new Object[0]), this.ignoreForClassReferences);
        classRef.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForClassReferences = classRef.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$5", "stateChanged"));
            }
        });
        final JCheckBox propertyRef = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.property.keys", new Object[0]), this.ignoreForPropertyKeyReferences);
        propertyRef.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForPropertyKeyReferences = propertyRef.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$6", "stateChanged"));
            }
        });
        final JCheckBox nonAlpha = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.nonalphanumerics", new Object[0]), this.ignoreForNonAlpha);
        nonAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForNonAlpha = nonAlpha.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$7", "stateChanged"));
            }
        });
        final JCheckBox assignedToConstants = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.assigned.to.constants", new Object[0]), this.ignoreAssignedToConstants);
        assignedToConstants.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreAssignedToConstants = assignedToConstants.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$8", "stateChanged"));
            }
        });
        final JCheckBox chkToString = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.tostring", new Object[0]), this.ignoreToString);
        chkToString.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreToString = chkToString.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$9", "stateChanged"));
            }
        });
        final JCheckBox ignoreEnumConstants = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.enum", new Object[0]), this.ignoreForEnumConstants);
        ignoreEnumConstants.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForEnumConstants = ignoreEnumConstants.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$10", "stateChanged"));
            }
        });
        final JCheckBox ignoreAllButNls = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.nls", new Object[0]), this.ignoreForAllButNls);
        ignoreAllButNls.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForAllButNls = ignoreAllButNls.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$11", "stateChanged"));
            }
        });
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets.bottom = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        panel.add((Component)ignoreAllButNls, gc);
        ++gc.gridy;
        panel.add((Component)assertStatementsCheckbox, gc);
        ++gc.gridy;
        panel.add((Component)junitAssertCheckbox, gc);
        ++gc.gridy;
        panel.add((Component)exceptionConstructorCheck, gc);
        ++gc.gridy;
        final Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        panel.add((Component)new FieldPanel(specifiedExceptions, null, JavaI18nBundle.message("inspection.i18n.option.ignore.for.specified.exception.constructor.arguments", new Object[0]), openProjects.length == 0 ? null : new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                I18nInspection.this.createIgnoreExceptionsConfigurationDialog(openProjects[0], specifiedExceptions).show();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$12", "actionPerformed"));
            }
        }, null), gc);
        ++gc.gridy;
        panel.add((Component)classRef, gc);
        ++gc.gridy;
        panel.add((Component)propertyRef, gc);
        ++gc.gridy;
        panel.add((Component)assignedToConstants, gc);
        ++gc.gridy;
        panel.add((Component)chkToString, gc);
        ++gc.gridy;
        panel.add((Component)nonAlpha, gc);
        ++gc.gridy;
        panel.add((Component)ignoreEnumConstants, gc);
        ++gc.gridy;
        gc.anchor = 18;
        gc.weighty = 1.0;
        JTextField text = new JTextField(this.nonNlsCommentPattern);
        FieldPanel nonNlsCommentPatternComponent = new FieldPanel(text, JavaI18nBundle.message("inspection.i18n.option.ignore.comment.pattern", new Object[0]), JavaI18nBundle.message("inspection.i18n.option.ignore.comment.title", new Object[0]), null, () -> {
            this.nonNlsCommentPattern = text.getText();
            this.cacheNonNlsCommentPattern();
        });
        panel.add((Component)nonNlsCommentPatternComponent, gc);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(null);
        scrollPane.setPreferredSize(new Dimension(panel.getPreferredSize().width + scrollPane.getVerticalScrollBar().getPreferredSize().width, panel.getPreferredSize().height + scrollPane.getHorizontalScrollBar().getPreferredSize().height));
        return scrollPane;
    }

    private DialogWrapper createIgnoreExceptionsConfigurationDialog(final Project project, final JTextField specifiedExceptions) {
        return new DialogWrapper(true){
            private AddDeleteListPanel myPanel;
            {
                super(x0);
                this.setTitle(JavaI18nBundle.message("inspection.i18n.option.ignore.for.specified.exception.constructor.arguments", new Object[0]));
                this.init();
            }

            protected JComponent createCenterPanel() {
                String[] ignored = I18nInspection.this.ignoreForSpecifiedExceptionConstructors.split(",");
                ArrayList<String> initialList = new ArrayList<String>();
                for (String e : ignored) {
                    if (e.isEmpty()) continue;
                    initialList.add(e);
                }
                this.myPanel = new AddDeleteListPanel<String>(null, initialList){

                    protected String findItemToAdd() {
                        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                        TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createInheritanceClassChooser(JavaI18nBundle.message("inspection.i18n.option.ignore.for.specified.exception.constructor.arguments", new Object[0]), scope, JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Throwable", scope), true, true, null);
                        chooser.showDialog();
                        PsiClass selectedClass = chooser.getSelected();
                        return selectedClass != null ? selectedClass.getQualifiedName() : null;
                    }
                };
                return this.myPanel;
            }

            protected void doOKAction() {
                Object[] exceptions;
                StringBuilder buf = new StringBuilder();
                for (Object exception : exceptions = this.myPanel.getListItems()) {
                    buf.append(",").append(exception);
                }
                specifiedExceptions.setText(buf.length() > 0 ? buf.substring(1) : buf.toString());
                super.doOKAction();
            }
        };
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Object[] descriptors;
        if (method == null) {
            I18nInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(6);
        }
        if (I18nInspection.isClassNonNls((UDeclaration)method)) {
            return null;
        }
        ArrayList results = new ArrayList();
        UExpression body = method.getUastBody();
        if (body != null && (descriptors = this.checkElement((UElement)body, manager, isOnTheFly)) != null) {
            ContainerUtil.addAll(results, (Object[])descriptors);
        }
        this.checkAnnotations((UDeclaration)method, manager, isOnTheFly, results);
        for (UParameter parameter : method.getUastParameters()) {
            this.checkAnnotations((UDeclaration)parameter, manager, isOnTheFly, results);
        }
        return results.isEmpty() ? null : results.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            I18nInspection.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(8);
        }
        if (I18nInspection.isClassNonNls((UDeclaration)aClass)) {
            return null;
        }
        UClassInitializer[] initializers = aClass.getInitializers();
        ArrayList result = new ArrayList();
        for (UClassInitializer initializer : initializers) {
            Object[] descriptors = this.checkElement((UElement)initializer.getUastBody(), manager, isOnTheFly);
            if (descriptors == null) continue;
            ContainerUtil.addAll(result, (Object[])descriptors);
        }
        this.checkAnnotations((UDeclaration)aClass, manager, isOnTheFly, result);
        return result.isEmpty() ? null : result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void checkAnnotations(UDeclaration member, @NotNull InspectionManager manager, boolean isOnTheFly, List<? super ProblemDescriptor> result) {
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(9);
        }
        for (UAnnotation annotation : member.getUAnnotations()) {
            Object[] descriptors = this.checkElement((UElement)annotation, manager, isOnTheFly);
            if (descriptors == null) continue;
            ContainerUtil.addAll(result, (Object[])descriptors);
        }
    }

    public ProblemDescriptor @Nullable [] checkField(@NotNull UField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            I18nInspection.$$$reportNull$$$0(10);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(11);
        }
        if (I18nInspection.isClassNonNls((UDeclaration)field)) {
            return null;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)field.getJavaPsi()), (String)"org.jetbrains.annotations.NonNls", (int)2)) {
            return null;
        }
        ArrayList result = new ArrayList();
        UExpression initializer = field.getUastInitializer();
        if (initializer != null) {
            Object[] descriptors = this.checkElement((UElement)initializer, manager, isOnTheFly);
            if (descriptors != null) {
                ContainerUtil.addAll(result, (Object[])descriptors);
            }
        } else if (field instanceof UEnumConstant) {
            List arguments = ((UEnumConstant)field).getValueArguments();
            for (UExpression argument : arguments) {
                Object[] descriptors = this.checkElement((UElement)argument, manager, isOnTheFly);
                if (descriptors == null) continue;
                ContainerUtil.addAll(result, (Object[])descriptors);
            }
        }
        this.checkAnnotations((UDeclaration)field, manager, isOnTheFly, result);
        return result.isEmpty() ? null : result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    public String getAlternativeID() {
        return "nls";
    }

    private ProblemDescriptor[] checkElement(@NotNull UElement element, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (element == null) {
            I18nInspection.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(13);
        }
        StringI18nVisitor visitor = new StringI18nVisitor(manager, isOnTheFly);
        element.accept((UastVisitor)visitor);
        List problems = visitor.getProblems();
        return problems.isEmpty() ? null : problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    private static LocalQuickFix createIntroduceConstantFix() {
        return new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                String string = IntroduceConstantHandler.getRefactoringNameText();
                if (string == null) {
                    14.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement element;
                if (project == null) {
                    14.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    14.$$$reportNull$$$0(2);
                }
                if (!((element = descriptor.getPsiElement()) instanceof PsiExpression)) {
                    return;
                }
                PsiExpression[] expressions = new PsiExpression[]{(PsiExpression)element};
                new IntroduceConstantHandler().invoke(project, expressions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/i18n/I18nInspection$14";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/i18n/I18nInspection$14";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private boolean canBeI18ned(@NotNull Project project, @NotNull ULiteralExpression expression, @NotNull String value, @NotNull Set<? super PsiModifierListOwner> nonNlsTargets) {
        if (project == null) {
            I18nInspection.$$$reportNull$$$0(14);
        }
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(15);
        }
        if (value == null) {
            I18nInspection.$$$reportNull$$$0(16);
        }
        if (nonNlsTargets == null) {
            I18nInspection.$$$reportNull$$$0(17);
        }
        if (this.ignoreForNonAlpha && !StringUtil.containsAlphaCharacters((String)value)) {
            return false;
        }
        if (this.ignoreForAllButNls) {
            return JavaI18nUtil.isPassedToAnnotatedParam((UExpression)expression, "org.jetbrains.annotations.Nls", null) || I18nInspection.isReturnedFromAnnotatedMethod(expression, "org.jetbrains.annotations.Nls", null);
        }
        if (JavaI18nUtil.isPassedToAnnotatedParam((UExpression)expression, "org.jetbrains.annotations.NonNls", nonNlsTargets)) {
            return false;
        }
        if (I18nInspection.isInNonNlsCall((UExpression)expression, nonNlsTargets)) {
            return false;
        }
        if (I18nInspection.isInNonNlsEquals(expression, nonNlsTargets)) {
            return false;
        }
        if (this.isPassedToNonNlsVariable(expression, nonNlsTargets)) {
            return false;
        }
        if (JavaI18nUtil.mustBePropertyKey((UExpression)expression, null)) {
            return false;
        }
        if (I18nInspection.isReturnedFromAnnotatedMethod(expression, "org.jetbrains.annotations.NonNls", nonNlsTargets)) {
            return false;
        }
        if (this.ignoreForAssertStatements && I18nInspection.isArgOfAssertStatement((UExpression)expression)) {
            return false;
        }
        if (this.ignoreForExceptionConstructors && I18nInspection.isExceptionArgument((UExpression)expression)) {
            return false;
        }
        if (this.ignoreForEnumConstants && I18nInspection.isArgOfEnumConstant(expression)) {
            return false;
        }
        if (!this.ignoreForExceptionConstructors && I18nInspection.isArgOfSpecifiedExceptionConstructor(expression, this.ignoreForSpecifiedExceptionConstructors.split(","))) {
            return false;
        }
        if (this.ignoreForJUnitAsserts && I18nInspection.isArgOfJUnitAssertion(expression)) {
            return false;
        }
        if (this.ignoreForClassReferences && I18nInspection.isClassRef(expression, value)) {
            return false;
        }
        if (this.ignoreForPropertyKeyReferences && !PropertiesImplUtil.findPropertiesByKey((Project)project, (String)value).isEmpty()) {
            return false;
        }
        if (this.ignoreToString && I18nInspection.isToString(expression)) {
            return false;
        }
        Pattern pattern = this.myCachedNonNlsPattern;
        if (pattern != null) {
            PsiFile file = expression.getSourcePsi().getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            int line = document.getLineNumber(expression.getSourcePsi().getTextRange().getStartOffset());
            int lineStartOffset = document.getLineStartOffset(line);
            CharSequence lineText = document.getCharsSequence().subSequence(lineStartOffset, document.getLineEndOffset(line));
            Matcher matcher = pattern.matcher(lineText);
            int start = 0;
            while (matcher.find(start)) {
                start = matcher.start();
                PsiElement element = file.findElementAt(lineStartOffset + start);
                if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                    return false;
                }
                if (start == lineText.length() - 1) break;
                ++start;
            }
        }
        return true;
    }

    private static boolean isArgOfEnumConstant(ULiteralExpression expression) {
        return expression.getUastParent() instanceof UEnumConstant;
    }

    public void cacheNonNlsCommentPattern() {
        this.myCachedNonNlsPattern = this.nonNlsCommentPattern.trim().isEmpty() ? null : Pattern.compile(this.nonNlsCommentPattern);
    }

    private static boolean isClassRef(ULiteralExpression expression, String value) {
        Project project;
        if (StringUtil.startsWithChar((CharSequence)value, (char)'#')) {
            value = value.substring(1);
        }
        return JavaPsiFacade.getInstance((Project)(project = Objects.requireNonNull(expression.getSourcePsi()).getProject())).findClass(value, GlobalSearchScope.allScope((Project)project)) != null;
    }

    private static boolean isClassNonNls(@NotNull UDeclaration clazz) {
        UFile uFile;
        if (clazz == null) {
            I18nInspection.$$$reportNull$$$0(18);
        }
        if ((uFile = UastUtils.getContainingUFile((UElement)clazz)) == null) {
            return false;
        }
        PsiDirectory directory = uFile.getSourcePsi().getContainingDirectory();
        return directory != null && I18nInspection.isPackageNonNls(JavaDirectoryService.getInstance().getPackage(directory));
    }

    public static boolean isPackageNonNls(PsiPackage psiPackage) {
        if (psiPackage == null || psiPackage.getName() == null) {
            return false;
        }
        PsiModifierList pkgModifierList = psiPackage.getAnnotationList();
        return pkgModifierList != null && pkgModifierList.hasAnnotation("org.jetbrains.annotations.NonNls") || I18nInspection.isPackageNonNls(psiPackage.getParentPackage());
    }

    private boolean isPassedToNonNlsVariable(@NotNull ULiteralExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(19);
        }
        UExpression toplevel = JavaI18nUtil.getTopLevelExpression((UExpression)expression);
        PsiVariable var = null;
        if (UastExpressionUtils.isAssignment((UElement)toplevel)) {
            PsiElement resolved;
            UExpression lExpression = ((UBinaryExpression)toplevel).getLeftOperand();
            while (lExpression instanceof UArrayAccessExpression) {
                lExpression = ((UArrayAccessExpression)lExpression).getReceiver();
            }
            if (lExpression instanceof UResolvable && (resolved = ((UResolvable)lExpression).resolve()) instanceof PsiVariable) {
                var = (PsiVariable)resolved;
            }
        }
        if (var == null) {
            UElement caseParent;
            PsiElement resolved;
            UExpression switchExpression;
            UElement parent = toplevel.getUastParent();
            if (parent instanceof UVariable && toplevel.equals(((UVariable)parent).getUastInitializer())) {
                if (((UVariable)parent).findAnnotation("org.jetbrains.annotations.NonNls") != null) {
                    return true;
                }
                PsiElement psi = parent.getSourcePsi();
                if (psi instanceof PsiModifierListOwner) {
                    var = (PsiModifierListOwner)psi;
                }
            } else if (toplevel instanceof USwitchExpression && (switchExpression = ((USwitchExpression)toplevel).getExpression()) instanceof UResolvable && (resolved = ((UResolvable)switchExpression).resolve()) instanceof PsiVariable && (caseParent = expression.getUastParent()) instanceof USwitchClauseExpression && ((USwitchClauseExpression)caseParent).getCaseValues().contains(expression)) {
                var = (PsiVariable)resolved;
            }
        }
        if (var != null) {
            if (I18nInspection.annotatedAsNonNls(var)) {
                return true;
            }
            if (this.ignoreAssignedToConstants && var.hasModifierProperty("static") && var.hasModifierProperty("final")) {
                return true;
            }
            nonNlsTargets.add((PsiModifierListOwner)var);
        }
        return false;
    }

    private static boolean annotatedAsNonNls(PsiModifierListOwner parent) {
        PsiParameter parameter;
        PsiElement declarationScope;
        if (parent instanceof PsiParameter && (declarationScope = (parameter = (PsiParameter)parent).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)declarationScope;
            int index = method.getParameterList().getParameterIndex(parameter);
            return JavaI18nUtil.isMethodParameterAnnotatedWith(method, index, null, "org.jetbrains.annotations.NonNls", null, null);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)parent, (String)"org.jetbrains.annotations.NonNls", (int)2);
    }

    private static boolean isInNonNlsEquals(ULiteralExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        PsiElement resolvedEntity;
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
        if (!(parent instanceof UQualifiedReferenceExpression)) {
            return false;
        }
        UExpression selector = ((UQualifiedReferenceExpression)parent).getSelector();
        if (!(selector instanceof UCallExpression)) {
            return false;
        }
        UCallExpression call = (UCallExpression)selector;
        if (!"equals".equals(call.getMethodName()) || !MethodUtils.isEquals((PsiMethod)call.resolve())) {
            return false;
        }
        List expressions = call.getValueArguments();
        if (expressions.size() != 1) {
            return false;
        }
        UExpression arg = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)expressions.get(0)));
        UResolvable ref = (UResolvable)ObjectUtils.tryCast((Object)arg, UResolvable.class);
        if (ref != null && (resolvedEntity = ref.resolve()) instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)resolvedEntity;
            if (I18nInspection.annotatedAsNonNls(modifierListOwner)) {
                return true;
            }
            nonNlsTargets.add((PsiModifierListOwner)modifierListOwner);
        }
        return false;
    }

    private static boolean isInNonNlsCall(@NotNull UExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        UElement parentOfNew;
        UExpression parent;
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(20);
        }
        if ((parent = UastUtils.skipParenthesizedExprDown((UExpression)JavaI18nUtil.getTopLevelExpression(expression))) instanceof UQualifiedReferenceExpression) {
            return I18nInspection.isNonNlsCall((UReferenceExpression)((UQualifiedReferenceExpression)parent), nonNlsTargets);
        }
        if (parent != null && UastExpressionUtils.isAssignment((UElement)parent)) {
            UExpression operand = ((UBinaryExpression)parent).getLeftOperand();
            if (operand instanceof UReferenceExpression && I18nInspection.isNonNlsCall((UReferenceExpression)operand, nonNlsTargets)) {
                return true;
            }
        } else if (parent instanceof UCallExpression && (parentOfNew = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent())) instanceof ULocalVariable) {
            ULocalVariable newVariable = (ULocalVariable)parentOfNew;
            if (I18nInspection.annotatedAsNonNls((PsiModifierListOwner)newVariable.getPsi())) {
                return true;
            }
            PsiElement variableJavaPsi = newVariable.getJavaPsi();
            if (variableJavaPsi instanceof PsiModifierListOwner) {
                nonNlsTargets.add((PsiModifierListOwner)((PsiModifierListOwner)variableJavaPsi));
            }
            return false;
        }
        return false;
    }

    private static boolean isNonNlsCall(UReferenceExpression qualifier, Set<? super PsiModifierListOwner> nonNlsTargets) {
        UExpression receiver;
        PsiElement resolved = qualifier.resolve();
        if (resolved instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)resolved;
            if (I18nInspection.annotatedAsNonNls(modifierListOwner)) {
                return true;
            }
            nonNlsTargets.add((PsiModifierListOwner)modifierListOwner);
        }
        if (qualifier instanceof UQualifiedReferenceExpression && (receiver = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)qualifier).getReceiver())) instanceof UReferenceExpression) {
            return I18nInspection.isNonNlsCall((UReferenceExpression)receiver, nonNlsTargets);
        }
        return false;
    }

    private static boolean isReturnedFromAnnotatedMethod(ULiteralExpression expression, String fqn, @Nullable Set<? super PsiModifierListOwner> nonNlsTargets) {
        PsiAnnotation typeAnnotation;
        PsiMethod method;
        PsiType returnType = null;
        UNamedExpression nameValuePair = (UNamedExpression)UastUtils.getParentOfType((UElement)expression, UNamedExpression.class);
        if (nameValuePair != null) {
            method = UastUtils.getAnnotationMethod((UNamedExpression)nameValuePair);
        } else {
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
            while (parent instanceof UCallExpression && ((UCallExpression)parent).getKind() == UastCallKind.NEW_ARRAY_WITH_INITIALIZER) {
                parent = parent.getUastParent();
            }
            if (parent == null) {
                return false;
            }
            UElement returnStmt = UastUtils.getParentOfType((UElement)parent, UReturnExpression.class, (boolean)false, (Class[])new Class[]{UCallExpression.class, ULambdaExpression.class});
            if (!(returnStmt instanceof UReturnExpression)) {
                return false;
            }
            UElement jumpTarget = ((UReturnExpression)returnStmt).getJumpTarget();
            if (jumpTarget instanceof UMethod) {
                method = ((UMethod)jumpTarget).getJavaPsi();
            } else if (jumpTarget instanceof ULambdaExpression) {
                PsiType type = ((ULambdaExpression)jumpTarget).getFunctionalInterfaceType();
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type);
                if (type == null) {
                    return false;
                }
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
            } else {
                return false;
            }
        }
        if (method == null) {
            return false;
        }
        String oppositeFQN = fqn.equals("org.jetbrains.annotations.Nls") ? "org.jetbrains.annotations.NonNls" : "org.jetbrains.annotations.Nls";
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, NON_NLS_NAMES);
        if (annotation != null && annotation.hasQualifiedName(oppositeFQN)) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)fqn, (int)3)) {
            return true;
        }
        if (returnType != null && (typeAnnotation = AnnotationUtil.findAnnotationInTypeHierarchy(returnType, NON_NLS_NAMES)) != null) {
            return typeAnnotation.hasQualifiedName(fqn);
        }
        if (nonNlsTargets != null) {
            nonNlsTargets.add((PsiModifierListOwner)method);
        }
        return false;
    }

    private static boolean isToString(ULiteralExpression expression) {
        UMethod method = (UMethod)UastUtils.getParentOfType((UElement)expression, UMethod.class);
        if (method == null) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        return TO_STRING.equals(method.getName()) && method.getUastParameters().isEmpty() && returnType != null && "java.lang.String".equals(returnType.getCanonicalText());
    }

    private static boolean isArgOfJUnitAssertion(ULiteralExpression expression) {
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
        if (parent == null || !UastExpressionUtils.isMethodCall((UElement)parent)) {
            return false;
        }
        String methodName = ((UCallExpression)parent).getMethodName();
        if (methodName == null) {
            return false;
        }
        if (!methodName.startsWith("assert") && !methodName.equals("fail")) {
            return false;
        }
        PsiMethod method = ((UCallExpression)parent).resolve();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.junit.Assert") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.junit.jupiter.api.Assertions") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.Assert");
    }

    private static boolean isArgOfSpecifiedExceptionConstructor(ULiteralExpression expression, String[] specifiedExceptions) {
        PsiClass aClass;
        if (specifiedExceptions.length == 0) {
            return false;
        }
        UCallExpression parent = (UCallExpression)UastUtils.getParentOfType((UElement)expression, UCallExpression.class, (boolean)true, (Class[])new Class[]{UClass.class});
        if (parent == null || !UastExpressionUtils.isConstructorCall((UElement)parent)) {
            return false;
        }
        PsiMethod resolved = parent.resolve();
        PsiClass psiClass = aClass = resolved != null ? resolved.getContainingClass() : null;
        if (aClass == null) {
            return false;
        }
        return ArrayUtil.contains((String)aClass.getQualifiedName(), (String[])specifiedExceptions);
    }

    private static boolean isArgOfAssertStatement(UExpression expression) {
        UCallExpression parent = (UCallExpression)UastUtils.getParentOfType((UElement)expression, UCallExpression.class);
        return parent != null && "assert".equals(parent.getMethodName());
    }

    public static boolean isExceptionArgument(@NotNull UExpression expression) {
        UCallExpression newExpression;
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(21);
        }
        if ((newExpression = (UCallExpression)UastUtils.getParentOfType((UElement)expression, UCallExpression.class, (boolean)true, (Class[])new Class[]{UBlockExpression.class, UClass.class})) != null) {
            String methodName;
            if (UastExpressionUtils.isConstructorCall((UElement)newExpression)) {
                PsiType newExpressionType = newExpression.getExpressionType();
                return InheritanceUtil.isInheritor((PsiType)newExpressionType, (String)"java.lang.Throwable");
            }
            if (UastExpressionUtils.isMethodCall((UElement)newExpression) && ("super".equals(methodName = newExpression.getMethodName()) || "this".equals(methodName))) {
                PsiMethod ctor = newExpression.resolve();
                return ctor != null && InheritanceUtil.isInheritor((PsiClass)ctor.getContainingClass(), (String)"java.lang.Throwable");
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/I18nInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonNlsTargets";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/I18nInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canBeI18ned";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isClassNonNls";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isPassedToNonNlsVariable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInNonNlsCall";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isExceptionArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StringI18nVisitor
    extends AbstractUastVisitor {
        private final List<ProblemDescriptor> myProblems;
        private final InspectionManager myManager;
        private final boolean myOnTheFly;

        private StringI18nVisitor(InspectionManager manager, boolean onTheFly) {
            if (manager == null) {
                StringI18nVisitor.$$$reportNull$$$0(0);
            }
            this.myProblems = new ArrayList<ProblemDescriptor>();
            this.myManager = manager;
            this.myOnTheFly = onTheFly;
        }

        public boolean visitObjectLiteralExpression(@NotNull UObjectLiteralExpression objectLiteralExpression) {
            if (objectLiteralExpression == null) {
                StringI18nVisitor.$$$reportNull$$$0(1);
            }
            for (UExpression argument : objectLiteralExpression.getValueArguments()) {
                argument.accept((UastVisitor)this);
            }
            return true;
        }

        public boolean visitClass(@NotNull UClass node) {
            if (node == null) {
                StringI18nVisitor.$$$reportNull$$$0(2);
            }
            return false;
        }

        public boolean visitField(@NotNull UField node) {
            if (node == null) {
                StringI18nVisitor.$$$reportNull$$$0(3);
            }
            return false;
        }

        public boolean visitMethod(@NotNull UMethod node) {
            if (node == null) {
                StringI18nVisitor.$$$reportNull$$$0(4);
            }
            return false;
        }

        public boolean visitInitializer(@NotNull UClassInitializer node) {
            if (node == null) {
                StringI18nVisitor.$$$reportNull$$$0(5);
            }
            return false;
        }

        public boolean visitLiteralExpression(@NotNull ULiteralExpression expression) {
            Object value;
            if (expression == null) {
                StringI18nVisitor.$$$reportNull$$$0(6);
            }
            if (!((value = expression.getValue()) instanceof String)) {
                return false;
            }
            String stringValue = (String)value;
            if (stringValue.trim().isEmpty()) {
                return false;
            }
            THashSet nonNlsTargets = new THashSet();
            if (I18nInspection.this.canBeI18ned(this.myManager.getProject(), expression, stringValue, (Set)nonNlsTargets)) {
                UField parentField = (UField)UastUtils.getParentOfType((UElement)expression, UField.class);
                if (parentField != null) {
                    nonNlsTargets.add((PsiModifierListOwner)parentField.getJavaPsi());
                }
                String description = JavaI18nBundle.message("inspection.i18n.message.general.with.value", "#ref");
                PsiElement sourcePsi = expression.getSourcePsi();
                ArrayList<Object> fixes = new ArrayList<Object>();
                if (this.myOnTheFly) {
                    if (sourcePsi instanceof PsiLiteralExpression) {
                        if (I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(sourcePsi) != null) {
                            fixes.add(new I18nizeConcatenationQuickFix());
                        }
                        fixes.add(new I18nizeQuickFix());
                        if (!this.isNotConstantFieldInitializer((PsiExpression)sourcePsi)) {
                            fixes.add(I18nInspection.createIntroduceConstantFix());
                        }
                        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)sourcePsi)) {
                            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myManager.getProject());
                            for (PsiModifierListOwner element : nonNlsTargets) {
                                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)element, (String)"org.jetbrains.annotations.Nls", (int)3) || element.getManager().isInProject((PsiElement)element) && facade.findClass("org.jetbrains.annotations.NonNls", element.getResolveScope()) == null) continue;
                                fixes.add(new NonNlsAnnotationProvider().createFix(element));
                            }
                        }
                    }
                } else if (Registry.is((String)"i18n.for.idea.project")) {
                    fixes.add(new I18nizeBatchQuickFix());
                }
                LocalQuickFix[] farr = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
                ProblemDescriptor problem = this.myManager.createProblemDescriptor(sourcePsi, description, this.myOnTheFly, farr, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                this.myProblems.add(problem);
            }
            return false;
        }

        private boolean isNotConstantFieldInitializer(PsiExpression expression) {
            PsiField parentField = expression.getParent() instanceof PsiField ? (PsiField)expression.getParent() : null;
            return parentField != null && expression == parentField.getInitializer() && parentField.hasModifierProperty("final") && parentField.hasModifierProperty("static");
        }

        public boolean visitAnnotation(UAnnotation annotation) {
            if ("java.lang.SuppressWarnings".equals(annotation.getQualifiedName())) {
                return true;
            }
            return super.visitAnnotation(annotation);
        }

        private List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectLiteralExpression";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/i18n/I18nInspection$StringI18nVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitObjectLiteralExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInitializer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

