/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.firefox;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.firefox.FirefoxProfile;
import com.intellij.ide.browsers.firefox.FirefoxSettings;
import com.intellij.ide.browsers.firefox.FirefoxUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirefoxSettingsConfigurable
implements Configurable {
    private static final FileChooserDescriptor PROFILES_INI_CHOOSER_DESCRIPTOR = FirefoxSettingsConfigurable.createProfilesIniChooserDescriptor();
    private JPanel myMainPanel;
    private JComboBox myProfileCombobox;
    private TextFieldWithBrowseButton myProfilesIniPathField;
    private final FirefoxSettings mySettings;
    private String myLastProfilesIniPath;
    private String myDefaultProfilesIniPath;
    private String defaultProfile;

    public FirefoxSettingsConfigurable(FirefoxSettings settings) {
        this.mySettings = settings;
        this.$$$setupUI$$$();
        this.myProfilesIniPathField.addBrowseFolderListener(IdeBundle.message("chooser.title.select.profiles.ini.file", new Object[0]), null, null, PROFILES_INI_CHOOSER_DESCRIPTOR);
        this.myProfilesIniPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FirefoxSettingsConfigurable.this.updateProfilesList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/browsers/firefox/FirefoxSettingsConfigurable$1", "textChanged"));
            }
        });
    }

    public static FileChooserDescriptor createProfilesIniChooserDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, false){

            @Override
            public boolean isFileSelectable(VirtualFile file) {
                return file.getName().equals("profiles.ini") && super.isFileSelectable(file);
            }
        }.withShowHiddenFiles(SystemInfo.isUnix);
    }

    @Override
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    @Override
    public boolean isModified() {
        return !Comparing.equal((String)this.mySettings.getProfile(), (String)this.getConfiguredProfileName()) || !Comparing.equal((String)this.mySettings.getProfilesIniPath(), (String)this.getConfiguredProfileIniPath());
    }

    @Nullable
    private String getConfiguredProfileIniPath() {
        String path2 = PathUtil.toSystemIndependentName(StringUtil.nullize((String)this.myProfilesIniPathField.getText()));
        return this.myDefaultProfilesIniPath.equals(path2) ? null : path2;
    }

    @Nullable
    private String getConfiguredProfileName() {
        String selected = (String)this.myProfileCombobox.getSelectedItem();
        return Comparing.equal((String)this.defaultProfile, (String)selected) ? null : selected;
    }

    @Override
    public void apply() throws ConfigurationException {
        this.mySettings.setProfile(this.getConfiguredProfileName());
        this.mySettings.setProfilesIniPath(this.getConfiguredProfileIniPath());
    }

    @Override
    public void reset() {
        File defaultFile = FirefoxUtil.getDefaultProfileIniPath();
        this.myDefaultProfilesIniPath = defaultFile != null ? defaultFile.getAbsolutePath() : "";
        String path2 = this.mySettings.getProfilesIniPath();
        this.myProfilesIniPathField.setText(path2 != null ? FileUtilRt.toSystemDependentName((String)path2) : this.myDefaultProfilesIniPath);
        this.updateProfilesList();
        String profile = this.mySettings.getProfile();
        this.myProfileCombobox.setSelectedItem(profile == null ? this.defaultProfile : profile);
    }

    private void updateProfilesList() {
        String profilesIniPath = this.myProfilesIniPathField.getText();
        if (this.myLastProfilesIniPath != null && this.myLastProfilesIniPath.equals(profilesIniPath)) {
            return;
        }
        this.myProfileCombobox.removeAllItems();
        List<FirefoxProfile> profiles = FirefoxUtil.computeProfiles(new File(profilesIniPath));
        FirefoxProfile defaultProfile = FirefoxUtil.getDefaultProfile(profiles);
        this.defaultProfile = defaultProfile != null ? defaultProfile.getName() : null;
        for (FirefoxProfile profile : profiles) {
            this.myProfileCombobox.addItem(profile.getName());
        }
        if (!profiles.isEmpty()) {
            this.myProfileCombobox.setSelectedIndex(0);
        }
        this.myLastProfilesIniPath = profilesIniPath;
    }

    @Override
    @Nls
    public String getDisplayName() {
        return IdeBundle.message("display.name.firefox.settings", new Object[0]);
    }

    @Override
    @Nullable
    public String getHelpTopic() {
        return "reference.settings.ide.settings.web.browsers.edit";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle("messages/IdeBundle", FirefoxSettingsConfigurable.class).getString("label.text.path.to.profiles.ini"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProfilesIniPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null, 2));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle("messages/IdeBundle", FirefoxSettingsConfigurable.class).getString("label.text.profile"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myProfileCombobox = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

