/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class UserFileType<T extends UserFileType>
implements FileType,
Cloneable {
    @NotNull
    private String myName = "";
    private String myDescription = "";
    private Icon myIcon;
    private String myIconPath;

    public abstract SettingsEditor<T> getEditor();

    public UserFileType clone() {
        try {
            return (UserFileType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            UserFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            UserFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            UserFileType.$$$reportNull$$$0(2);
        }
        this.myName = name;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @Override
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            if (this.myIconPath != null) {
                this.myIcon = icon = IconLoader.getIcon((String)this.myIconPath);
            }
            if (icon == null) {
                icon = PlatformIcons.CUSTOM_FILE_ICON;
            }
        }
        return icon;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            UserFileType.$$$reportNull$$$0(3);
        }
        if (content == null) {
            UserFileType.$$$reportNull$$$0(4);
        }
        return null;
    }

    public void copyFrom(@NotNull UserFileType newType) {
        if (newType == null) {
            UserFileType.$$$reportNull$$$0(5);
        }
        this.myName = newType.getName();
        this.myDescription = newType.getDescription();
    }

    public void setIcon(@NotNull Icon icon) {
        if (icon == null) {
            UserFileType.$$$reportNull$$$0(6);
        }
        this.myIcon = icon;
    }

    public void setIconPath(@NotNull String value) {
        if (value == null) {
            UserFileType.$$$reportNull$$$0(7);
        }
        this.myIconPath = value;
    }

    public String toString() {
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/UserFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/UserFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setIconPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

