/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsProvider;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingsManager
implements PersistentStateComponentWithModificationTracker<Element> {
    private static final Logger LOG = Logger.getInstance(CodeStyleSettingsManager.class);
    @Deprecated
    @Nullable
    public volatile CodeStyleSettings PER_PROJECT_SETTINGS;
    public volatile boolean USE_PER_PROJECT_SETTINGS;
    public volatile String PREFERRED_PROJECT_CODE_STYLE;
    private volatile CodeStyleSettings myTemporarySettings;
    private final List<CodeStyleSettingsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    @Override
    public long getStateModificationCount() {
        return this.enumSettings().stream().mapToLong(settings -> settings.getModificationTracker().getModificationCount()).sum();
    }

    public static CodeStyleSettingsManager getInstance(@Nullable Project project) {
        if (project == null || project.isDefault()) {
            return CodeStyleSettingsManager.getInstance();
        }
        return (CodeStyleSettingsManager)project.getService(ProjectCodeStyleSettingsManager.class);
    }

    @Deprecated
    public static CodeStyleSettingsManager getInstance() {
        return (CodeStyleSettingsManager)ApplicationManager.getApplication().getService(AppCodeStyleSettingsManager.class);
    }

    protected void registerExtensionPointListeners(@NotNull Disposable disposable) {
        if (disposable == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        FileIndentOptionsProvider.EP_NAME.addExtensionPointListener(this::notifyCodeStyleSettingsChanged, disposable);
        FileTypeIndentOptionsProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileTypeIndentOptionsProvider>(){

            public void extensionAdded(@NotNull FileTypeIndentOptionsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                CodeStyleSettingsManager.this.registerFileTypeIndentOptions(CodeStyleSettingsManager.this.enumSettings(), extension.getFileType(), extension.createIndentOptions());
            }

            public void extensionRemoved(@NotNull FileTypeIndentOptionsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                CodeStyleSettingsManager.this.unregisterFileTypeIndentOptions(CodeStyleSettingsManager.this.enumSettings(), extension.getFileType());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
        LanguageCodeStyleSettingsProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<LanguageCodeStyleSettingsProvider>(){

            public void extensionAdded(@NotNull LanguageCodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                CodeStyleSettingsManager.this.registerLanguageSettings(CodeStyleSettingsManager.this.enumSettings(), extension);
                CodeStyleSettingsManager.this.registerCustomSettings(CodeStyleSettingsManager.this.enumSettings(), extension);
            }

            public void extensionRemoved(@NotNull LanguageCodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                CodeStyleSettingsManager.this.unregisterLanguageSettings(CodeStyleSettingsManager.this.enumSettings(), extension);
                CodeStyleSettingsManager.this.unregisterCustomSettings(CodeStyleSettingsManager.this.enumSettings(), extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
        CodeStyleSettingsProvider.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CodeStyleSettingsProvider>(){

            public void extensionAdded(@NotNull CodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                CodeStyleSettingsManager.this.registerCustomSettings(CodeStyleSettingsManager.this.enumSettings(), extension);
            }

            public void extensionRemoved(@NotNull CodeStyleSettingsProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(3);
                }
                CodeStyleSettingsManager.this.unregisterCustomSettings(CodeStyleSettingsManager.this.enumSettings(), extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
    }

    protected Collection<CodeStyleSettings> enumSettings() {
        return Collections.emptyList();
    }

    @ApiStatus.Internal
    public final void registerFileTypeIndentOptions(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull FileType fileType, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        if (fileType == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        if (indentOptions == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(3);
        }
        allSettings.forEach(settings -> settings.registerAdditionalIndentOptions(fileType, indentOptions));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterFileTypeIndentOptions(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull FileType fileType) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        if (fileType == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        allSettings.forEach(settings -> settings.unregisterAdditionalIndentOptions(fileType));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void registerLanguageSettings(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull LanguageCodeStyleSettingsProvider provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        allSettings.forEach(settings -> settings.registerSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterLanguageSettings(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull LanguageCodeStyleSettingsProvider provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(8);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(9);
        }
        allSettings.forEach(settings -> settings.removeSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void registerCustomSettings(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull CodeStyleSettingsProvider provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(10);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(11);
        }
        allSettings.forEach(settings -> settings.registerSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @ApiStatus.Internal
    public final void unregisterCustomSettings(@NotNull Collection<CodeStyleSettings> allSettings, @NotNull CodeStyleSettingsProvider provider) {
        if (allSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(12);
        }
        if (provider == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(13);
        }
        allSettings.forEach(settings -> settings.removeSettings(provider));
        this.notifyCodeStyleSettingsChanged();
    }

    @Deprecated
    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(14);
        }
        return codeStyleSettings;
    }

    @Deprecated
    @NotNull
    public CodeStyleSettings getCurrentSettings() {
        CodeStyleSettings temporarySettings = this.myTemporarySettings;
        if (temporarySettings != null) {
            CodeStyleSettings codeStyleSettings = temporarySettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(15);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings projectSettings = this.getMainProjectCodeStyle();
        if (this.USE_PER_PROJECT_SETTINGS && projectSettings != null) {
            CodeStyleSettings codeStyleSettings = projectSettings;
            if (codeStyleSettings == null) {
                CodeStyleSettingsManager.$$$reportNull$$$0(16);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSchemes.getInstance().findPreferredScheme(this.PREFERRED_PROJECT_CODE_STYLE).getCodeStyleSettings();
        if (codeStyleSettings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(17);
        }
        return codeStyleSettings;
    }

    @Override
    public Element getState() {
        Element result = new Element("state");
        try {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)result, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter<CodeStyleSettingsManager>(this, new CodeStyleSettingsManager()){

                public boolean isAccept(@NotNull Field field) {
                    if (field == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return !CodeStyleSettingsManager.this.isIgnoredOnSave(field.getName()) && super.isAccept(field);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/psi/codeStyle/CodeStyleSettingsManager$4", "isAccept"));
                }
            });
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        if (fieldName == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(18);
        }
        return false;
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(19);
        }
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        this.PER_PROJECT_SETTINGS = settings;
    }

    @Nullable
    public CodeStyleSettings getMainProjectCodeStyle() {
        return this.PER_PROJECT_SETTINGS;
    }

    @Deprecated
    public boolean isLoaded() {
        return true;
    }

    public void setTemporarySettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(20);
        }
        this.myTemporarySettings = settings;
    }

    public void dropTemporarySettings() {
        this.myTemporarySettings = null;
    }

    @Nullable
    public CodeStyleSettings getTemporarySettings() {
        return this.myTemporarySettings;
    }

    public void addListener(@NotNull CodeStyleSettingsListener listener2) {
        if (listener2 == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(21);
        }
        this.myListeners.add(listener2);
    }

    private void removeListener(@NotNull CodeStyleSettingsListener listener2) {
        if (listener2 == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(22);
        }
        this.myListeners.remove(listener2);
    }

    public static void removeListener(@Nullable Project project, @NotNull CodeStyleSettingsListener listener2) {
        CodeStyleSettingsManager projectInstance;
        if (listener2 == null) {
            CodeStyleSettingsManager.$$$reportNull$$$0(23);
        }
        if (project == null || project.isDefault()) {
            CodeStyleSettingsManager.getInstance().removeListener(listener2);
        } else if (!project.isDisposed() && (projectInstance = (CodeStyleSettingsManager)ServiceManager.getService(project, ProjectCodeStyleSettingsManager.class)) != null) {
            projectInstance.removeListener(listener2);
        }
    }

    public void fireCodeStyleSettingsChanged(@Nullable PsiFile file) {
        for (CodeStyleSettingsListener listener2 : this.myListeners) {
            listener2.codeStyleSettingsChanged(new CodeStyleSettingsChangeEvent(file));
        }
    }

    public final void notifyCodeStyleSettingsChanged() {
        this.updateSettingsTracker();
        this.fireCodeStyleSettingsChanged(null);
    }

    @ApiStatus.Internal
    public void updateSettingsTracker() {
        CodeStyleSettings settings = this.getCurrentSettings();
        settings.getModificationTracker().incModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSettings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CodeStyleSettingsManager";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointListeners";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypeIndentOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileTypeIndentOptions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerLanguageSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unregisterLanguageSettings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomSettings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "unregisterCustomSettings";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOnSave";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setTemporarySettings";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

