/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionProvider;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorNotificationPanel
extends JPanel
implements IntentionActionProvider,
Weighted {
    protected final JLabel myLabel = new JLabel();
    protected final JLabel myGearLabel = new JLabel();
    protected final JPanel myLinksPanel = new NonOpaquePanel(new HorizontalLayout(JBUIScale.scale((int)16)));
    protected Color myBackgroundColor;
    protected ColorKey myBackgroundColorKey;
    @Nullable
    private Key<?> myProviderKey;
    private Project myProject;

    public EditorNotificationPanel(@Nullable Color backgroundColor) {
        this();
        this.myBackgroundColor = backgroundColor;
    }

    public EditorNotificationPanel(@Nullable ColorKey backgroundColorKey) {
        this();
        this.myBackgroundColorKey = backgroundColorKey;
    }

    public EditorNotificationPanel() {
        super(new BorderLayout());
        NonOpaquePanel panel2 = new NonOpaquePanel(new BorderLayout());
        panel2.add("Center", this.myLabel);
        panel2.add("East", this.myLinksPanel);
        panel2.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
        panel2.setMinimumSize(new Dimension(0, 0));
        this.add("Center", panel2);
        this.add("East", this.myGearLabel);
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public void setProviderKey(@Nullable Key<?> key) {
        this.myProviderKey = key;
    }

    public static Color getToolbarBackground() {
        return UIUtil.getPanelBackground();
    }

    public void setText(@Nls String text) {
        this.myLabel.setText(text);
    }

    public EditorNotificationPanel text(@NotNull @Nls String text) {
        if (text == null) {
            EditorNotificationPanel.$$$reportNull$$$0(0);
        }
        this.myLabel.setText(text);
        return this;
    }

    public EditorNotificationPanel icon(@NotNull Icon icon) {
        if (icon == null) {
            EditorNotificationPanel.$$$reportNull$$$0(1);
        }
        this.myLabel.setIcon(icon);
        return this;
    }

    @Override
    public Color getBackground() {
        Color color;
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (this.myBackgroundColor != null) {
            return this.myBackgroundColor;
        }
        if (this.myBackgroundColorKey != null && (color = globalScheme.getColor(this.myBackgroundColorKey)) != null) {
            return color;
        }
        color = globalScheme.getColor(EditorColors.NOTIFICATION_BACKGROUND);
        return color != null ? color : UIUtil.getToolTipBackground();
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@Nls String text, @NonNls String actionId) {
        HyperlinkLabel hyperlinkLabel = this.createActionLabel(text, actionId, true);
        if (hyperlinkLabel == null) {
            EditorNotificationPanel.$$$reportNull$$$0(2);
        }
        return hyperlinkLabel;
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@Nls String text, @NonNls String actionId, boolean showInIntentionMenu) {
        HyperlinkLabel hyperlinkLabel = this.createActionLabel(text, () -> this.executeAction(actionId), showInIntentionMenu);
        if (hyperlinkLabel == null) {
            EditorNotificationPanel.$$$reportNull$$$0(3);
        }
        return hyperlinkLabel;
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@Nls String text, @NotNull Runnable action) {
        if (action == null) {
            EditorNotificationPanel.$$$reportNull$$$0(4);
        }
        HyperlinkLabel hyperlinkLabel = this.createActionLabel(text, action, true);
        if (hyperlinkLabel == null) {
            EditorNotificationPanel.$$$reportNull$$$0(5);
        }
        return hyperlinkLabel;
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@Nls String text, @NotNull Runnable action, boolean showInIntentionMenu) {
        if (action == null) {
            EditorNotificationPanel.$$$reportNull$$$0(6);
        }
        return this.createActionLabelImpl(text, this.withLogNotifications(action), showInIntentionMenu);
    }

    @NotNull
    public HyperlinkLabel createActionLabel(@Nls String text, ActionHandler handler, boolean showInIntentionMenu) {
        return this.createActionLabelImpl(text, this.withNotifications(handler), showInIntentionMenu);
    }

    @NotNull
    private HyperlinkLabel createActionLabelImpl(@Nls String text, ActionHandler handler, boolean showInIntentionMenu) {
        ActionHyperlinkLabel label = new ActionHyperlinkLabel(this, text, this.getBackground(), showInIntentionMenu, handler);
        this.myLinksPanel.add(label);
        ActionHyperlinkLabel actionHyperlinkLabel = label;
        if (actionHyperlinkLabel == null) {
            EditorNotificationPanel.$$$reportNull$$$0(7);
        }
        return actionHyperlinkLabel;
    }

    protected void executeAction(@NonNls String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        AnActionEvent event = AnActionEvent.createFromAnAction(action, null, this.getActionPlace(), DataManager.getInstance().getDataContext(this));
        action.beforeActionPerformedUpdate(event);
        action.update(event);
        if (event.getPresentation().isEnabled() && event.getPresentation().isVisible()) {
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            actionManager.fireBeforeActionPerformed(action, event.getDataContext(), event);
            action.actionPerformed(event);
            actionManager.fireAfterActionPerformed(action, event.getDataContext(), event);
        }
    }

    @NotNull
    protected String getActionPlace() {
        return "unknown";
    }

    @Override
    @Nullable
    public IntentionActionWithOptions getIntentionAction() {
        MyIntentionAction action = new MyIntentionAction();
        return action.myOptions.isEmpty() ? null : action;
    }

    @Override
    public double getWeight() {
        return 0.0;
    }

    @Nullable
    protected String getIntentionActionText() {
        return null;
    }

    @NotNull
    protected PriorityAction.Priority getIntentionActionPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.NORMAL;
        if (priority == null) {
            EditorNotificationPanel.$$$reportNull$$$0(8);
        }
        return priority;
    }

    @NotNull
    @Nls
    protected String getIntentionActionFamilyName() {
        String string = IdeBundle.message("intention.family.editor.notification", new Object[0]);
        if (string == null) {
            EditorNotificationPanel.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void logNotificationActionInvocation(@NotNull Object handlerClass) {
        if (handlerClass == null) {
            EditorNotificationPanel.$$$reportNull$$$0(10);
        }
        if (this.myProject != null) {
            EditorNotifications.getInstance(this.myProject).logNotificationActionInvocation(this.myProviderKey, handlerClass.getClass());
        }
    }

    @NotNull
    private ActionHandler withLogNotifications(final @NotNull Runnable action) {
        if (action == null) {
            EditorNotificationPanel.$$$reportNull$$$0(11);
        }
        return new ActionHandler(){

            @Override
            public void handlePanelActionClick(@NotNull EditorNotificationPanel panel2, @NotNull HyperlinkEvent e) {
                if (panel2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditorNotificationPanel.this.logNotificationActionInvocation(action);
                action.run();
            }

            @Override
            public void handleQuickFixClick(@NotNull Editor editor, @NotNull PsiFile file) {
                if (editor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                EditorNotificationPanel.this.logNotificationActionInvocation(action);
                action.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePanelActionClick";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleQuickFixClick";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private ActionHandler withNotifications(final @NotNull ActionHandler handler) {
        if (handler == null) {
            EditorNotificationPanel.$$$reportNull$$$0(12);
        }
        return new ActionHandler(){

            @Override
            public void handlePanelActionClick(@NotNull EditorNotificationPanel panel2, @NotNull HyperlinkEvent e) {
                if (panel2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                EditorNotificationPanel.this.logNotificationActionInvocation(handler);
                handler.handlePanelActionClick(panel2, e);
            }

            @Override
            public void handleQuickFixClick(@NotNull Editor editor, @NotNull PsiFile file) {
                if (editor == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (file == null) {
                    2.$$$reportNull$$$0(3);
                }
                EditorNotificationPanel.this.logNotificationActionInvocation(handler);
                handler.handleQuickFixClick(editor, file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePanelActionClick";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleQuickFixClick";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/EditorNotificationPanel";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/EditorNotificationPanel";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionLabel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionLabelImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionPriority";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "icon";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createActionLabel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationActionInvocation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withLogNotifications";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withNotifications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySettingsOption
    implements IntentionAction,
    Iconable,
    LowPriorityAction {
        private final JLabel myLabel;

        private MySettingsOption(JLabel label) {
            this.myLabel = label;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String string = EditorBundle.message("editor.notification.settings.option.name", new Object[0]);
            if (string == null) {
                MySettingsOption.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = IdeBundle.message("intention.family.editor.notification.settings", new Object[0]);
            if (string == null) {
                MySettingsOption.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                MySettingsOption.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                MySettingsOption.$$$reportNull$$$0(3);
            }
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 501, System.currentTimeMillis(), 0, 0, 0, 1, false));
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 502, System.currentTimeMillis(), 0, 0, 0, 1, false));
            this.myLabel.dispatchEvent(new MouseEvent(this.myLabel, 500, System.currentTimeMillis(), 0, 0, 0, 1, false));
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return this.myLabel.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$MySettingsOption";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$MySettingsOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyLinkOption
    implements IntentionAction {
        private final HyperlinkLabel myLabel;

        private MyLinkOption(HyperlinkLabel label) {
            this.myLabel = label;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String string = this.myLabel.getText();
            if (string == null) {
                MyLinkOption.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = IdeBundle.message("intention.family.editor.notification.option", new Object[0]);
            if (string == null) {
                MyLinkOption.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                MyLinkOption.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                MyLinkOption.$$$reportNull$$$0(3);
            }
            if (this.myLabel instanceof ActionHyperlinkLabel) {
                ((ActionHyperlinkLabel)this.myLabel).handleIntentionActionClick(editor, file);
            } else {
                this.myLabel.doClick();
            }
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$MyLinkOption";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$MyLinkOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyIntentionAction
    implements IntentionActionWithOptions,
    Iconable,
    PriorityAction {
        private final List<IntentionAction> myOptions = new ArrayList<IntentionAction>();

        private MyIntentionAction() {
            for (Component component : EditorNotificationPanel.this.myLinksPanel.getComponents()) {
                if (!(component instanceof HyperlinkLabel) || component instanceof ActionHyperlinkLabel && !((ActionHyperlinkLabel)component).myShowInIntentionMenu) continue;
                this.myOptions.add(new MyLinkOption((HyperlinkLabel)component));
            }
            if (EditorNotificationPanel.this.myGearLabel.getIcon() != null) {
                this.myOptions.add(new MySettingsOption(EditorNotificationPanel.this.myGearLabel));
            }
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                MyIntentionAction.$$$reportNull$$$0(0);
            }
            this.myOptions.get(0).invoke(project, editor, file);
        }

        @Override
        public boolean startInWriteAction() {
            return this.myOptions.get(0).startInWriteAction();
        }

        @Override
        @NotNull
        public List<IntentionAction> getOptions() {
            List<IntentionAction> list = this.myOptions.isEmpty() ? Collections.emptyList() : this.myOptions.subList(1, this.myOptions.size());
            if (list == null) {
                MyIntentionAction.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String textOverride = EditorNotificationPanel.this.getIntentionActionText();
            if (textOverride != null) {
                String string = textOverride;
                if (string == null) {
                    MyIntentionAction.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (!this.myOptions.isEmpty()) {
                String string = this.myOptions.get(0).getText();
                if (string == null) {
                    MyIntentionAction.$$$reportNull$$$0(3);
                }
                return string;
            }
            String text = EditorNotificationPanel.this.myLabel.getText();
            String string = StringUtil.isEmpty((String)text) ? EditorBundle.message("editor.notification.default.action.name", new Object[0]) : StringUtil.shortenTextWithEllipsis((String)text, (int)50, (int)0);
            if (string == null) {
                MyIntentionAction.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = EditorNotificationPanel.this.getIntentionActionPriority();
            if (priority == null) {
                MyIntentionAction.$$$reportNull$$$0(5);
            }
            return priority;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = EditorNotificationPanel.this.getIntentionActionFamilyName();
            if (string == null) {
                MyIntentionAction.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                MyIntentionAction.$$$reportNull$$$0(7);
            }
            return true;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return AllIcons.Actions.IntentionBulb;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/EditorNotificationPanel$MyIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/EditorNotificationPanel$MyIntentionAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ActionHyperlinkLabel
    extends HyperlinkLabel {
        private final boolean myShowInIntentionMenu;
        private final ActionHandler myHandler;

        private ActionHyperlinkLabel(final @NotNull EditorNotificationPanel notificationPanel, String text, Color background, boolean showInIntentionMenu, @NotNull ActionHandler handler) {
            if (notificationPanel == null) {
                ActionHyperlinkLabel.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                ActionHyperlinkLabel.$$$reportNull$$$0(1);
            }
            super(text, background);
            this.myShowInIntentionMenu = showInIntentionMenu;
            this.myHandler = handler;
            this.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    if (e == null) {
                        return;
                    }
                    myHandler.handlePanelActionClick(notificationPanel, e);
                }
            });
        }

        void handleIntentionActionClick(Editor editor, PsiFile file) {
            if (editor == null || file == null) {
                return;
            }
            this.myHandler.handleQuickFixClick(editor, file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notificationPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/EditorNotificationPanel$ActionHyperlinkLabel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ActionHandler {
        public void handlePanelActionClick(@NotNull EditorNotificationPanel var1, @NotNull HyperlinkEvent var2);

        public void handleQuickFixClick(@NotNull Editor var1, @NotNull PsiFile var2);
    }
}

