/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsBorder;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.DefaultTabPainterAdapter;
import com.intellij.ui.tabs.impl.DragHelper;
import com.intellij.ui.tabs.impl.JBDefaultTabsBorder;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.TabsSideSplitter;
import com.intellij.ui.tabs.impl.singleRow.ScrollableSingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import com.intellij.ui.tabs.impl.table.TableLayout;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayout;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutCallback;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutInfo;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutSettingsManager;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.LazyUiDisposable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DirtyUI
public class JBTabsImpl
extends JComponent
implements JBTabsEx,
PropertyChangeListener,
TimerListener,
DataProvider,
PopupMenuListener,
JBTabsPresentation,
Queryable,
UISettingsListener,
QuickActionProvider,
MorePopupAware,
Accessible {
    public static final boolean NEW_TABS = Registry.is((String)"ide.editor.tabs.use.tabslayout");
    TabsLayout myTabsLayout;
    JPanel myTabContent;
    public static final Key<Integer> SIDE_TABS_SIZE_LIMIT_KEY = Key.create((String)"SIDE_TABS_SIZE_LIMIT_KEY");
    public static final int MIN_TAB_WIDTH = JBUIScale.scale((int)75);
    public static final int DEFAULT_MAX_TAB_WIDTH = JBUIScale.scale((int)300);
    private static final Comparator<TabInfo> ABC_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getText(), (String)o2.getText());
    private static final Logger LOG = Logger.getInstance(JBTabsImpl.class);
    private final List<TabInfo> myVisibleInfos;
    private final Map<TabInfo, AccessibleTabPage> myInfo2Page;
    private final Map<TabInfo, Integer> myHiddenInfos;
    private TabInfo mySelectedInfo;
    public final Map<TabInfo, TabLabel> myInfo2Label;
    public final Map<TabInfo, Toolbar> myInfo2Toolbar;
    public final ActionToolbar myMoreToolbar;
    @Deprecated
    public Dimension myHeaderFitSize;
    private Insets myInnerInsets;
    private final List<EventListener> myTabMouseListeners;
    private final List<TabsListener> myTabListeners;
    private boolean myFocused;
    private Getter<? extends ActionGroup> myPopupGroup;
    private String myPopupPlace;
    TabInfo myPopupInfo;
    final DefaultActionGroup myNavigationActions;
    final PopupMenuListener myPopupListener;
    JPopupMenu myActivePopup;
    public boolean myHorizontalSide;
    private boolean mySideComponentOnTabs;
    private boolean mySideComponentBefore;
    private final int mySeparatorWidth;
    private DataProvider myDataProvider;
    private final WeakHashMap<Component, Component> myDeferredToRemove;
    private SingleRowLayout mySingleRowLayout;
    private final TableLayout myTableLayout;
    private final TabsSideSplitter mySplitter;
    private TabLayout myLayout;
    private LayoutPassInfo myLastLayoutPass;
    public boolean myForcedRelayout;
    private UiDecorator myUiDecorator;
    static final UiDecorator ourDefaultDecorator = new DefaultDecorator();
    private boolean myPaintFocus;
    private boolean myHideTabs;
    @Nullable
    private Project myProject;
    @NotNull
    private final Disposable myParentDisposable;
    private boolean myRequestFocusOnLastFocusedComponent;
    private boolean myListenerAdded;
    final Set<TabInfo> myAttractions;
    private final Animator myAnimator;
    private List<TabInfo> myAllTabs;
    private IdeFocusManager myFocusManager;
    private static final boolean myAdjustBorders = true;
    private Set<JBTabsImpl> myNestedTabs;
    boolean myAddNavigationGroup;
    private Color myActiveTabFillIn;
    private boolean myTabLabelActionsAutoHide;
    private final TabActionsAutoHideListener myTabActionsAutoHideListener;
    private Disposable myTabActionsAutoHideListenerDisposable;
    private IdeGlassPane myGlassPane;
    @NonNls
    private static final String LAYOUT_DONE = "Layout.done";
    @NonNls
    public static final String STRETCHED_BY_WIDTH = "Layout.stretchedByWidth";
    private TimedDeadzone.Length myTabActionsMouseDeadzone;
    private long myRemoveDeferredRequest;
    private JBTabsPosition myPosition;
    private final JBTabsBorder myBorder;
    private final BaseNavigationAction myNextAction;
    private final BaseNavigationAction myPrevAction;
    private boolean myTabDraggingEnabled;
    private DragHelper myDragHelper;
    private boolean myNavigationActionsEnabled;
    protected TabInfo myDropInfo;
    private int myDropInfoIndex;
    protected boolean myShowDropLocation;
    private TabInfo myOldSelection;
    private JBTabs.SelectionChangeHandler mySelectionChangeHandler;
    private Runnable myDeferredFocusRequest;
    private int myFirstTabOffset;
    private final TabPainterAdapter myTabPainterAdapter;
    protected final JBTabPainter myTabPainter;
    private boolean myAlphabeticalMode;
    private boolean mySupportsCompression;
    private String myEmptyText;
    private boolean myMouseInsideTabsArea;
    private boolean myRemoveNotifyInProgress;
    private TabsLayoutCallback myTabsLayoutCallback;
    private MouseListener myTabsLayoutMouseListener;
    private MouseMotionListener myTabsLayoutMouseMotionListener;
    private MouseWheelListener myTabsLayoutMouseWheelListener;
    private TabLabel tabLabelAtMouse;

    protected JBTabsBorder createTabBorder() {
        return new JBDefaultTabsBorder(this);
    }

    public JBTabPainter getTabPainter() {
        return this.myTabPainter;
    }

    TabPainterAdapter getTabPainterAdapter() {
        return this.myTabPainterAdapter;
    }

    protected TabPainterAdapter createTabPainterAdapter() {
        return new DefaultTabPainterAdapter(JBTabPainter.getDEFAULT());
    }

    public JBTabsImpl(@NotNull Project project) {
        if (project == null) {
            JBTabsImpl.$$$reportNull$$$0(0);
        }
        this(project, (Disposable)project);
    }

    private JBTabsImpl(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            JBTabsImpl.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            JBTabsImpl.$$$reportNull$$$0(2);
        }
        this(project, IdeFocusManager.getInstance(project), parent);
    }

    @Deprecated
    public JBTabsImpl(@Nullable Project project, @NotNull ActionManager actionManager, IdeFocusManager focusManager, @NotNull Disposable parent) {
        if (actionManager == null) {
            JBTabsImpl.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            JBTabsImpl.$$$reportNull$$$0(4);
        }
        this(project, focusManager, parent);
    }

    public JBTabsImpl(@Nullable Project project, @Nullable IdeFocusManager focusManager, final @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JBTabsImpl.$$$reportNull$$$0(5);
        }
        this.myVisibleInfos = new ArrayList<TabInfo>();
        this.myInfo2Page = new HashMap<TabInfo, AccessibleTabPage>();
        this.myHiddenInfos = new HashMap<TabInfo, Integer>();
        this.myInfo2Label = new HashMap<TabInfo, TabLabel>();
        this.myInfo2Toolbar = new HashMap<TabInfo, Toolbar>();
        this.myInnerInsets = JBUI.emptyInsets();
        this.myTabMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTabListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myHorizontalSide = true;
        this.mySideComponentOnTabs = true;
        this.mySideComponentBefore = true;
        this.mySeparatorWidth = JBUI.scale((int)1);
        this.myDeferredToRemove = new WeakHashMap();
        this.myTableLayout = new TableLayout(this);
        this.mySplitter = new TabsSideSplitter(this);
        this.myAttractions = new HashSet<TabInfo>();
        this.myNestedTabs = new HashSet<JBTabsImpl>();
        this.myAddNavigationGroup = true;
        this.myTabActionsAutoHideListener = new TabActionsAutoHideListener();
        this.myTabActionsAutoHideListenerDisposable = Disposer.newDisposable();
        this.myTabActionsMouseDeadzone = TimedDeadzone.DEFAULT;
        this.myPosition = JBTabsPosition.top;
        this.myBorder = this.createTabBorder();
        this.myNavigationActionsEnabled = true;
        this.myShowDropLocation = true;
        this.myTabPainterAdapter = this.createTabPainterAdapter();
        this.myTabPainter = this.myTabPainterAdapter.getTabPainter();
        this.myProject = project;
        this.myFocusManager = focusManager == null ? IdeFocusManager.getGlobalInstance() : focusManager;
        this.myParentDisposable = parentDisposable;
        this.myTabsLayoutCallback = new TabsLayoutCallback(){

            @Override
            public TabLabel getTabLabel(TabInfo info) {
                return JBTabsImpl.this.myInfo2Label.get(info);
            }

            @Override
            public TabInfo getSelectedInfo() {
                return JBTabsImpl.this.mySelectedInfo;
            }

            @Override
            public Toolbar getToolbar(TabInfo tabInfo) {
                return JBTabsImpl.this.myInfo2Toolbar.get(tabInfo);
            }

            @Override
            public boolean isHorizontalToolbar() {
                return JBTabsImpl.this.myHorizontalSide;
            }

            @Override
            public boolean isHiddenTabs() {
                return JBTabsImpl.this.myHideTabs;
            }

            @Override
            public List<TabInfo> getVisibleTabsInfos() {
                return JBTabsImpl.this.getVisibleInfos();
            }

            @Override
            public Map<TabInfo, Integer> getHiddenInfos() {
                return JBTabsImpl.this.myHiddenInfos;
            }

            @Override
            public WeakHashMap<Component, Component> getDeferredToRemove() {
                return JBTabsImpl.this.myDeferredToRemove;
            }

            @Override
            public int getAllTabsCount() {
                return JBTabsImpl.this.getTabCount();
            }

            @Override
            public Insets getLayoutInsets() {
                return JBTabsImpl.this.getLayoutInsets();
            }

            @Override
            public Insets getInnerInsets() {
                return JBTabsImpl.this.getInnerInsets();
            }

            @Override
            public int getFirstTabOffset() {
                return JBTabsImpl.this.getFirstTabOffset();
            }

            @Override
            public boolean isEditorTabs() {
                return JBTabsImpl.this.isEditorTabs();
            }

            @Override
            public JBTabsPosition getTabsPosition() {
                return JBTabsImpl.this.getTabsPosition();
            }

            @Override
            public boolean isDropTarget(TabInfo tabInfo) {
                return JBTabsImpl.this.isDropTarget(tabInfo);
            }

            @Override
            public boolean isToolbarOnTabs() {
                return JBTabsImpl.this.isSideComponentOnTabs();
            }

            @Override
            public boolean isToolbarBeforeTabs() {
                return JBTabsImpl.this.isSideComponentBefore();
            }

            @Override
            public int getToolbarInsetForOnTabsMode() {
                return JBTabsImpl.this.getToolbarInset();
            }

            @Override
            public TabInfo getDropInfo() {
                return JBTabsImpl.this.myDropInfo;
            }

            @Override
            public boolean isShowDropLocation() {
                return JBTabsImpl.this.myShowDropLocation;
            }

            @Override
            public int getDropInfoIndex() {
                return JBTabsImpl.this.getDropInfoIndex();
            }

            @Override
            public ActionCallback selectTab(@NotNull TabInfo info, boolean requestFocus) {
                if (info == null) {
                    1.$$$reportNull$$$0(0);
                }
                return JBTabsImpl.this.select(info, requestFocus);
            }

            @Override
            public JComponent getComponent() {
                return JBTabsImpl.this;
            }

            @Override
            public void relayout(boolean forced, boolean layoutNow) {
                JBTabsImpl.this.relayout(forced, layoutNow);
            }

            @Override
            public int tabMSize() {
                return JBTabsImpl.this.tabMSize();
            }

            @Override
            public int getBorderThickness() {
                return JBTabsImpl.this.myBorder.getThickness();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/ui/tabs/impl/JBTabsImpl$1", "selectTab"));
            }
        };
        this.updateTabsLayout(TabsLayoutSettingsManager.getInstance().getDefaultTabsLayoutInfo());
        AWTEventListener listener1 = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                JBTabsImpl.this.myTabsLayout.mouseMotionEventDispatched((MouseEvent)event);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(listener1, 32L);
        Disposer.register((Disposable)parentDisposable, () -> {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit != null) {
                toolkit.removeAWTEventListener(listener1);
            }
        });
        this.myTabContent = new JPanel();
        this.setOpaque(true);
        this.setBackground(this.myTabPainter.getBackgroundColor());
        this.setBorder(this.myBorder);
        this.myNavigationActions = new DefaultActionGroup();
        this.myNextAction = new SelectNextAction(this, parentDisposable);
        this.myPrevAction = new SelectPreviousAction(this, parentDisposable);
        this.myNavigationActions.add(this.myNextAction);
        this.myNavigationActions.add(this.myPrevAction);
        this.setUiDecorator(null);
        this.mySingleRowLayout = this.createSingleRowLayout();
        this.myLayout = this.mySingleRowLayout;
        this.mySplitter.getDivider().setOpaque(false);
        this.myPopupListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JBTabsImpl.this.disposePopupListener();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                JBTabsImpl.this.disposePopupListener();
            }
        };
        ActionManager actionManager = ActionManager.getInstance();
        AnAction tabListAction = actionManager.getAction("TabList");
        this.myMoreToolbar = actionManager.createActionToolbar("TabsMoreToolbar", new DefaultActionGroup(tabListAction), true);
        this.myMoreToolbar.setTargetComponent(this);
        this.myMoreToolbar.getComponent().setBorder((Border)JBUI.Borders.empty());
        this.myMoreToolbar.getComponent().setOpaque(false);
        this.myMoreToolbar.setLayoutPolicy(0);
        this.add(this.myMoreToolbar.getComponent());
        this.addMouseWheelListener(event -> {
            int units = event.getUnitsToScroll();
            if (units == 0) {
                return;
            }
            if (this.mySingleRowLayout.myLastSingRowLayout != null) {
                this.mySingleRowLayout.scroll((int)(event.getPreciseWheelRotation() * (double)this.mySingleRowLayout.getScrollUnitIncrement()));
                this.revalidateAndRepaint(false);
            }
        });
        AWTEventListener listener2 = new AWTEventListener(){
            final Alarm afterScroll;
            {
                this.afterScroll = new Alarm(parentDisposable);
            }

            @Override
            public void eventDispatched(AWTEvent event) {
                if (((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout == null) {
                    return;
                }
                MouseEvent me = (MouseEvent)event;
                Point point = me.getPoint();
                SwingUtilities.convertPointToScreen(point, me.getComponent());
                Rectangle rect = JBTabsImpl.this.getVisibleRect();
                rect = rect.intersection(((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout.tabRectangle);
                Point p = rect.getLocation();
                SwingUtilities.convertPointToScreen(p, JBTabsImpl.this);
                rect.setLocation(p);
                boolean inside = rect.contains(point);
                if (inside != JBTabsImpl.this.myMouseInsideTabsArea) {
                    JBTabsImpl.this.myMouseInsideTabsArea = inside;
                    this.afterScroll.cancelAllRequests();
                    if (!inside) {
                        this.afterScroll.addRequest(() -> {
                            if (!JBTabsImpl.this.myMouseInsideTabsArea) {
                                JBTabsImpl.this.relayout(false, false);
                            }
                        }, 500);
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 32L);
        Disposer.register((Disposable)parentDisposable, () -> {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit != null) {
                toolkit.removeAWTEventListener(listener2);
            }
        });
        this.myAnimator = new Animator("JBTabs Attractions", 2, 500, true){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                JBTabsImpl.this.repaintAttractions();
            }
        };
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return JBTabsImpl.this.getToFocus();
            }
        });
        new LazyUiDisposable<JBTabsImpl>(parentDisposable, (JComponent)this, this){

            @Override
            protected void initialize(@NotNull Disposable parent, @NotNull JBTabsImpl child, @Nullable Project project) {
                if (parent == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (child == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (JBTabsImpl.this.myProject == null && project != null) {
                    JBTabsImpl.this.myProject = project;
                }
                Disposer.register((Disposable)parentDisposable, (Disposable)JBTabsImpl.this.myAnimator);
                Disposer.register((Disposable)parentDisposable, () -> JBTabsImpl.this.removeTimerUpdate());
                IdeGlassPane gp = IdeGlassPaneUtil.find(child);
                JBTabsImpl.this.myTabActionsAutoHideListenerDisposable = Disposer.newDisposable((String)"myTabActionsAutoHideListener");
                Disposer.register((Disposable)parentDisposable, (Disposable)JBTabsImpl.this.myTabActionsAutoHideListenerDisposable);
                gp.addMouseMotionPreprocessor(JBTabsImpl.this.myTabActionsAutoHideListener, JBTabsImpl.this.myTabActionsAutoHideListenerDisposable);
                JBTabsImpl.this.myGlassPane = gp;
                UIUtil.addAwtListener(__ -> {
                    if (!JBPopupFactory.getInstance().getChildPopups(JBTabsImpl.this).isEmpty()) {
                        return;
                    }
                    JBTabsImpl.this.processFocusChange();
                }, (long)4L, (Disposable)parentDisposable);
                JBTabsImpl.this.myDragHelper = new DragHelper(child, parentDisposable);
                JBTabsImpl.this.myDragHelper.start();
                if (JBTabsImpl.this.myProject != null && JBTabsImpl.this.myFocusManager == IdeFocusManager.getGlobalInstance()) {
                    JBTabsImpl.this.myFocusManager = IdeFocusManager.getInstance(JBTabsImpl.this.myProject);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "child";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/tabs/impl/JBTabsImpl$7";
                objectArray[2] = "initialize";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ComponentUtil.putClientProperty((JComponent)this, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> JBIterable.from(this.getVisibleInfos()).filter(Conditions.not((Condition)Conditions.is((Object)this.mySelectedInfo))).transform(info -> info.getComponent()).iterator());
    }

    public boolean isMouseInsideTabsArea() {
        return this.myMouseInsideTabsArea;
    }

    @Override
    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            JBTabsImpl.$$$reportNull$$$0(6);
        }
        for (Map.Entry<TabInfo, TabLabel> entry : this.myInfo2Label.entrySet()) {
            entry.getKey().revalidate();
            entry.getValue().updateActionLabelPosition();
        }
        boolean oldHideTabsIfNeeded = this.mySingleRowLayout instanceof ScrollableSingleRowLayout;
        boolean newHideTabsIfNeeded = uiSettings.getHideTabsIfNeeded();
        if (oldHideTabsIfNeeded != newHideTabsIfNeeded) {
            this.updateRowLayout();
        }
    }

    private void updateRowLayout() {
        boolean wasSingleRow = this.isSingleRow();
        this.mySingleRowLayout = this.createSingleRowLayout();
        if (wasSingleRow) {
            this.myLayout = this.mySingleRowLayout;
        }
        this.relayout(true, true);
    }

    protected SingleRowLayout createSingleRowLayout() {
        return new ScrollableSingleRowLayout(this);
    }

    @Override
    public JBTabs setNavigationActionBinding(String prevActionId, String nextActionId) {
        if (this.myNextAction != null) {
            this.myNextAction.reconnect(nextActionId);
        }
        if (this.myPrevAction != null) {
            this.myPrevAction.reconnect(prevActionId);
        }
        return this;
    }

    public void setHovered(TabLabel label) {
        TabLabel old = this.tabLabelAtMouse;
        this.tabLabelAtMouse = label;
        if (old != null) {
            old.repaint();
        }
        if (this.tabLabelAtMouse != null) {
            this.tabLabelAtMouse.repaint();
        }
    }

    void unHover(TabLabel label) {
        if (this.tabLabelAtMouse == label) {
            this.tabLabelAtMouse = null;
            label.repaint();
        }
    }

    protected boolean isHoveredTab(TabLabel label) {
        return label != null && label == this.tabLabelAtMouse;
    }

    protected boolean isActiveTabs(TabInfo info) {
        return UIUtil.isFocusAncestor((Component)this);
    }

    @Override
    public boolean isEditorTabs() {
        return false;
    }

    public boolean supportsCompression() {
        return this.mySupportsCompression;
    }

    @Override
    public JBTabs setNavigationActionsEnabled(boolean enabled) {
        this.myNavigationActionsEnabled = enabled;
        return this;
    }

    public void addNestedTabs(final @NotNull JBTabsImpl tabs, @NotNull Disposable parentDisposable) {
        if (tabs == null) {
            JBTabsImpl.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            JBTabsImpl.$$$reportNull$$$0(8);
        }
        this.myNestedTabs.add(tabs);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                JBTabsImpl.this.myNestedTabs.remove(tabs);
            }
        });
    }

    public boolean isDragOut(TabLabel label, int deltaX, int deltaY) {
        if (NEW_TABS) {
            return this.getEffectiveLayout().isDragOut(label, deltaX, deltaY);
        }
        return this.myTabsLayout.isDragOut(label, deltaX, deltaY);
    }

    boolean ignoreTabLabelLimitedWidthWhenPaint() {
        if (NEW_TABS) {
            return this.myTabsLayout != null && this.myTabsLayout.ignoreTabLabelLimitedWidthWhenPaint();
        }
        return this.getEffectiveLayout() instanceof ScrollableSingleRowLayout;
    }

    public static Image getComponentImage(TabInfo info) {
        BufferedImage img;
        JComponent cmp = info.getComponent();
        if (cmp.isShowing()) {
            int width = cmp.getWidth();
            int height = cmp.getHeight();
            img = UIUtil.createImage((Component)info.getComponent(), (int)(width > 0 ? width : 500), (int)(height > 0 ? height : 500), (int)2);
            Graphics2D g = img.createGraphics();
            cmp.paint(g);
        } else {
            img = UIUtil.createImage((Component)info.getComponent(), (int)500, (int)500, (int)2);
        }
        return img;
    }

    void resetTabsCache() {
        EDT.assertIsEdt();
        this.myAllTabs = null;
    }

    private void processFocusChange() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            this.setFocused(false);
            return;
        }
        if (owner == this || SwingUtilities.isDescendingFrom(owner, this)) {
            this.setFocused(true);
        } else {
            this.setFocused(false);
        }
    }

    private void repaintAttractions() {
        boolean needsUpdate = false;
        for (TabInfo each : this.myVisibleInfos) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            needsUpdate |= eachLabel.repaintAttraction();
        }
        if (needsUpdate) {
            this.relayout(true, false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addTimerUpdate();
        if (this.myDeferredFocusRequest != null) {
            Runnable request = this.myDeferredFocusRequest;
            this.myDeferredFocusRequest = null;
            request.run();
        }
    }

    @Override
    public void remove(int index) {
        if (this.myRemoveNotifyInProgress) {
            LOG.warn((Throwable)new IllegalStateException("removeNotify in progress"));
        }
        super.remove(index);
    }

    @Override
    public void removeAll() {
        if (this.myRemoveNotifyInProgress) {
            LOG.warn((Throwable)new IllegalStateException("removeNotify in progress"));
        }
        super.removeAll();
    }

    @Override
    public void removeNotify() {
        try {
            this.myRemoveNotifyInProgress = true;
            super.removeNotify();
        }
        finally {
            this.myRemoveNotifyInProgress = false;
        }
        this.setFocused(false);
        this.removeTimerUpdate();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this) && this.myGlassPane != null) {
            Disposer.dispose((Disposable)this.myTabActionsAutoHideListenerDisposable);
            this.myTabActionsAutoHideListenerDisposable = Disposer.newDisposable();
            this.myGlassPane = null;
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    private void addTimerUpdate() {
        if (!this.myListenerAdded) {
            ActionManager.getInstance().addTimerListener(500, this);
            this.myListenerAdded = true;
        }
    }

    private void removeTimerUpdate() {
        if (this.myListenerAdded) {
            ActionManager.getInstance().removeTimerListener(this);
            this.myListenerAdded = false;
        }
    }

    public void layoutComp(SingleRowPassInfo data, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        JComponent hToolbar = (JComponent)data.hToolbar.get();
        JComponent vToolbar = (JComponent)data.vToolbar.get();
        if (hToolbar != null) {
            int toolbarHeight = hToolbar.getPreferredSize().height;
            int hSeparatorHeight = toolbarHeight > 0 ? 1 : 0;
            Rectangle compRect = this.layoutComp(deltaX, toolbarHeight + hSeparatorHeight + deltaY, (JComponent)data.comp.get(), deltaWidth, deltaHeight);
            this.layout(hToolbar, compRect.x, compRect.y - toolbarHeight - hSeparatorHeight, compRect.width, toolbarHeight);
        } else if (vToolbar != null) {
            int vSeparatorWidth;
            int toolbarWidth = vToolbar.getPreferredSize().width;
            int n = vSeparatorWidth = toolbarWidth > 0 ? 1 : 0;
            if (this.mySideComponentBefore) {
                Rectangle compRect = this.layoutComp(toolbarWidth + vSeparatorWidth + deltaX, deltaY, (JComponent)data.comp.get(), deltaWidth, deltaHeight);
                this.layout(vToolbar, compRect.x - toolbarWidth - vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
            } else {
                Rectangle compRect = this.layoutComp(new Rectangle(deltaX, deltaY, this.getWidth() - toolbarWidth - vSeparatorWidth, this.getHeight()), (JComponent)data.comp.get(), deltaWidth, deltaHeight);
                this.layout(vToolbar, compRect.x + compRect.width + vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
            }
        } else {
            this.layoutComp(deltaX, deltaY, (JComponent)data.comp.get(), deltaWidth, deltaHeight);
        }
    }

    public boolean isDropTarget(TabInfo info) {
        return this.myDropInfo != null && this.myDropInfo == info;
    }

    private void setDropInfoIndex(int dropInfoIndex) {
        this.myDropInfoIndex = dropInfoIndex;
    }

    public int getFirstTabOffset() {
        return this.myFirstTabOffset;
    }

    @Override
    public void setFirstTabOffset(int firstTabOffset) {
        this.myFirstTabOffset = firstTabOffset;
    }

    @Override
    public JBTabsPresentation setEmptyText(@Nullable String text) {
        this.myEmptyText = text;
        return this;
    }

    public int tabMSize() {
        return 20;
    }

    @Override
    public ModalityState getModalityState() {
        return ModalityState.stateForComponent(this);
    }

    @Override
    public void run() {
        this.updateTabActions(false);
    }

    @Override
    public void updateTabActions(boolean validateNow) {
        Ref changed = new Ref((Object)Boolean.FALSE);
        for (TabInfo eachInfo : this.myInfo2Label.keySet()) {
            boolean changes = this.myInfo2Label.get(eachInfo).updateTabActions();
            changed.set((Object)((Boolean)changed.get() != false || changes ? 1 : 0));
        }
        if (((Boolean)changed.get()).booleanValue()) {
            this.revalidateAndRepaint();
        }
    }

    private Rectangle getMoreRect() {
        SingleRowPassInfo lastLayout = this.mySingleRowLayout.myLastSingRowLayout;
        return lastLayout != null ? lastLayout.moreRect : null;
    }

    @Override
    public boolean canShowMorePopup() {
        if (NEW_TABS) {
            return this.myTabsLayout instanceof MorePopupAware && ((MorePopupAware)((Object)this.myTabsLayout)).canShowMorePopup();
        }
        return this.getMoreRect() != null;
    }

    @Override
    public void showMorePopup() {
        if (NEW_TABS) {
            if (this.myTabsLayout instanceof MorePopupAware) {
                ((MorePopupAware)((Object)this.myTabsLayout)).showMorePopup();
            }
            return;
        }
        Rectangle rect = this.getMoreRect();
        if (rect == null) {
            return;
        }
        JBPopupMenu menu = new JBPopupMenu();
        for (TabInfo each : this.getVisibleInfos()) {
            if (!this.mySingleRowLayout.isTabHidden(each)) continue;
            menu.add(this.createMenuItem(each));
        }
        menu.show(this, rect.x, rect.y + rect.height);
    }

    private JBMenuItem createMenuItem(@NotNull TabInfo tabInfo) {
        if (tabInfo == null) {
            JBTabsImpl.$$$reportNull$$$0(9);
        }
        JBMenuItem item = new JBMenuItem(tabInfo.getText(), tabInfo.getIcon());
        item.setForeground(tabInfo.getDefaultForeground());
        item.setBackground(tabInfo.getTabColor());
        item.addActionListener(__ -> this.select(tabInfo, true));
        return item;
    }

    @Nullable
    private JComponent getToFocus() {
        TabInfo info = this.getSelectedInfo();
        if (info == null) {
            return null;
        }
        JComponent toFocus = null;
        if (this.isRequestFocusOnLastFocusedComponent() && info.getLastFocusOwner() != null && !this.isMyChildIsFocusedNow()) {
            toFocus = info.getLastFocusOwner();
        }
        if (toFocus == null) {
            toFocus = info.getPreferredFocusableComponent();
            if (toFocus == null) {
                return null;
            }
            JComponent policyToFocus = this.myFocusManager.getFocusTargetFor(toFocus);
            if (policyToFocus != null) {
                toFocus = policyToFocus;
            }
        }
        return toFocus;
    }

    @Override
    public void requestFocus() {
        JComponent toFocus = this.getToFocus();
        if (toFocus != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(toFocus, true));
        } else {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> super.requestFocus());
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        JComponent toFocus = this.getToFocus();
        return toFocus != null ? toFocus.requestFocusInWindow() : super.requestFocusInWindow();
    }

    @Override
    @NotNull
    public TabInfo addTab(TabInfo info, int index) {
        TabInfo tabInfo = this.addTab(info, index, false, true);
        if (tabInfo == null) {
            JBTabsImpl.$$$reportNull$$$0(10);
        }
        return tabInfo;
    }

    @Override
    public TabInfo addTabSilently(TabInfo info, int index) {
        return this.addTab(info, index, false, false);
    }

    private TabInfo addTab(TabInfo info, int index, boolean isDropTarget, boolean fireEvents) {
        if (!isDropTarget && this.getTabs().contains(info)) {
            return this.getTabs().get(this.getTabs().indexOf(info));
        }
        info.getChangeSupport().addPropertyChangeListener(this);
        TabLabel label = this.createTabLabel(info);
        this.myInfo2Label.put(info, label);
        this.myInfo2Page.put(info, new AccessibleTabPage(info));
        if (!isDropTarget) {
            if (index < 0 || index > this.myVisibleInfos.size() - 1) {
                this.myVisibleInfos.add(info);
            } else {
                this.myVisibleInfos.add(index, info);
            }
        }
        this.resetTabsCache();
        this.updateText(info);
        this.updateIcon(info);
        this.updateSideComponent(info);
        this.updateTabActions(info);
        this.add(label);
        JBTabsImpl.adjust(info);
        this.updateAll(false);
        if (info.isHidden()) {
            this.updateHiding();
        }
        if (!isDropTarget && fireEvents && this.getTabCount() == 1) {
            this.fireBeforeSelectionChanged(null, info);
            this.fireSelectionChanged(null, info);
        }
        this.revalidateAndRepaint(false);
        return info;
    }

    protected TabLabel createTabLabel(TabInfo info) {
        return new TabLabel(this, info);
    }

    @Override
    @NotNull
    public TabInfo addTab(TabInfo info) {
        TabInfo tabInfo = this.addTab(info, -1);
        if (tabInfo == null) {
            JBTabsImpl.$$$reportNull$$$0(11);
        }
        return tabInfo;
    }

    @Override
    public TabLabel getTabLabel(TabInfo info) {
        return this.myInfo2Label.get(info);
    }

    @Nullable
    public ActionGroup getPopupGroup() {
        return this.myPopupGroup != null ? (ActionGroup)this.myPopupGroup.get() : null;
    }

    String getPopupPlace() {
        return this.myPopupPlace;
    }

    @Override
    @NotNull
    public JBTabs setPopupGroup(@NotNull ActionGroup popupGroup, @NotNull String place, boolean addNavigationGroup) {
        if (popupGroup == null) {
            JBTabsImpl.$$$reportNull$$$0(12);
        }
        if (place == null) {
            JBTabsImpl.$$$reportNull$$$0(13);
        }
        JBTabs jBTabs = this.setPopupGroup((Getter<? extends ActionGroup>)((Getter)() -> popupGroup), place, addNavigationGroup);
        if (jBTabs == null) {
            JBTabsImpl.$$$reportNull$$$0(14);
        }
        return jBTabs;
    }

    @Override
    @NotNull
    public JBTabs setPopupGroup(@NotNull Getter<? extends ActionGroup> popupGroup, @NotNull String place, boolean addNavigationGroup) {
        if (popupGroup == null) {
            JBTabsImpl.$$$reportNull$$$0(15);
        }
        if (place == null) {
            JBTabsImpl.$$$reportNull$$$0(16);
        }
        this.myPopupGroup = popupGroup;
        this.myPopupPlace = place;
        this.myAddNavigationGroup = addNavigationGroup;
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(17);
        }
        return jBTabsImpl;
    }

    private void updateAll(boolean forcedRelayout) {
        this.mySelectedInfo = this.getSelectedInfo();
        this.updateContainer(forcedRelayout, false);
        this.removeDeferred();
        this.updateListeners();
        this.updateTabActions(false);
        this.updateEnabling();
    }

    private boolean isMyChildIsFocusedNow() {
        JComponent owner = JBTabsImpl.getFocusOwner();
        if (owner == null) {
            return false;
        }
        if (this.mySelectedInfo != null && !SwingUtilities.isDescendingFrom(owner, this.mySelectedInfo.getComponent())) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(owner, this);
    }

    @Nullable
    private static JComponent getFocusOwner() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return (JComponent)(owner instanceof JComponent ? owner : null);
    }

    @Override
    @NotNull
    public ActionCallback select(@NotNull TabInfo info, boolean requestFocus) {
        if (info == null) {
            JBTabsImpl.$$$reportNull$$$0(18);
        }
        return this._setSelected(info, requestFocus);
    }

    @NotNull
    private ActionCallback _setSelected(final TabInfo info, final boolean requestFocus) {
        if (!this.isEnabled()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(19);
            }
            return actionCallback;
        }
        if (this.mySelectionChangeHandler != null) {
            ActionCallback actionCallback = this.mySelectionChangeHandler.execute(info, requestFocus, new ActiveRunnable(){

                @NotNull
                public ActionCallback run() {
                    ActionCallback actionCallback = JBTabsImpl.this.executeSelectionChange(info, requestFocus);
                    if (actionCallback == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    return actionCallback;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/impl/JBTabsImpl$9", "run"));
                }
            });
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(20);
            }
            return actionCallback;
        }
        return this.executeSelectionChange(info, requestFocus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ActionCallback executeSelectionChange(@NotNull TabInfo info, boolean requestFocus) {
        TabLabel label;
        if (info == null) {
            JBTabsImpl.$$$reportNull$$$0(21);
        }
        if (this.mySelectedInfo != null && this.mySelectedInfo.equals(info)) {
            if (!requestFocus) {
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    JBTabsImpl.$$$reportNull$$$0(22);
                }
                return actionCallback;
            }
            Component owner = this.myFocusManager.getFocusOwner();
            JComponent c = info.getComponent();
            if (c != null && owner != null && (c == owner || SwingUtilities.isDescendingFrom(owner, c))) {
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    JBTabsImpl.$$$reportNull$$$0(23);
                }
                return actionCallback;
            }
            return this.requestFocus(this.getToFocus());
        }
        if (this.myRequestFocusOnLastFocusedComponent && this.mySelectedInfo != null && this.isMyChildIsFocusedNow()) {
            this.mySelectedInfo.setLastFocusOwner(JBTabsImpl.getFocusOwner());
        }
        TabInfo oldInfo = this.mySelectedInfo;
        this.mySelectedInfo = info;
        TabInfo newInfo = this.getSelectedInfo();
        if (this.myRequestFocusOnLastFocusedComponent && newInfo != null) {
            newInfo.setLastFocusOwner(null);
        }
        if ((label = this.myInfo2Label.get(info)) != null) {
            this.setComponentZOrder(label, 0);
        }
        this.fireBeforeSelectionChanged(oldInfo, newInfo);
        boolean oldValue = this.myMouseInsideTabsArea;
        try {
            this.updateContainer(false, true);
        }
        finally {
            this.myMouseInsideTabsArea = oldValue;
        }
        this.fireSelectionChanged(oldInfo, newInfo);
        if (!requestFocus) {
            return this.removeDeferred();
        }
        JComponent toFocus = this.getToFocus();
        if (this.myProject != null && toFocus != null) {
            ActionCallback result = new ActionCallback();
            this.requestFocus(toFocus).doWhenProcessed(() -> {
                if (this.myProject.isDisposed()) {
                    result.setRejected();
                } else {
                    this.removeDeferred().notifyWhenDone(result);
                }
            });
            ActionCallback actionCallback = result;
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(24);
            }
            return actionCallback;
        }
        this.requestFocus();
        return this.removeDeferred();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBeforeSelectionChanged(@Nullable TabInfo oldInfo, TabInfo newInfo) {
        if (oldInfo != newInfo) {
            this.myOldSelection = oldInfo;
            try {
                for (TabsListener eachListener : this.myTabListeners) {
                    eachListener.beforeSelectionChanged(oldInfo, newInfo);
                }
            }
            finally {
                this.myOldSelection = null;
            }
        }
    }

    private void fireSelectionChanged(@Nullable TabInfo oldInfo, TabInfo newInfo) {
        if (oldInfo != newInfo) {
            for (TabsListener eachListener : this.myTabListeners) {
                if (eachListener == null) continue;
                eachListener.selectionChanged(oldInfo, newInfo);
            }
        }
    }

    void fireTabsMoved() {
        for (TabsListener eachListener : this.myTabListeners) {
            if (eachListener == null) continue;
            eachListener.tabsMoved();
        }
    }

    private void fireTabRemoved(@NotNull TabInfo info) {
        if (info == null) {
            JBTabsImpl.$$$reportNull$$$0(25);
        }
        for (TabsListener eachListener : this.myTabListeners) {
            if (eachListener == null) continue;
            eachListener.tabRemoved(info);
        }
    }

    @NotNull
    private ActionCallback requestFocus(JComponent toFocus) {
        if (toFocus == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(26);
            }
            return actionCallback;
        }
        if (this.isShowing()) {
            ActionCallback actionCallback = this.myFocusManager.requestFocusInProject(toFocus, this.myProject);
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(27);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.REJECTED;
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(28);
        }
        return actionCallback;
    }

    @NotNull
    private ActionCallback removeDeferred() {
        if (this.myDeferredToRemove.isEmpty()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(29);
            }
            return actionCallback;
        }
        ActionCallback callback = new ActionCallback();
        long executionRequest = ++this.myRemoveDeferredRequest;
        Runnable onDone = () -> {
            if (this.myRemoveDeferredRequest == executionRequest) {
                this.removeDeferredNow();
            }
            callback.setDone();
        };
        this.myFocusManager.doWhenFocusSettlesDown(onDone);
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(30);
        }
        return actionCallback;
    }

    private void queueForRemove(Component c) {
        if (c instanceof JComponent) {
            this.addToDeferredRemove(c);
        } else {
            this.remove(c);
        }
    }

    private void unqueueFromRemove(Component c) {
        this.myDeferredToRemove.remove(c);
    }

    private void removeDeferredNow() {
        for (Component each : this.myDeferredToRemove.keySet()) {
            if (each == null || each.getParent() != this) continue;
            this.remove(each);
        }
        this.myDeferredToRemove.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TabInfo tabInfo = (TabInfo)evt.getSource();
        if ("actionGroup".equals(evt.getPropertyName())) {
            this.updateSideComponent(tabInfo);
            this.relayout(false, false);
        } else if ("component".equals(evt.getPropertyName())) {
            this.relayout(true, false);
        } else if ("text".equals(evt.getPropertyName())) {
            this.updateText(tabInfo);
        } else if ("icon".equals(evt.getPropertyName())) {
            this.updateIcon(tabInfo);
        } else if ("color".equals(evt.getPropertyName())) {
            this.revalidateAndRepaint();
        } else if ("alertStatus".equals(evt.getPropertyName())) {
            boolean start = (Boolean)evt.getNewValue();
            this.updateAttraction(tabInfo, start);
        } else if ("tabActionGroup".equals(evt.getPropertyName())) {
            this.updateTabActions(tabInfo);
            this.relayout(false, false);
        } else if ("hidden".equals(evt.getPropertyName())) {
            this.updateHiding();
            this.relayout(false, false);
        } else if ("enabled".equals(evt.getPropertyName())) {
            this.updateEnabling();
        }
    }

    private void updateEnabling() {
        TabInfo toSelect;
        List<TabInfo> all = this.getTabs();
        for (TabInfo each : all) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            eachLabel.setTabEnabled(each.isEnabled());
        }
        TabInfo selected = this.getSelectedInfo();
        if (selected != null && !selected.isEnabled() && (toSelect = this.getToSelectOnRemoveOf(selected)) != null) {
            this.select(toSelect, this.myFocusManager.getFocusedDescendantFor(this) != null);
        }
    }

    private void updateHiding() {
        boolean update = false;
        Iterator<TabInfo> visible = this.myVisibleInfos.iterator();
        while (visible.hasNext()) {
            TabInfo each = visible.next();
            if (!each.isHidden() || this.myHiddenInfos.containsKey(each)) continue;
            this.myHiddenInfos.put(each, this.myVisibleInfos.indexOf(each));
            visible.remove();
            update = true;
        }
        Iterator<TabInfo> hidden = this.myHiddenInfos.keySet().iterator();
        while (hidden.hasNext()) {
            TabInfo each = hidden.next();
            if (each.isHidden() || !this.myHiddenInfos.containsKey(each)) continue;
            this.myVisibleInfos.add(this.getIndexInVisibleArray(each), each);
            hidden.remove();
            update = true;
        }
        if (update) {
            this.resetTabsCache();
            if (this.mySelectedInfo != null && this.myHiddenInfos.containsKey(this.mySelectedInfo)) {
                this.mySelectedInfo = this.getToSelectOnRemoveOf(this.mySelectedInfo);
            }
            this.updateAll(true);
        }
    }

    private int getIndexInVisibleArray(TabInfo each) {
        int index;
        Integer info = this.myHiddenInfos.get(each);
        int n = index = info == null ? this.myVisibleInfos.size() : info.intValue();
        if (index > this.myVisibleInfos.size()) {
            index = this.myVisibleInfos.size();
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    private void updateIcon(TabInfo tabInfo) {
        this.myInfo2Label.get(tabInfo).setIcon(tabInfo.getIcon());
        this.revalidateAndRepaint();
    }

    public void revalidateAndRepaint() {
        this.revalidateAndRepaint(true);
    }

    protected void revalidateAndRepaint(boolean layoutNow) {
        if (this.myVisibleInfos.isEmpty()) {
            this.setOpaque(false);
            Component nonOpaque = UIUtil.findUltimateParent((Component)this);
            if (this.getParent() != null) {
                Rectangle toRepaint = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), nonOpaque);
                nonOpaque.repaint(toRepaint.x, toRepaint.y, toRepaint.width, toRepaint.height);
            }
        } else {
            this.setOpaque(true);
        }
        if (layoutNow) {
            this.validate();
        } else {
            this.revalidate();
        }
        this.repaint();
    }

    private void updateAttraction(TabInfo tabInfo, boolean start) {
        if (start) {
            this.myAttractions.add(tabInfo);
        } else {
            this.myAttractions.remove(tabInfo);
            tabInfo.setBlinkCount(0);
        }
        if (start && !this.myAnimator.isRunning()) {
            this.myAnimator.resume();
        } else if (!start && this.myAttractions.isEmpty()) {
            this.myAnimator.suspend();
            this.repaintAttractions();
        }
    }

    private void updateText(TabInfo tabInfo) {
        TabLabel label = this.myInfo2Label.get(tabInfo);
        label.setText(tabInfo.getColoredText());
        label.setToolTipText(tabInfo.getTooltipText());
        this.revalidateAndRepaint();
    }

    private void updateSideComponent(TabInfo tabInfo) {
        Toolbar old = this.myInfo2Toolbar.get(tabInfo);
        if (old != null) {
            this.remove(old);
        }
        Toolbar toolbar = this.createToolbarComponent(tabInfo);
        this.myInfo2Toolbar.put(tabInfo, toolbar);
        this.add(toolbar);
    }

    private void updateTabActions(TabInfo info) {
        this.myInfo2Label.get(info).setTabActions(info.getTabLabelActions());
    }

    @Override
    @Nullable
    public TabInfo getSelectedInfo() {
        if (this.myOldSelection != null) {
            return this.myOldSelection;
        }
        if (!this.myVisibleInfos.contains(this.mySelectedInfo)) {
            this.mySelectedInfo = null;
        }
        return this.mySelectedInfo != null ? this.mySelectedInfo : (!this.myVisibleInfos.isEmpty() ? this.myVisibleInfos.get(0) : null);
    }

    @Override
    @Nullable
    public TabInfo getToSelectOnRemoveOf(TabInfo info) {
        if (!this.myVisibleInfos.contains(info)) {
            return null;
        }
        if (this.mySelectedInfo != info) {
            return null;
        }
        if (this.myVisibleInfos.size() == 1) {
            return null;
        }
        int index = this.getVisibleInfos().indexOf(info);
        TabInfo result = null;
        if (index > 0) {
            result = this.findEnabledBackward(index, false);
        }
        if (result == null) {
            result = this.findEnabledForward(index, false);
        }
        return result;
    }

    @Nullable
    TabInfo findEnabledForward(int from, boolean cycle) {
        block3: {
            TabInfo each;
            if (from < 0) {
                return null;
            }
            int index = from;
            List<TabInfo> infos = this.getVisibleInfos();
            do {
                if (++index == infos.size()) {
                    if (!cycle) break block3;
                    index = 0;
                }
                if (index == from) break block3;
            } while (!(each = infos.get(index)).isEnabled());
            return each;
        }
        return null;
    }

    public boolean isAlphabeticalMode() {
        return this.myAlphabeticalMode;
    }

    @Nullable
    TabInfo findEnabledBackward(int from, boolean cycle) {
        block3: {
            TabInfo each;
            if (from < 0) {
                return null;
            }
            int index = from;
            List<TabInfo> infos = this.getVisibleInfos();
            do {
                if (--index == -1) {
                    if (!cycle) break block3;
                    index = infos.size() - 1;
                }
                if (index == from) break block3;
            } while (!(each = infos.get(index)).isEnabled());
            return each;
        }
        return null;
    }

    private Toolbar createToolbarComponent(TabInfo tabInfo) {
        return new Toolbar(this, tabInfo);
    }

    @Override
    @NotNull
    public TabInfo getTabAt(int tabIndex) {
        TabInfo tabInfo = this.getTabs().get(tabIndex);
        if (tabInfo == null) {
            JBTabsImpl.$$$reportNull$$$0(31);
        }
        return tabInfo;
    }

    @Override
    @NotNull
    public List<TabInfo> getTabs() {
        EDT.assertIsEdt();
        if (this.myAllTabs != null) {
            List<TabInfo> list = this.myAllTabs;
            if (list == null) {
                JBTabsImpl.$$$reportNull$$$0(32);
            }
            return list;
        }
        ArrayList<TabInfo> result = new ArrayList<TabInfo>(this.myVisibleInfos);
        for (TabInfo each : this.myHiddenInfos.keySet()) {
            result.add(this.getIndexInVisibleArray(each), each);
        }
        if (this.isAlphabeticalMode()) {
            Collections.sort(result, ABC_COMPARATOR);
        }
        this.myAllTabs = result;
        ArrayList<TabInfo> arrayList = result;
        if (arrayList == null) {
            JBTabsImpl.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @Override
    public TabInfo getTargetInfo() {
        return this.myPopupInfo != null ? this.myPopupInfo : this.getSelectedInfo();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.resetPopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.resetPopup();
    }

    private void resetPopup() {
        SwingUtilities.invokeLater(() -> {
            if (this.myActivePopup == null) {
                this.myPopupInfo = null;
            }
        });
    }

    @Override
    public void setPaintBlocked(boolean blocked, boolean takeSnapshot) {
    }

    private void addToDeferredRemove(Component c) {
        if (!this.myDeferredToRemove.containsKey(c)) {
            this.myDeferredToRemove.put(c, c);
        }
    }

    @Override
    @NotNull
    public JBTabsPresentation setToDrawBorderIfTabsHidden(boolean toDrawBorderIfTabsHidden) {
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(34);
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JBTabs getJBTabs() {
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(35);
        }
        return jBTabsImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            Collection<TabLabel> labels = this.myInfo2Label.values();
            for (TabLabel each : labels) {
                each.setTabActionsAutoHide(this.myTabLabelActionsAutoHide);
            }
            if (NEW_TABS) {
                this.myLastLayoutPass = this.myTabsLayout.layoutContainer(this.myForcedRelayout);
            } else {
                this.myHeaderFitSize = this.computeHeaderFitSize();
                ArrayList<TabInfo> visible = new ArrayList<TabInfo>(this.getVisibleInfos());
                if (this.myDropInfo != null && !visible.contains(this.myDropInfo) && this.myShowDropLocation) {
                    if (this.getDropInfoIndex() >= 0 && this.getDropInfoIndex() < visible.size()) {
                        visible.add(this.getDropInfoIndex(), this.myDropInfo);
                    } else {
                        visible.add(this.myDropInfo);
                    }
                }
                if (this.isSingleRow()) {
                    this.mySingleRowLayout.scrollSelectionInView();
                    this.myLastLayoutPass = this.mySingleRowLayout.layoutSingleRow(visible);
                    Rectangle moreRect = this.getMoreRect();
                    if (moreRect != null) {
                        Dimension preferredSize = this.myMoreToolbar.getComponent().getPreferredSize();
                        Rectangle bounds = new Rectangle(moreRect);
                        int xDiff = (bounds.width - preferredSize.width) / 2;
                        int yDiff = (bounds.height - preferredSize.height) / 2;
                        bounds.x += xDiff + 2;
                        bounds.width -= 2 * xDiff;
                        bounds.y += yDiff;
                        bounds.height -= 2 * yDiff;
                        this.myMoreToolbar.getComponent().setBounds(bounds);
                    } else {
                        this.myMoreToolbar.getComponent().setBounds(new Rectangle());
                    }
                    this.myTableLayout.myLastTableLayout = null;
                    OnePixelDivider divider = this.mySplitter.getDivider();
                    if (divider.getParent() == this) {
                        int location = this.getTabsPosition() == JBTabsPosition.left ? this.mySingleRowLayout.myLastSingRowLayout.tabRectangle.width : this.getWidth() - this.mySingleRowLayout.myLastSingRowLayout.tabRectangle.width;
                        divider.setBounds(location, 0, 1, this.getHeight());
                    }
                } else {
                    this.myLastLayoutPass = this.myTableLayout.layoutTable(visible);
                    this.mySingleRowLayout.myLastSingRowLayout = null;
                }
                this.moveDraggedTabLabel();
                this.myTabActionsAutoHideListener.processMouseOver();
                this.applyResetComponents();
            }
        }
        finally {
            this.myForcedRelayout = false;
        }
    }

    void moveDraggedTabLabel() {
        TabLabel selectedLabel;
        if (this.myDragHelper != null && this.myDragHelper.myDragRec != null && (selectedLabel = this.myInfo2Label.get(this.getSelectedInfo())) != null) {
            Rectangle bounds = selectedLabel.getBounds();
            if (this.isHorizontalTabs()) {
                selectedLabel.setBounds(this.myDragHelper.myDragRec.x, bounds.y, bounds.width, bounds.height);
            } else {
                selectedLabel.setBounds(bounds.x, this.myDragHelper.myDragRec.y, bounds.width, bounds.height);
            }
        }
    }

    private Dimension computeHeaderFitSize() {
        Max max = this.computeMaxSize();
        if (this.myPosition == JBTabsPosition.top || this.myPosition == JBTabsPosition.bottom) {
            return new Dimension(this.getSize().width, this.myHorizontalSide ? Math.max(max.myLabel.height, max.myToolbar.height) : max.myLabel.height);
        }
        return new Dimension(max.myLabel.width + (this.myHorizontalSide ? 0 : max.myToolbar.width), this.getSize().height);
    }

    public Rectangle layoutComp(int componentX, int componentY, JComponent comp, int deltaWidth, int deltaHeight) {
        return this.layoutComp(new Rectangle(componentX, componentY, this.getWidth(), this.getHeight()), comp, deltaWidth, deltaHeight);
    }

    public Rectangle layoutComp(Rectangle bounds, JComponent comp, int deltaWidth, int deltaHeight) {
        Insets insets = this.getLayoutInsets();
        Insets inner = this.getInnerInsets();
        int x = insets.left + bounds.x + inner.left;
        int y = insets.top + bounds.y + inner.top;
        int width = bounds.width - insets.left - insets.right - bounds.x - inner.left - inner.right;
        int height = bounds.height - insets.top - insets.bottom - bounds.y - inner.top - inner.bottom;
        if (!this.isHideTabs()) {
            width += deltaWidth;
            height += deltaHeight;
        }
        return this.layout(comp, x, y, width, height);
    }

    @Override
    public JBTabsPresentation setInnerInsets(Insets innerInsets) {
        this.myInnerInsets = innerInsets;
        return this;
    }

    private Insets getInnerInsets() {
        return this.myInnerInsets;
    }

    public Insets getLayoutInsets() {
        return this.myBorder.getEffectiveBorder();
    }

    public int getToolbarInset() {
        return JBTabsImpl.getArcSize() + 1;
    }

    public void resetLayout(boolean resetLabels) {
        for (TabInfo each : this.myVisibleInfos) {
            this.reset(each, resetLabels);
        }
        if (this.myDropInfo != null) {
            this.reset(this.myDropInfo, resetLabels);
        }
        for (TabInfo each : this.myHiddenInfos.keySet()) {
            this.reset(each, resetLabels);
        }
        for (Component eachDeferred : this.myDeferredToRemove.keySet()) {
            JBTabsImpl.resetLayout((JComponent)eachDeferred);
        }
    }

    private void reset(TabInfo each, boolean resetLabels) {
        JComponent c = each.getComponent();
        if (c != null) {
            JBTabsImpl.resetLayout(c);
        }
        JBTabsImpl.resetLayout(this.myInfo2Toolbar.get(each));
        if (resetLabels) {
            JBTabsImpl.resetLayout(this.myInfo2Label.get(each));
        }
    }

    private static int getArcSize() {
        return 4;
    }

    protected JBTabsPosition getPosition() {
        return this.myPosition;
    }

    @Deprecated
    protected void doPaintBackground(Graphics2D g2d, Rectangle clip) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myVisibleInfos.isEmpty()) {
            if (this.myEmptyText != null) {
                UISettings.setupAntialiasing(g);
                UIUtil.drawCenteredString((Graphics2D)((Graphics2D)g), (Rectangle)this.getBounds(), (String)this.myEmptyText);
            }
            return;
        }
        this.myTabPainter.fillBackground((Graphics2D)g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        this.drawBorder(g);
        if (!NEW_TABS) {
            this.drawToolbarSeparator(g);
        }
    }

    private void drawToolbarSeparator(Graphics g) {
        Toolbar toolbar = this.myInfo2Toolbar.get(this.getSelectedInfo());
        if (toolbar != null && toolbar.getParent() == this && !this.mySideComponentOnTabs && !this.myHorizontalSide && this.isHideTabs()) {
            Rectangle bounds = toolbar.getBounds();
            if (bounds.width > 0) {
                if (this.mySideComponentBefore) {
                    this.getTabPainter().paintBorderLine((Graphics2D)g, this.mySeparatorWidth, new Point(bounds.x + bounds.width, bounds.y), new Point(bounds.x + bounds.width, bounds.y + bounds.height));
                } else {
                    this.getTabPainter().paintBorderLine((Graphics2D)g, this.mySeparatorWidth, new Point(bounds.x - this.mySeparatorWidth, bounds.y), new Point(bounds.x - this.mySeparatorWidth, bounds.y + bounds.height));
                }
            }
        }
    }

    protected TabLabel getSelectedLabel() {
        return this.myInfo2Label.get(this.getSelectedInfo());
    }

    protected List<TabInfo> getVisibleInfos() {
        if (!this.isAlphabeticalMode()) {
            return this.myVisibleInfos;
        }
        ArrayList<TabInfo> sortedCopy = new ArrayList<TabInfo>(this.myVisibleInfos);
        Collections.sort(sortedCopy, ABC_COMPARATOR);
        return sortedCopy;
    }

    protected LayoutPassInfo getLastLayoutPass() {
        return this.myLastLayoutPass;
    }

    public static int getSelectionTabVShift() {
        return 2;
    }

    private boolean isNavigationVisible() {
        return this.myVisibleInfos.size() > 1;
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    protected void drawBorder(Graphics g) {
        if (!this.isHideTabs()) {
            this.myBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    private Max computeMaxSize() {
        Max max = new Max();
        boolean isSideComponentOnTabs = NEW_TABS ? this.myTabsLayout.isToolbarOnTabs() : this.myLayout.isSideComponentOnTabs();
        for (TabInfo eachInfo : this.myVisibleInfos) {
            Toolbar toolbar;
            TabLabel label = this.myInfo2Label.get(eachInfo);
            max.myLabel.height = Math.max(max.myLabel.height, label.getPreferredSize().height);
            max.myLabel.width = Math.max(max.myLabel.width, label.getPreferredSize().width);
            if (!isSideComponentOnTabs || (toolbar = this.myInfo2Toolbar.get(eachInfo)) == null || toolbar.isEmpty()) continue;
            max.myToolbar.height = Math.max(max.myToolbar.height, toolbar.getPreferredSize().height);
            max.myToolbar.width = Math.max(max.myToolbar.width, toolbar.getPreferredSize().width);
        }
        if (this.getTabsPosition().isSide() && this.mySplitter.getSideTabsLimit() > 0) {
            max.myLabel.width = Math.min(max.myLabel.width, this.mySplitter.getSideTabsLimit());
        }
        ++max.myToolbar.height;
        return max;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.computeSize((Function<? super JComponent, ? extends Dimension>)((Function)component -> component.getMinimumSize()), 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.computeSize((Function<? super JComponent, ? extends Dimension>)((Function)component -> component.getPreferredSize()), 3);
    }

    private Dimension computeSize(Function<? super JComponent, ? extends Dimension> transform, int tabCount) {
        Dimension size = new Dimension();
        for (TabInfo each : this.myVisibleInfos) {
            JComponent c = each.getComponent();
            if (c == null) continue;
            Dimension eachSize = (Dimension)transform.fun((Object)c);
            size.width = Math.max(eachSize.width, size.width);
            size.height = Math.max(eachSize.height, size.height);
        }
        this.addHeaderSize(size, tabCount);
        return size;
    }

    private void addHeaderSize(Dimension size, int tabsCount) {
        boolean horizontal;
        Dimension header = this.computeHeaderPreferredSize(tabsCount);
        boolean bl = horizontal = this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
        if (horizontal) {
            size.height += header.height;
            size.width = Math.max(size.width, header.width);
        } else {
            size.height += Math.max(size.height, header.height);
            size.width += header.width;
        }
        Insets insets = this.getLayoutInsets();
        size.width += insets.left + insets.right + 1;
        size.height += insets.top + insets.bottom + 1;
    }

    private Dimension computeHeaderPreferredSize(int tabsCount) {
        boolean horizontal;
        Iterator<TabInfo> infos = this.myInfo2Label.keySet().iterator();
        Dimension size = new Dimension();
        int currentTab = 0;
        boolean bl = horizontal = this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
        while (infos.hasNext()) {
            boolean canGrow = currentTab < tabsCount;
            TabInfo eachInfo = infos.next();
            TabLabel eachLabel = this.myInfo2Label.get(eachInfo);
            Dimension eachPrefSize = eachLabel.getPreferredSize();
            if (horizontal) {
                if (canGrow) {
                    size.width += eachPrefSize.width;
                }
                size.height = Math.max(size.height, eachPrefSize.height);
            } else {
                size.width = Math.max(size.width, eachPrefSize.width);
                if (canGrow) {
                    size.height += eachPrefSize.height;
                }
            }
            ++currentTab;
        }
        if (horizontal) {
            size.height += this.myBorder.getThickness();
        } else {
            size.width += this.myBorder.getThickness();
        }
        return size;
    }

    @Override
    public int getTabCount() {
        return this.getTabs().size();
    }

    @Override
    @NotNull
    public JBTabsPresentation getPresentation() {
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(36);
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public ActionCallback removeTab(TabInfo info) {
        ActionCallback actionCallback = this.removeTab(info, null, true);
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(37);
        }
        return actionCallback;
    }

    @Override
    @NotNull
    public ActionCallback removeTab(TabInfo info, @Nullable TabInfo forcedSelectionTransfer, boolean transferFocus) {
        return this.removeTab(info, forcedSelectionTransfer, transferFocus, false);
    }

    @NotNull
    private ActionCallback removeTab(TabInfo info, @Nullable TabInfo forcedSelectionTransfer, boolean transferFocus, boolean isDropTarget) {
        TabInfo toSelect;
        if (this.myRemoveNotifyInProgress) {
            LOG.warn((Throwable)new IllegalStateException("removeNotify in progress"));
        }
        if (this.myPopupInfo == info) {
            this.myPopupInfo = null;
        }
        if (!(isDropTarget || info != null && this.getTabs().contains(info))) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(38);
            }
            return actionCallback;
        }
        if (isDropTarget && this.myLastLayoutPass != null) {
            this.myLastLayoutPass.myVisibleInfos.remove(info);
        }
        ActionCallback result = new ActionCallback();
        if (forcedSelectionTransfer == null) {
            toSelect = this.getToSelectOnRemoveOf(info);
        } else {
            assert (this.myVisibleInfos.contains(forcedSelectionTransfer)) : "Cannot find tab for selection transfer, tab=" + forcedSelectionTransfer;
            toSelect = forcedSelectionTransfer;
        }
        if (toSelect != null) {
            boolean clearSelection = info.equals(this.mySelectedInfo);
            this.processRemove(info, false);
            if (clearSelection) {
                this.mySelectedInfo = info;
            }
            this._setSelected(toSelect, transferFocus).doWhenProcessed(() -> this.removeDeferred().notifyWhenDone(result));
        } else {
            this.processRemove(info, true);
            this.removeDeferred().notifyWhenDone(result);
        }
        if (this.myVisibleInfos.isEmpty()) {
            this.removeDeferredNow();
        }
        this.revalidateAndRepaint(true);
        this.fireTabRemoved(info);
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(39);
        }
        return actionCallback;
    }

    private void processRemove(TabInfo info, boolean forcedNow) {
        this.remove(this.myInfo2Label.get(info));
        this.remove(this.myInfo2Toolbar.get(info));
        JComponent tabComponent = info.getComponent();
        if (!JBTabsImpl.isToDeferRemoveForLater(tabComponent) || forcedNow) {
            this.remove(tabComponent);
        } else {
            this.queueForRemove(tabComponent);
        }
        this.myVisibleInfos.remove(info);
        this.myHiddenInfos.remove(info);
        this.myInfo2Label.remove(info);
        this.myInfo2Page.remove(info);
        this.myInfo2Toolbar.remove(info);
        this.resetTabsCache();
        this.updateAll(false);
    }

    @Override
    @Nullable
    public TabInfo findInfo(Component component) {
        for (TabInfo each : this.getTabs()) {
            if (each.getComponent() != component) continue;
            return each;
        }
        return null;
    }

    @Override
    public TabInfo findInfo(MouseEvent event) {
        Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), this);
        return this._findInfo(point, false);
    }

    @Override
    public TabInfo findInfo(Object object) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            TabInfo each = this.getTabAt(i);
            Object eachObject = each.getObject();
            if (eachObject == null || !eachObject.equals(object)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    private TabInfo _findInfo(Point point, boolean labelsOnly) {
        Component component = this.findComponentAt(point);
        if (component == null) {
            return null;
        }
        while (component != this || component != null) {
            TabInfo info;
            if (component instanceof TabLabel) {
                return ((TabLabel)component).getInfo();
            }
            if (!labelsOnly && (info = this.findInfo(component)) != null) {
                return info;
            }
            if (component == null) break;
            component = component.getParent();
        }
        return null;
    }

    @Override
    public void removeAllTabs() {
        for (TabInfo each : this.getTabs()) {
            this.removeTab(each);
        }
    }

    private void updateContainer(boolean forced, boolean layoutNow) {
        if (this.myProject != null && !this.myProject.isOpen() && !this.myProject.isDefault()) {
            return;
        }
        for (TabInfo each : new ArrayList<TabInfo>(this.myVisibleInfos)) {
            JComponent eachComponent = each.getComponent();
            if (this.getSelectedInfo() == each && this.getSelectedInfo() != null) {
                this.unqueueFromRemove(eachComponent);
                Container parent = eachComponent.getParent();
                if (parent != null && parent != this) {
                    parent.remove(eachComponent);
                }
                if (eachComponent.getParent() != null) continue;
                this.add(eachComponent);
                continue;
            }
            if (eachComponent.getParent() == null) continue;
            if (JBTabsImpl.isToDeferRemoveForLater(eachComponent)) {
                this.queueForRemove(eachComponent);
                continue;
            }
            this.remove(eachComponent);
        }
        this.mySingleRowLayout.scrollSelectionInView();
        this.relayout(forced, layoutNow);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.unqueueFromRemove(comp);
        if (comp instanceof TabLabel) {
            ((TabLabel)comp).apply(this.myUiDecorator != null ? this.myUiDecorator.getDecoration() : ourDefaultDecorator.getDecoration());
        }
        super.addImpl(comp, constraints, index);
    }

    private static boolean isToDeferRemoveForLater(JComponent c) {
        return c.getRootPane() != null;
    }

    void relayout(boolean forced, boolean layoutNow) {
        if (!this.myForcedRelayout) {
            this.myForcedRelayout = forced;
        }
        this.revalidateAndRepaint(layoutNow);
    }

    public int getBorderThickness() {
        return this.myBorder.getThickness();
    }

    @Override
    @NotNull
    public JBTabs addTabMouseListener(@NotNull MouseListener listener2) {
        if (listener2 == null) {
            JBTabsImpl.$$$reportNull$$$0(40);
        }
        this.removeListeners();
        this.myTabMouseListeners.add(listener2);
        this.addListeners();
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(41);
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(42);
        }
        return jBTabsImpl;
    }

    private void addListeners() {
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            for (EventListener eachListener : this.myTabMouseListeners) {
                if (eachListener instanceof MouseListener) {
                    label.addMouseListener((MouseListener)eachListener);
                    continue;
                }
                if (eachListener instanceof MouseMotionListener) {
                    label.addMouseMotionListener((MouseMotionListener)eachListener);
                    continue;
                }
                assert (false);
            }
        }
    }

    private void removeListeners() {
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            for (EventListener eachListener : this.myTabMouseListeners) {
                if (eachListener instanceof MouseListener) {
                    label.removeMouseListener((MouseListener)eachListener);
                    continue;
                }
                if (eachListener instanceof MouseMotionListener) {
                    label.removeMouseMotionListener((MouseMotionListener)eachListener);
                    continue;
                }
                assert (false);
            }
        }
    }

    private void updateListeners() {
        this.removeListeners();
        this.addListeners();
    }

    @Override
    public JBTabs addListener(@NotNull TabsListener listener2) {
        if (listener2 == null) {
            JBTabsImpl.$$$reportNull$$$0(43);
        }
        this.myTabListeners.add(listener2);
        return this;
    }

    @Override
    public JBTabs setSelectionChangeHandler(JBTabs.SelectionChangeHandler handler) {
        this.mySelectionChangeHandler = handler;
        return this;
    }

    public void setFocused(boolean focused) {
        if (this.myFocused == focused) {
            return;
        }
        this.myFocused = focused;
        if (this.myPaintFocus) {
            this.repaint();
        }
    }

    @Override
    public int getIndexOf(@Nullable TabInfo tabInfo) {
        return this.getVisibleInfos().indexOf(tabInfo);
    }

    @Override
    public boolean isHideTabs() {
        return this.myHideTabs;
    }

    @Override
    public void setHideTabs(boolean hideTabs) {
        if (this.isHideTabs() == hideTabs) {
            return;
        }
        this.myHideTabs = hideTabs;
        this.relayout(true, false);
    }

    @Override
    public JBTabsPresentation setPaintBorder(int top, int left, int right, int bottom) {
        return this;
    }

    @Override
    public JBTabsPresentation setTabSidePaintBorder(int size) {
        return this;
    }

    @Override
    @NotNull
    public JBTabsPresentation setActiveTabFillIn(@Nullable Color color) {
        if (!JBTabsImpl.isChanged(this.myActiveTabFillIn, color)) {
            JBTabsImpl jBTabsImpl = this;
            if (jBTabsImpl == null) {
                JBTabsImpl.$$$reportNull$$$0(44);
            }
            return jBTabsImpl;
        }
        this.myActiveTabFillIn = color;
        this.revalidateAndRepaint(false);
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(45);
        }
        return jBTabsImpl;
    }

    private static boolean isChanged(Object oldObject, Object newObject) {
        return !Comparing.equal((Object)oldObject, (Object)newObject);
    }

    @Override
    @NotNull
    public JBTabsPresentation setTabLabelActionsAutoHide(boolean autoHide) {
        if (this.myTabLabelActionsAutoHide != autoHide) {
            this.myTabLabelActionsAutoHide = autoHide;
            this.revalidateAndRepaint(false);
        }
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(46);
        }
        return jBTabsImpl;
    }

    @Override
    public JBTabsPresentation setFocusCycle(boolean root) {
        this.setFocusCycleRoot(root);
        return this;
    }

    @Override
    public JBTabsPresentation setPaintFocus(boolean paintFocus) {
        this.myPaintFocus = paintFocus;
        return this;
    }

    protected boolean isNavigatable() {
        int selectedIndex = this.getVisibleInfos().indexOf(this.getSelectedInfo());
        return this.isNavigationVisible() && selectedIndex >= 0 && this.myNavigationActionsEnabled;
    }

    private JBTabsImpl navigatableParent() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JBTabsImpl) || !((JBTabsImpl)c).isNavigatable()) continue;
            return (JBTabsImpl)c;
        }
        return null;
    }

    private void selectFirstVisible() {
        if (!this.isNavigatable()) {
            return;
        }
        TabInfo select = this.getVisibleInfos().get(0);
        JComponent lastFocus = select.getLastFocusOwner();
        this.select(select, true);
        this.myNestedTabs.stream().filter(nestedTabs -> lastFocus == null || SwingUtilities.isDescendingFrom(lastFocus, nestedTabs)).forEach(nestedTabs -> nestedTabs.selectFirstVisible());
    }

    private void selectLastVisible() {
        if (!this.isNavigatable()) {
            return;
        }
        int last = this.getVisibleInfos().size() - 1;
        TabInfo select = this.getVisibleInfos().get(last);
        JComponent lastFocus = select.getLastFocusOwner();
        this.select(select, true);
        this.myNestedTabs.stream().filter(nestedTabs -> lastFocus == null || SwingUtilities.isDescendingFrom(lastFocus, nestedTabs)).forEach(nestedTabs -> nestedTabs.selectLastVisible());
    }

    private void disposePopupListener() {
        if (this.myActivePopup != null) {
            this.myActivePopup.removePopupMenuListener(this.myPopupListener);
            this.myActivePopup = null;
        }
    }

    @Override
    public JBTabsPresentation setSideComponentVertical(boolean vertical) {
        this.myHorizontalSide = !vertical;
        for (TabInfo each : this.myVisibleInfos) {
            each.getChangeSupport().firePropertyChange("actionGroup", "new1", "new2");
        }
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setSideComponentOnTabs(boolean onTabs) {
        this.mySideComponentOnTabs = onTabs;
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setSideComponentBefore(boolean before) {
        this.mySideComponentBefore = before;
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setSingleRow(boolean singleRow) {
        this.myLayout = singleRow ? this.mySingleRowLayout : this.myTableLayout;
        this.relayout(true, false);
        return this;
    }

    public int getSeparatorWidth() {
        return this.mySeparatorWidth;
    }

    public boolean useSmallLabels() {
        return false;
    }

    public boolean useBoldLabels() {
        return false;
    }

    @Override
    public boolean isSingleRow() {
        if (!NEW_TABS) {
            return this.getEffectiveLayout() == this.mySingleRowLayout;
        }
        return this.myTabsLayout.isSingleRow();
    }

    public boolean isSideComponentVertical() {
        return !this.myHorizontalSide;
    }

    public boolean isSideComponentOnTabs() {
        return this.mySideComponentOnTabs;
    }

    public boolean isSideComponentBefore() {
        return this.mySideComponentBefore;
    }

    public TabLayout getEffectiveLayout() {
        if (this.myLayout == this.myTableLayout && this.getTabsPosition() == JBTabsPosition.top) {
            return this.myTableLayout;
        }
        return this.mySingleRowLayout;
    }

    @Override
    public JBTabsPresentation setUiDecorator(@Nullable UiDecorator decorator) {
        this.myUiDecorator = decorator == null ? ourDefaultDecorator : decorator;
        this.applyDecoration();
        return this;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.applyDecoration();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        SwingUtilities.invokeLater(() -> {
            this.applyDecoration();
            this.revalidateAndRepaint(false);
        });
    }

    private void applyDecoration() {
        if (this.myUiDecorator != null) {
            UiDecorator.UiDecoration uiDecoration = this.myUiDecorator.getDecoration();
            for (TabLabel each : this.myInfo2Label.values()) {
                each.apply(uiDecoration);
            }
        }
        for (TabInfo each : this.getTabs()) {
            JBTabsImpl.adjust(each);
        }
        this.relayout(true, false);
    }

    private static void adjust(TabInfo each) {
        UIUtil.removeScrollBorder((Component)each.getComponent());
    }

    @Override
    public void sortTabs(Comparator<? super TabInfo> comparator) {
        Collections.sort(this.myVisibleInfos, comparator);
        this.relayout(true, false);
    }

    private boolean isRequestFocusOnLastFocusedComponent() {
        return this.myRequestFocusOnLastFocusedComponent;
    }

    @Override
    public JBTabsPresentation setRequestFocusOnLastFocusedComponent(boolean requestFocusOnLastFocusedComponent) {
        this.myRequestFocusOnLastFocusedComponent = requestFocusOnLastFocusedComponent;
        return this;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        Object value;
        if (dataId == null) {
            JBTabsImpl.$$$reportNull$$$0(47);
        }
        if (this.myDataProvider != null && (value = this.myDataProvider.getData(dataId)) != null) {
            return value;
        }
        if (QuickActionProvider.KEY.getName().equals(dataId)) {
            return this;
        }
        if (MorePopupAware.KEY.is(dataId)) {
            return this;
        }
        return NAVIGATION_ACTIONS_KEY.is(dataId) ? this : null;
    }

    @Override
    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        ActionGroup group;
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        TabInfo selection = this.getSelectedInfo();
        if (selection != null && (group = selection.getGroup()) != null) {
            AnAction[] children = group.getChildren(null);
            Collections.addAll(result, children);
        }
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            JBTabsImpl.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    @Override
    public DataProvider getDataProvider() {
        return this.myDataProvider;
    }

    @Override
    public JBTabsImpl setDataProvider(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            JBTabsImpl.$$$reportNull$$$0(49);
        }
        this.myDataProvider = dataProvider;
        return this;
    }

    static boolean isSelectionClick(MouseEvent e, boolean canBeQuick) {
        if ((e.getClickCount() == 1 || canBeQuick) && !e.isPopupTrigger()) {
            return e.getButton() == 1 && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown();
        }
        return false;
    }

    public Rectangle layout(JComponent c, Rectangle bounds) {
        Rectangle now = c.getBounds();
        if (!bounds.equals(now)) {
            c.setBounds(bounds);
        }
        c.doLayout();
        c.putClientProperty(LAYOUT_DONE, Boolean.TRUE);
        return bounds;
    }

    public Rectangle layout(JComponent c, int x, int y, int width, int height) {
        return this.layout(c, new Rectangle(x, y, width, height));
    }

    public static void resetLayout(JComponent c) {
        if (c == null) {
            return;
        }
        c.putClientProperty(LAYOUT_DONE, null);
        c.putClientProperty(STRETCHED_BY_WIDTH, null);
    }

    private void applyResetComponents() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JComponent jc;
            Component each = this.getComponent(i);
            if (!(each instanceof JComponent) || UIUtil.isClientPropertyTrue((Object)(jc = (JComponent)each), (Object)LAYOUT_DONE)) continue;
            this.layout(jc, new Rectangle(0, 0, 0, 0));
        }
    }

    @Override
    @NotNull
    public JBTabsPresentation setTabLabelActionsMouseDeadzone(TimedDeadzone.Length length) {
        this.myTabActionsMouseDeadzone = length;
        List<TabInfo> all = this.getTabs();
        for (TabInfo each : all) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            eachLabel.updateTabActions();
        }
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(50);
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JBTabsPresentation setTabsPosition(JBTabsPosition position) {
        this.myPosition = position;
        OnePixelDivider divider = this.mySplitter.getDivider();
        if (position.isSide() && divider.getParent() == null) {
            this.add((Component)((Object)divider));
        } else if (divider.getParent() == this && !position.isSide()) {
            this.remove((Component)((Object)divider));
        }
        this.relayout(true, false);
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(51);
        }
        return jBTabsImpl;
    }

    @Override
    public JBTabsPosition getTabsPosition() {
        return this.myPosition;
    }

    public TimedDeadzone.Length getTabActionsMouseDeadzone() {
        return this.myTabActionsMouseDeadzone;
    }

    @Override
    public JBTabsPresentation setTabDraggingEnabled(boolean enabled) {
        this.myTabDraggingEnabled = enabled;
        return this;
    }

    @Override
    public JBTabsPresentation setAlphabeticalMode(boolean alphabeticalMode) {
        this.myAlphabeticalMode = alphabeticalMode;
        return this;
    }

    @Override
    public JBTabsPresentation setSupportsCompression(boolean supportsCompression) {
        this.mySupportsCompression = supportsCompression;
        this.updateRowLayout();
        return this;
    }

    public boolean isTabDraggingEnabled() {
        return this.myTabDraggingEnabled;
    }

    void reallocate(TabInfo source, TabInfo target) {
        if (source == target || source == null || target == null) {
            return;
        }
        int targetIndex = this.myVisibleInfos.indexOf(target);
        this.myVisibleInfos.remove(source);
        this.myVisibleInfos.add(targetIndex, source);
        this.invalidate();
        this.relayout(true, true);
    }

    public boolean isHorizontalTabs() {
        return this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        TabInfo selected;
        if (info == null) {
            JBTabsImpl.$$$reportNull$$$0(52);
        }
        if ((selected = this.getSelectedInfo()) != null) {
            selected.putInfo(info);
        }
    }

    @Override
    public void resetDropOver(TabInfo tabInfo) {
        if (this.myDropInfo != null) {
            TabInfo dropInfo = this.myDropInfo;
            this.myDropInfo = null;
            this.myShowDropLocation = true;
            this.myForcedRelayout = true;
            this.setDropInfoIndex(-1);
            this.removeTab(dropInfo, null, false, true);
        }
    }

    @Override
    public Image startDropOver(TabInfo tabInfo, RelativePoint point) {
        this.myDropInfo = tabInfo;
        Point pointInMySpace = point.getPoint((Component)this);
        int index = NEW_TABS ? this.myTabsLayout.getDropIndexFor(pointInMySpace) : this.myLayout.getDropIndexFor(pointInMySpace);
        this.setDropInfoIndex(index);
        this.addTab(this.myDropInfo, index, true, true);
        TabLabel label = this.myInfo2Label.get(this.myDropInfo);
        Dimension size = label.getPreferredSize();
        label.setBounds(0, 0, size.width, size.height);
        BufferedImage img = UIUtil.createImage((Component)this, (int)size.width, (int)size.height, (int)2);
        Graphics2D g = img.createGraphics();
        label.paintOffscreen(g);
        g.dispose();
        this.relayout(true, false);
        return img;
    }

    @Override
    public void processDropOver(TabInfo over, RelativePoint point) {
        int index;
        Point pointInMySpace = point.getPoint((Component)this);
        int n = index = NEW_TABS ? this.myTabsLayout.getDropIndexFor(pointInMySpace) : this.myLayout.getDropIndexFor(pointInMySpace);
        if (index != this.getDropInfoIndex()) {
            this.setDropInfoIndex(index);
            this.relayout(true, false);
        }
    }

    @Override
    public int getDropInfoIndex() {
        return this.myDropInfoIndex;
    }

    @Override
    public boolean isEmptyVisible() {
        return this.myVisibleInfos.isEmpty();
    }

    @Override
    public void updateTabsLayout(TabsLayoutInfo newTabsLayoutInfo) {
        TabsLayout newTabsLayout = newTabsLayoutInfo.createTabsLayout(this.myTabsLayoutCallback);
        if (this.myTabsLayout != null) {
            this.removeMouseListener(this.myTabsLayoutMouseListener);
            this.removeMouseMotionListener(this.myTabsLayoutMouseMotionListener);
            this.removeMouseWheelListener(this.myTabsLayoutMouseWheelListener);
            Disposer.dispose((Disposable)this.myTabsLayout);
        }
        this.myTabsLayout = newTabsLayout;
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myTabsLayout);
        this.myTabsLayoutMouseListener = this.myTabsLayout.getMouseListener();
        if (this.myTabsLayoutMouseListener != null) {
            this.addMouseListener(this.myTabsLayoutMouseListener);
        }
        this.myTabsLayoutMouseMotionListener = this.myTabsLayout.getMouseMotionListener();
        if (this.myTabsLayoutMouseMotionListener != null) {
            this.addMouseMotionListener(this.myTabsLayoutMouseMotionListener);
        }
        this.myTabsLayoutMouseWheelListener = this.myTabsLayout.getMouseWheelListener();
        if (this.myTabsLayoutMouseWheelListener != null) {
            this.addMouseWheelListener(this.myTabsLayoutMouseWheelListener);
        }
    }

    @Deprecated
    public int getInterTabSpaceLength() {
        return this.getTabHGap();
    }

    public int getTabHGap() {
        return -this.myBorder.getThickness();
    }

    @Override
    public String toString() {
        return "JBTabs visible=" + this.myVisibleInfos + " selected=" + this.mySelectedInfo;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJBTabsImpl();
        }
        return this.accessibleContext;
    }

    @Deprecated
    public int getActiveTabUnderlineHeight() {
        return 0;
    }

    @Deprecated
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabInfo";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/impl/JBTabsImpl";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupGroup";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: 
            case 21: 
            case 25: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/impl/JBTabsImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addTab";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setPopupGroup";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "_setSelected";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "executeSelectionChange";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "requestFocus";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDeferred";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabAt";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "setToDrawBorderIfTabsHidden";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getJBTabs";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTab";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "addTabMouseListener";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "setActiveTabFillIn";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabLabelActionsAutoHide";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabLabelActionsMouseDeadzone";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabsPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addNestedTabs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createMenuItem";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 51: {
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setPopupGroup";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "executeSelectionChange";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fireTabRemoved";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addTabMouseListener";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setDataProvider";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    protected static class ShapeInfo {
        public ShapeTransform path;
        public ShapeTransform fillPath;
        public ShapeTransform labelPath;
        public int labelBottomY;
        public int labelTopY;
        public int labelLeftX;
        public int labelRightX;
        public Insets insets;
        public Color from;
        public Color to;
    }

    private class AccessibleTabPage
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent,
    AccessibleAction {
        @NotNull
        private final JBTabsImpl myParent;
        @NotNull
        private final TabInfo myTabInfo;
        private final Component myComponent;

        AccessibleTabPage(TabInfo tabInfo) {
            if (tabInfo == null) {
                AccessibleTabPage.$$$reportNull$$$0(0);
            }
            this.myParent = JBTabsImpl.this;
            this.myTabInfo = tabInfo;
            this.myComponent = tabInfo.getComponent();
            this.setAccessibleParent(this.myParent);
            this.initAccessibleContext();
        }

        @NotNull
        private TabInfo getTabInfo() {
            TabInfo tabInfo = this.myTabInfo;
            if (tabInfo == null) {
                AccessibleTabPage.$$$reportNull$$$0(1);
            }
            return tabInfo;
        }

        private int getTabIndex() {
            return JBTabsImpl.this.getIndexOf(this.myTabInfo);
        }

        private TabLabel getTabLabel() {
            return JBTabsImpl.this.myInfo2Label.get(this.getTabInfo());
        }

        void initAccessibleContext() {
            AccessibleContext ac;
            if (JBTabsImpl.this.accessibleContext != null && this.myComponent instanceof Accessible && (ac = this.myComponent.getAccessibleContext()) != null) {
                ac.setAccessibleParent(this);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        @Override
        public String getAccessibleName() {
            TabLabel label;
            String name = this.accessibleName;
            if (name == null) {
                name = (String)JBTabsImpl.this.getClientProperty("AccessibleName");
            }
            if (name == null && (label = this.getTabLabel()) != null && label.getAccessibleContext() != null) {
                name = label.getAccessibleContext().getAccessibleName();
            }
            if (name == null) {
                name = super.getAccessibleName();
            }
            return name;
        }

        @Override
        public String getAccessibleDescription() {
            TabLabel label;
            String description = this.accessibleDescription;
            if (description == null) {
                description = (String)JBTabsImpl.this.getClientProperty("AccessibleDescription");
            }
            if (description == null && (label = this.getTabLabel()) != null && label.getAccessibleContext() != null) {
                description = label.getAccessibleContext().getAccessibleDescription();
            }
            if (description == null) {
                description = super.getAccessibleDescription();
            }
            return description;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = this.myParent.getAccessibleContext().getAccessibleStateSet();
            states.add(AccessibleState.SELECTABLE);
            TabInfo info = this.myParent.getSelectedInfo();
            if (info == this.getTabInfo()) {
                states.add(AccessibleState.SELECTED);
            }
            return states;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return this.getTabIndex();
        }

        @Override
        public int getAccessibleChildrenCount() {
            return JBTabsImpl.this.getSelectedInfo() == this.getTabInfo() && this.myComponent instanceof Accessible ? 1 : 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return JBTabsImpl.this.getSelectedInfo() == this.getTabInfo() && this.myComponent instanceof Accessible ? (Accessible)((Object)this.myComponent) : null;
        }

        @Override
        public Locale getLocale() {
            return JBTabsImpl.this.getLocale();
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public Color getBackground() {
            return JBTabsImpl.this.getBackground();
        }

        @Override
        public void setBackground(Color c) {
            JBTabsImpl.this.setBackground(c);
        }

        @Override
        public Color getForeground() {
            return JBTabsImpl.this.getForeground();
        }

        @Override
        public void setForeground(Color c) {
            JBTabsImpl.this.setForeground(c);
        }

        @Override
        public Cursor getCursor() {
            return JBTabsImpl.this.getCursor();
        }

        @Override
        public void setCursor(Cursor c) {
            JBTabsImpl.this.setCursor(c);
        }

        @Override
        public Font getFont() {
            return JBTabsImpl.this.getFont();
        }

        @Override
        public void setFont(Font f) {
            JBTabsImpl.this.setFont(f);
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            return JBTabsImpl.this.getFontMetrics(f);
        }

        @Override
        public boolean isEnabled() {
            return this.getTabInfo().isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
            this.getTabInfo().setEnabled(b);
        }

        @Override
        public boolean isVisible() {
            return !this.getTabInfo().isHidden();
        }

        @Override
        public void setVisible(boolean b) {
            this.getTabInfo().setHidden(!b);
        }

        @Override
        public boolean isShowing() {
            return JBTabsImpl.this.isShowing();
        }

        @Override
        public boolean contains(Point p) {
            Rectangle r = this.getBounds();
            return r.contains(p);
        }

        @Override
        public Point getLocationOnScreen() {
            Point parentLocation = JBTabsImpl.this.getLocationOnScreen();
            Point componentLocation = this.getLocation();
            componentLocation.translate(parentLocation.x, parentLocation.y);
            return componentLocation;
        }

        @Override
        public Point getLocation() {
            Rectangle r = this.getBounds();
            return new Point(r.x, r.y);
        }

        @Override
        public void setLocation(Point p) {
        }

        @Override
        public Rectangle getBounds() {
            return this.getTabLabel().getBounds();
        }

        @Override
        public void setBounds(Rectangle r) {
        }

        @Override
        public Dimension getSize() {
            Rectangle r = this.getBounds();
            return new Dimension(r.width, r.height);
        }

        @Override
        public void setSize(Dimension d) {
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            return this.myComponent instanceof Accessible ? (Accessible)((Object)this.myComponent) : null;
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public void addFocusListener(FocusListener l) {
        }

        @Override
        public void removeFocusListener(FocusListener l) {
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleIcon accessibleIcon = null;
            if (this.getTabInfo().getIcon() instanceof ImageIcon) {
                AccessibleContext ac = ((ImageIcon)this.getTabInfo().getIcon()).getAccessibleContext();
                accessibleIcon = (AccessibleIcon)((Object)ac);
            }
            if (accessibleIcon != null) {
                AccessibleIcon[] returnIcons = new AccessibleIcon[]{accessibleIcon};
                return returnIcons;
            }
            return null;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            if (i != 0) {
                return null;
            }
            return "Activate";
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (i != 0) {
                return false;
            }
            JBTabsImpl.this.select(this.getTabInfo(), true);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tabs/impl/JBTabsImpl$AccessibleTabPage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tabs/impl/JBTabsImpl$AccessibleTabPage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class AccessibleJBTabsImpl
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        AccessibleJBTabsImpl() {
            super(JBTabsImpl.this);
            this.getAccessibleComponent();
            JBTabsImpl.this.addListener(new TabsListener(){

                @Override
                public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    AccessibleJBTabsImpl.this.firePropertyChange("AccessibleSelection", null, null);
                }
            });
        }

        @Override
        public String getAccessibleName() {
            TabLabel selectedLabel;
            String name = this.accessibleName;
            if (name == null) {
                name = (String)JBTabsImpl.this.getClientProperty("AccessibleName");
            }
            if (name == null && (selectedLabel = JBTabsImpl.this.getSelectedLabel()) != null && selectedLabel.getAccessibleContext() != null) {
                name = selectedLabel.getAccessibleContext().getAccessibleName();
            }
            if (name == null) {
                name = super.getAccessibleName();
            }
            return name;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            Accessible accessibleChild = super.getAccessibleChild(i);
            if (accessibleChild instanceof TabLabel) {
                TabLabel label = (TabLabel)accessibleChild;
                return (Accessible)JBTabsImpl.this.myInfo2Page.get(label.getInfo());
            }
            return accessibleChild;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            return JBTabsImpl.this.getSelectedInfo() == null ? 0 : 1;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            if (JBTabsImpl.this.getSelectedInfo() == null) {
                return null;
            }
            return (Accessible)JBTabsImpl.this.myInfo2Page.get(JBTabsImpl.this.getSelectedInfo());
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            return i == JBTabsImpl.this.getIndexOf(JBTabsImpl.this.getSelectedInfo());
        }

        @Override
        public void addAccessibleSelection(int i) {
            TabInfo info = JBTabsImpl.this.getTabAt(i);
            JBTabsImpl.this.select(info, false);
        }

        @Override
        public void removeAccessibleSelection(int i) {
        }

        @Override
        public void clearAccessibleSelection() {
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    private static class DefaultDecorator
    implements UiDecorator {
        private DefaultDecorator() {
        }

        @Override
        @NotNull
        public UiDecorator.UiDecoration getDecoration() {
            return new UiDecorator.UiDecoration(null, (Insets)new JBInsets(5, 12, 5, 12));
        }
    }

    private static class SelectPreviousAction
    extends BaseNavigationAction {
        private SelectPreviousAction(JBTabsImpl tabs, @NotNull Disposable parentDisposable) {
            if (parentDisposable == null) {
                SelectPreviousAction.$$$reportNull$$$0(0);
            }
            super("PreviousTab", tabs, parentDisposable);
        }

        @Override
        protected void _update(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            e.getPresentation().setEnabled(tabs.findEnabledBackward(selectedIndex, true) != null);
        }

        @Override
        protected boolean borderIndex(List<TabInfo> infos, int index) {
            return index == 0;
        }

        @Override
        protected void _actionPerformed(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            TabInfo tabInfo = tabs.findEnabledBackward(selectedIndex, true);
            if (tabInfo != null) {
                JComponent lastFocus = tabInfo.getLastFocusOwner();
                tabs.select(tabInfo, true);
                tabs.myNestedTabs.stream().filter(nestedTabs -> lastFocus == null || SwingUtilities.isDescendingFrom(lastFocus, nestedTabs)).forEach(nestedTabs -> ((JBTabsImpl)nestedTabs).selectLastVisible());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ui/tabs/impl/JBTabsImpl$SelectPreviousAction", "<init>"));
        }
    }

    private static final class SelectNextAction
    extends BaseNavigationAction {
        private SelectNextAction(JBTabsImpl tabs, @NotNull Disposable parentDisposable) {
            if (parentDisposable == null) {
                SelectNextAction.$$$reportNull$$$0(0);
            }
            super("NextTab", tabs, parentDisposable);
        }

        @Override
        protected void _update(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            e.getPresentation().setEnabled(tabs.findEnabledForward(selectedIndex, true) != null);
        }

        @Override
        protected boolean borderIndex(List<TabInfo> infos, int index) {
            return index == infos.size() - 1;
        }

        @Override
        protected void _actionPerformed(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            TabInfo tabInfo = tabs.findEnabledForward(selectedIndex, true);
            if (tabInfo != null) {
                JComponent lastFocus = tabInfo.getLastFocusOwner();
                tabs.select(tabInfo, true);
                tabs.myNestedTabs.stream().filter(nestedTabs -> lastFocus == null || SwingUtilities.isDescendingFrom(lastFocus, nestedTabs)).forEach(nestedTabs -> ((JBTabsImpl)nestedTabs).selectFirstVisible());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ui/tabs/impl/JBTabsImpl$SelectNextAction", "<init>"));
        }
    }

    private static abstract class BaseNavigationAction
    extends AnAction {
        private final ShadowAction myShadow;
        @NotNull
        private final ActionManager myActionManager;
        private final JBTabsImpl myTabs;

        BaseNavigationAction(@NotNull String copyFromID, @NotNull JBTabsImpl tabs, @NotNull Disposable parentDisposable) {
            if (copyFromID == null) {
                BaseNavigationAction.$$$reportNull$$$0(0);
            }
            if (tabs == null) {
                BaseNavigationAction.$$$reportNull$$$0(1);
            }
            if (parentDisposable == null) {
                BaseNavigationAction.$$$reportNull$$$0(2);
            }
            this.myActionManager = ActionManager.getInstance();
            this.myTabs = tabs;
            this.myShadow = new ShadowAction(this, this.myActionManager.getAction(copyFromID), tabs, parentDisposable);
            this.setEnabledInModalContext(true);
        }

        @Override
        public final void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BaseNavigationAction.$$$reportNull$$$0(3);
            }
            JBTabsImpl tabs = (JBTabsImpl)e.getData(JBTabsEx.NAVIGATION_ACTIONS_KEY);
            e.getPresentation().setVisible(tabs != null);
            if (tabs == null) {
                return;
            }
            tabs = this.findNavigatableTabs(tabs);
            e.getPresentation().setEnabled(tabs != null);
            if (tabs != null) {
                this._update(e, tabs, tabs.getVisibleInfos().indexOf(tabs.getSelectedInfo()));
            }
        }

        @Nullable
        JBTabsImpl findNavigatableTabs(JBTabsImpl tabs) {
            if (tabs == null || tabs != this.myTabs) {
                return null;
            }
            if (tabs.isNavigatable()) {
                return tabs;
            }
            for (Container c = tabs.getParent(); c != null; c = c.getParent()) {
                if (!(c instanceof JBTabsImpl) || !((JBTabsImpl)c).isNavigatable()) continue;
                return (JBTabsImpl)c;
            }
            return null;
        }

        public void reconnect(String actionId) {
            this.myShadow.reconnect(this.myActionManager.getAction(actionId));
        }

        protected abstract void _update(AnActionEvent var1, JBTabsImpl var2, int var3);

        @Override
        public final void actionPerformed(@NotNull AnActionEvent e) {
            int index;
            if (e == null) {
                BaseNavigationAction.$$$reportNull$$$0(4);
            }
            JBTabsImpl tabs = (JBTabsImpl)e.getData(JBTabsEx.NAVIGATION_ACTIONS_KEY);
            if ((tabs = this.findNavigatableTabs(tabs)) == null) {
                return;
            }
            while (true) {
                List<TabInfo> infos;
                if ((index = (infos = tabs.getVisibleInfos()).indexOf(tabs.getSelectedInfo())) == -1) {
                    return;
                }
                if (!this.borderIndex(infos, index) || tabs.navigatableParent() == null) break;
                tabs = tabs.navigatableParent();
            }
            this._actionPerformed(e, tabs, index);
        }

        protected abstract boolean borderIndex(List<TabInfo> var1, int var2);

        protected abstract void _actionPerformed(AnActionEvent var1, JBTabsImpl var2, int var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copyFromID";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/tabs/impl/JBTabsImpl$BaseNavigationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Max {
        final Dimension myLabel = new Dimension();
        final Dimension myToolbar = new Dimension();

        private Max() {
        }
    }

    public static class Toolbar
    extends JPanel {
        public Toolbar(JBTabsImpl tabs, TabInfo info) {
            this.setLayout(new BorderLayout());
            ActionGroup group = info.getGroup();
            JComponent side = info.getSideComponent();
            if (group != null) {
                String place = info.getPlace();
                ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(place != null ? place : "JBTabs", group, tabs.myHorizontalSide);
                toolbar.setTargetComponent(info.getActionsContextComponent());
                JComponent actionToolbar = toolbar.getComponent();
                this.add((Component)actionToolbar, "Center");
            }
            if (side != null) {
                if (group != null) {
                    this.add((Component)side, "East");
                } else {
                    this.add((Component)side, "Center");
                }
            }
            ((JBTreeTraverser)UIUtil.uiTraverser((Component)this).filter(c -> !UIUtil.canDisplayFocusedState((Component)c))).forEach(c -> c.setFocusable(false));
        }

        public boolean isEmpty() {
            return this.getComponentCount() == 0;
        }
    }

    @Deprecated
    final class TabActionsAutoHideListener
    extends MouseMotionAdapter
    implements Weighted {
        private TabLabel myCurrentOverLabel;
        private Point myLastOverPoint;

        TabActionsAutoHideListener() {
        }

        @Override
        public double getWeight() {
            return 1.0;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!JBTabsImpl.this.myTabLabelActionsAutoHide) {
                return;
            }
            this.myLastOverPoint = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), JBTabsImpl.this);
            this.processMouseOver();
        }

        void processMouseOver() {
            TabLabel label;
            if (!JBTabsImpl.this.myTabLabelActionsAutoHide) {
                return;
            }
            if (this.myLastOverPoint == null) {
                return;
            }
            if (this.myLastOverPoint.x >= 0 && this.myLastOverPoint.x < JBTabsImpl.this.getWidth() && this.myLastOverPoint.y > 0 && this.myLastOverPoint.y < JBTabsImpl.this.getHeight() && (label = JBTabsImpl.this.myInfo2Label.get(JBTabsImpl.this._findInfo(this.myLastOverPoint, true))) != null) {
                if (this.myCurrentOverLabel != null) {
                    this.myCurrentOverLabel.toggleShowActions(false);
                }
                label.toggleShowActions(true);
                this.myCurrentOverLabel = label;
                return;
            }
            if (this.myCurrentOverLabel != null) {
                this.myCurrentOverLabel.toggleShowActions(false);
                this.myCurrentOverLabel = null;
            }
        }
    }
}

