/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationDependenciesBuildOperationType;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.util.CollectionUtils;

class ResolveConfigurationResolutionBuildOperationDetails
implements ResolveConfigurationDependenciesBuildOperationType.Details,
CustomOperationTraceSerialization {
    private final String configurationName;
    private final boolean isScriptConfiguration;
    private final String configurationDescription;
    private final String buildPath;
    private final String projectPath;
    private final boolean isConfigurationVisible;
    private final boolean isConfigurationTransitive;
    private final List<ResolveConfigurationDependenciesBuildOperationType.Repository> repositories;

    ResolveConfigurationResolutionBuildOperationDetails(String configurationName, boolean isScriptConfiguration, @Nullable String configurationDescription, String buildPath, @Nullable String projectPath, boolean isConfigurationVisible, boolean isConfigurationTransitive, List<ResolutionAwareRepository> repositories) {
        this.configurationName = configurationName;
        this.isScriptConfiguration = isScriptConfiguration;
        this.configurationDescription = configurationDescription;
        this.buildPath = buildPath;
        this.projectPath = projectPath;
        this.isConfigurationVisible = isConfigurationVisible;
        this.isConfigurationTransitive = isConfigurationTransitive;
        this.repositories = RepositoryImpl.transform(repositories);
    }

    @Override
    public String getConfigurationName() {
        return this.configurationName;
    }

    @Override
    @Nullable
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    public boolean isScriptConfiguration() {
        return this.isScriptConfiguration;
    }

    @Override
    public String getConfigurationDescription() {
        return this.configurationDescription;
    }

    @Override
    public String getBuildPath() {
        return this.buildPath;
    }

    @Override
    public boolean isConfigurationVisible() {
        return this.isConfigurationVisible;
    }

    @Override
    public boolean isConfigurationTransitive() {
        return this.isConfigurationTransitive;
    }

    @Override
    public List<ResolveConfigurationDependenciesBuildOperationType.Repository> getRepositories() {
        return this.repositories;
    }

    @Override
    public Object getCustomOperationTraceSerializableModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("configurationName", this.configurationName);
        model.put("scriptConfiguration", this.isScriptConfiguration);
        model.put("configurationDescription", this.configurationDescription);
        model.put("buildPath", this.buildPath);
        model.put("projectPath", this.projectPath);
        model.put("configurationVisible", this.isConfigurationVisible);
        model.put("configurationTransitive", this.isConfigurationTransitive);
        ImmutableList.Builder repoBuilder = new ImmutableList.Builder();
        for (ResolveConfigurationDependenciesBuildOperationType.Repository repository : this.repositories) {
            ImmutableMap.Builder repoMapBuilder = new ImmutableMap.Builder();
            repoMapBuilder.put((Object)"id", (Object)repository.getId());
            repoMapBuilder.put((Object)"name", (Object)repository.getName());
            repoMapBuilder.put((Object)"type", (Object)repository.getType());
            ImmutableMap.Builder propertiesMapBuilder = new ImmutableMap.Builder();
            for (Map.Entry<String, ?> property : repository.getProperties().entrySet()) {
                String propertyValue;
                if (property.getValue() instanceof Collection) {
                    ImmutableList.Builder listBuilder = new ImmutableList.Builder();
                    for (Object inner : (Collection)property.getValue()) {
                        this.doSerialize(inner, (ImmutableList.Builder<Object>)listBuilder);
                    }
                    propertyValue = listBuilder.build();
                } else {
                    propertyValue = property.getValue() instanceof File ? ((File)property.getValue()).getAbsolutePath() : (property.getValue() instanceof URI ? ((URI)property.getValue()).toASCIIString() : property.getValue());
                }
                propertiesMapBuilder.put((Object)property.getKey(), (Object)propertyValue);
            }
            repoMapBuilder.put((Object)"properties", (Object)propertiesMapBuilder.build());
            repoBuilder.add((Object)repoMapBuilder.build());
        }
        model.put("repositories", repoBuilder.build());
        return model;
    }

    private void doSerialize(Object value, ImmutableList.Builder<Object> listBuilder) {
        if (value instanceof File) {
            listBuilder.add((Object)((File)value).getAbsolutePath());
        } else if (value instanceof URI) {
            listBuilder.add((Object)((URI)value).toASCIIString());
        } else {
            listBuilder.add(value);
        }
    }

    private static class RepositoryImpl
    implements ResolveConfigurationDependenciesBuildOperationType.Repository {
        private final RepositoryDescriptor descriptor;

        private static List<ResolveConfigurationDependenciesBuildOperationType.Repository> transform(List<ResolutionAwareRepository> repositories) {
            return CollectionUtils.collect(repositories, new Transformer<ResolveConfigurationDependenciesBuildOperationType.Repository, ResolutionAwareRepository>(){

                @Override
                public ResolveConfigurationDependenciesBuildOperationType.Repository transform(ResolutionAwareRepository repository) {
                    return new RepositoryImpl(repository.getDescriptor());
                }
            });
        }

        private RepositoryImpl(RepositoryDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public String getId() {
            return this.descriptor.name;
        }

        @Override
        public String getType() {
            return this.descriptor.getType().name();
        }

        @Override
        public String getName() {
            return this.descriptor.name;
        }

        @Override
        public Map<String, ?> getProperties() {
            return this.descriptor.getProperties();
        }
    }
}

