/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.util.Map;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataDetailsAdapter;
import org.gradle.api.internal.artifacts.repositories.resolver.DependencyConstraintMetadataImpl;
import org.gradle.api.internal.artifacts.repositories.resolver.DirectDependencyMetadataImpl;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ivy.IvyModuleResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

class WrappingComponentMetadataContext
implements ComponentMetadataContext {
    private final ModuleComponentResolveMetadata metadata;
    private final Instantiator instantiator;
    private final NotationParser<Object, DirectDependencyMetadataImpl> dependencyMetadataNotationParser;
    private final NotationParser<Object, DependencyConstraintMetadataImpl> dependencyConstraintMetadataNotationParser;
    private final NotationParser<Object, ComponentIdentifier> componentIdentifierParser;
    private final PlatformSupport platformSupport;
    private MutableModuleComponentResolveMetadata mutableMetadata;
    private ComponentMetadataDetails details;

    public WrappingComponentMetadataContext(ModuleComponentResolveMetadata metadata, Instantiator instantiator, NotationParser<Object, DirectDependencyMetadataImpl> dependencyMetadataNotationParser, NotationParser<Object, DependencyConstraintMetadataImpl> dependencyConstraintMetadataNotationParser, NotationParser<Object, ComponentIdentifier> componentIdentifierParser, PlatformSupport platformSupport) {
        this.metadata = metadata;
        this.instantiator = instantiator;
        this.dependencyMetadataNotationParser = dependencyMetadataNotationParser;
        this.dependencyConstraintMetadataNotationParser = dependencyConstraintMetadataNotationParser;
        this.componentIdentifierParser = componentIdentifierParser;
        this.platformSupport = platformSupport;
    }

    @Override
    public <T> T getDescriptor(Class<T> descriptorClass) {
        if (IvyModuleDescriptor.class.isAssignableFrom(descriptorClass) && this.metadata instanceof IvyModuleResolveMetadata) {
            IvyModuleResolveMetadata ivyMetadata = (IvyModuleResolveMetadata)this.metadata;
            return descriptorClass.cast(new DefaultIvyModuleDescriptor((Map<NamespaceId, String>)ivyMetadata.getExtraAttributes(), ivyMetadata.getBranch(), ivyMetadata.getStatus()));
        }
        return null;
    }

    @Override
    public ComponentMetadataDetails getDetails() {
        this.createMutableMetadataIfNeeded();
        if (this.details == null) {
            this.details = this.instantiator.newInstance(ComponentMetadataDetailsAdapter.class, this.mutableMetadata, this.instantiator, this.dependencyMetadataNotationParser, this.dependencyConstraintMetadataNotationParser, this.componentIdentifierParser, this.platformSupport);
        }
        return this.details;
    }

    MutableModuleComponentResolveMetadata getMutableMetadata() {
        this.createMutableMetadataIfNeeded();
        return this.mutableMetadata;
    }

    private void createMutableMetadataIfNeeded() {
        if (this.mutableMetadata == null) {
            this.mutableMetadata = this.metadata.asMutable();
        }
    }
}

