/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification;

import java.io.File;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.invocation.Gradle;

public interface DependencyVerificationOverride {
    public static final DependencyVerificationOverride NO_VERIFICATION = new DependencyVerificationOverride(){

        @Override
        public ModuleComponentRepository overrideDependencyVerification(ModuleComponentRepository original) {
            return original;
        }
    };

    public static File dependencyVerificationsFile(File buildDirectory) {
        File gradleDir = DependencyVerificationOverride.ensureGradleDirExists(buildDirectory);
        return new File(gradleDir, "verification-metadata.xml");
    }

    public static File ensureGradleDirExists(File buildDirectory) {
        File gradleDir = new File(buildDirectory, "gradle");
        if (!gradleDir.exists()) {
            gradleDir.mkdirs();
        }
        return gradleDir;
    }

    public ModuleComponentRepository overrideDependencyVerification(ModuleComponentRepository var1);

    default public void buildFinished(Gradle gradle) {
    }

    default public void artifactsAccessed(String displayName) {
    }

    default public ResolvedArtifactResult verifiedArtifact(ResolvedArtifactResult artifact) {
        return artifact;
    }
}

