/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.LocalComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ShadowedCapability;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class DefaultLocalComponentMetadataBuilder
implements LocalComponentMetadataBuilder {
    private final LocalConfigurationMetadataBuilder configurationMetadataBuilder;

    public DefaultLocalComponentMetadataBuilder(LocalConfigurationMetadataBuilder configurationMetadataBuilder) {
        this.configurationMetadataBuilder = configurationMetadataBuilder;
    }

    @Override
    public BuildableLocalConfigurationMetadata addConfiguration(BuildableLocalComponentMetadata metaData, ConfigurationInternal configuration) {
        BuildableLocalConfigurationMetadata configurationMetadata = this.createConfiguration(metaData, configuration);
        metaData.addDependenciesAndExcludesForConfiguration(configuration, this.configurationMetadataBuilder);
        OutgoingVariant outgoingVariant = configuration.convertToOutgoingVariant();
        metaData.addArtifacts(configuration.getName(), outgoingVariant.getArtifacts());
        for (OutgoingVariant outgoingVariant2 : outgoingVariant.getChildren()) {
            metaData.addVariant(configuration.getName(), outgoingVariant2);
        }
        return configurationMetadata;
    }

    private BuildableLocalConfigurationMetadata createConfiguration(BuildableLocalComponentMetadata metaData, ConfigurationInternal configuration) {
        configuration.preventFromFurtherMutation();
        ImmutableSet<String> hierarchy = Configurations.getNames(configuration.getHierarchy());
        ImmutableSet<String> extendsFrom = Configurations.getNames(configuration.getExtendsFrom());
        ImmutableCapabilities capabilities = DefaultLocalComponentMetadataBuilder.asImmutable(Configurations.collectCapabilities(configuration, Sets.newHashSet(), Sets.newHashSet()));
        return metaData.addConfiguration(configuration.getName(), configuration.getDescription(), (Set<String>)extendsFrom, hierarchy, configuration.isVisible(), configuration.isTransitive(), configuration.getAttributes().asImmutable(), configuration.isCanBeConsumed(), configuration.getConsumptionAlternatives(), configuration.isCanBeResolved(), capabilities);
    }

    private static ImmutableCapabilities asImmutable(Collection<? extends Capability> descriptors) {
        if (descriptors.isEmpty()) {
            return ImmutableCapabilities.EMPTY;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Capability capability : descriptors) {
            if (capability instanceof ImmutableCapability) {
                builder.add((Object)((ImmutableCapability)capability));
                continue;
            }
            if (capability instanceof ShadowedCapability) {
                builder.add((Object)((ShadowedCapability)capability));
                continue;
            }
            builder.add((Object)new ImmutableCapability(capability.getGroup(), capability.getName(), capability.getVersion()));
        }
        return ImmutableCapabilities.of((List<? extends Capability>)builder.build());
    }
}

