/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.IvyDependencyDescriptorFactory;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.util.CollectionUtils;

public abstract class AbstractIvyDependencyDescriptorFactory
implements IvyDependencyDescriptorFactory {
    private ExcludeRuleConverter excludeRuleConverter;

    public AbstractIvyDependencyDescriptorFactory(ExcludeRuleConverter excludeRuleConverter) {
        this.excludeRuleConverter = excludeRuleConverter;
    }

    private String getExtension(DependencyArtifact artifact) {
        return artifact.getExtension() != null ? artifact.getExtension() : artifact.getType();
    }

    protected List<ExcludeMetadata> convertExcludeRules(String configuration, Set<ExcludeRule> excludeRules) {
        return CollectionUtils.collect(excludeRules, new Transformer<ExcludeMetadata, ExcludeRule>(){

            @Override
            public ExcludeMetadata transform(ExcludeRule excludeRule) {
                return AbstractIvyDependencyDescriptorFactory.this.excludeRuleConverter.convertExcludeRule(excludeRule);
            }
        });
    }

    protected List<IvyArtifactName> convertArtifacts(Set<DependencyArtifact> dependencyArtifacts) {
        if (dependencyArtifacts.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder names = ImmutableList.builder();
        for (DependencyArtifact dependencyArtifact : dependencyArtifacts) {
            DefaultIvyArtifactName name = new DefaultIvyArtifactName(dependencyArtifact.getName(), dependencyArtifact.getType(), this.getExtension(dependencyArtifact), dependencyArtifact.getClassifier());
            names.add((Object)name);
        }
        return names.build();
    }
}

