/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.MavenRepositoryContentDescriptor;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.DefaultRepositoryContentDescriptor;
import org.gradle.internal.Actions;

class DefaultMavenRepositoryContentDescriptor
extends DefaultRepositoryContentDescriptor
implements MavenRepositoryContentDescriptor {
    private boolean snapshots = true;
    private boolean releases = true;

    DefaultMavenRepositoryContentDescriptor() {
    }

    @Override
    public void releasesOnly() {
        this.snapshots = false;
        this.releases = true;
    }

    @Override
    public void snapshotsOnly() {
        this.snapshots = true;
        this.releases = false;
    }

    @Override
    public Action<? super ArtifactResolutionDetails> toContentFilter() {
        Action<? super ArtifactResolutionDetails> filter = super.toContentFilter();
        if (!this.snapshots || !this.releases) {
            Action<ArtifactResolutionDetails> action = new Action<ArtifactResolutionDetails>(){

                @Override
                public void execute(ArtifactResolutionDetails details) {
                    if (!details.isVersionListing()) {
                        String version = details.getComponentId().getVersion();
                        if (DefaultMavenRepositoryContentDescriptor.this.snapshots && !version.endsWith("-SNAPSHOT")) {
                            details.notFound();
                            return;
                        }
                        if (DefaultMavenRepositoryContentDescriptor.this.releases && version.endsWith("-SNAPSHOT")) {
                            details.notFound();
                            return;
                        }
                    }
                }
            };
            if (filter == null) {
                return action;
            }
            return Actions.composite(filter, action);
        }
        return filter;
    }
}

