/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.verification.model.ArtifactVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.Checksum;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.api.internal.artifacts.verification.model.ComponentVerificationMetadata;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;

public class DependencyVerifier {
    private final Map<ComponentIdentifier, ComponentVerificationMetadata> verificationMetadata;
    private final Cache<File, Optional<VerificationFailure>> verificationCache = CacheBuilder.newBuilder().weakKeys().weakValues().build();

    DependencyVerifier(Map<ComponentIdentifier, ComponentVerificationMetadata> verificationMetadata) {
        this.verificationMetadata = ImmutableMap.copyOf(verificationMetadata);
    }

    public void verify(BuildOperationExecutor buildOperationExecutor, ChecksumService checksumService, ModuleComponentArtifactIdentifier foundArtifact, File file, Action<VerificationFailure> onFailure) {
        try {
            Optional verificationFailure = (Optional)this.verificationCache.get((Object)file, () -> this.performVerification(buildOperationExecutor, foundArtifact, checksumService, file));
            verificationFailure.ifPresent(f -> onFailure.execute((VerificationFailure)f));
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private Optional<VerificationFailure> performVerification(BuildOperationExecutor buildOperationExecutor, final ModuleComponentArtifactIdentifier foundArtifact, final ChecksumService checksumService, final File file) {
        return buildOperationExecutor.call(new CallableBuildOperation<Optional<VerificationFailure>>(){

            @Override
            public Optional<VerificationFailure> call(BuildOperationContext context) {
                if (!file.exists()) {
                    return VerificationFailure.OPT_DELETED;
                }
                return DependencyVerifier.this.doVerifyArtifact(foundArtifact, checksumService, file);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Verifying dependency " + foundArtifact);
            }
        });
    }

    private Optional<VerificationFailure> doVerifyArtifact(ModuleComponentArtifactIdentifier foundArtifact, ChecksumService checksumService, File file) {
        AtomicReference failure = new AtomicReference();
        ComponentVerificationMetadata componentVerification = this.verificationMetadata.get(foundArtifact.getComponentIdentifier());
        if (componentVerification != null) {
            String foundArtifactFileName = foundArtifact.getFileName();
            List<ArtifactVerificationMetadata> verifications = componentVerification.getArtifactVerifications();
            for (ArtifactVerificationMetadata verification : verifications) {
                String verifiedArtifact = verification.getArtifactName();
                if (!verifiedArtifact.equals(foundArtifactFileName)) continue;
                List<Checksum> checksums = verification.getChecksums();
                for (Checksum checksum : checksums) {
                    DependencyVerifier.verifyChecksum(checksum.getKind(), file, checksum.getValue(), checksum.getAlternatives(), checksumService, f -> failure.set(f));
                    if (failure.get() == null) continue;
                    return Optional.of((VerificationFailure)failure.get());
                }
                return Optional.empty();
            }
        }
        return VerificationFailure.OPT_MISSING;
    }

    private static void verifyChecksum(ChecksumKind algorithm, File file, String expected, Set<String> alternatives, ChecksumService cache, Action<VerificationFailure> onFailure) {
        String actualChecksum = DependencyVerifier.checksumOf(algorithm, file, cache);
        if (expected.equals(actualChecksum)) {
            return;
        }
        if (alternatives != null) {
            for (String alternative : alternatives) {
                if (!actualChecksum.equals(alternative)) continue;
                return;
            }
        }
        onFailure.execute(new VerificationFailure(algorithm, expected, actualChecksum));
    }

    private static String checksumOf(ChecksumKind algorithm, File file, ChecksumService cache) {
        HashCode hashValue = null;
        switch (algorithm) {
            case md5: {
                hashValue = cache.md5(file);
                break;
            }
            case sha1: {
                hashValue = cache.sha1(file);
                break;
            }
            case sha256: {
                hashValue = cache.sha256(file);
                break;
            }
            case sha512: {
                hashValue = cache.sha512(file);
            }
        }
        return hashValue.toString();
    }

    public Collection<ComponentVerificationMetadata> getVerificationMetadata() {
        return this.verificationMetadata.values();
    }

    public static class VerificationFailure {
        public static final VerificationFailure MISSING = new VerificationFailure(null, null, null);
        public static final VerificationFailure DELETED = new VerificationFailure(null, null, null);
        private static final Optional<VerificationFailure> OPT_MISSING = Optional.of(MISSING);
        private static final Optional<VerificationFailure> OPT_DELETED = Optional.of(DELETED);
        private final ChecksumKind kind;
        private final String expected;
        private final String actual;

        VerificationFailure(ChecksumKind kind, String expected, String actual) {
            this.kind = kind;
            this.expected = expected;
            this.actual = actual;
        }

        public ChecksumKind getKind() {
            return this.kind;
        }

        public String getExpected() {
            return this.expected;
        }

        public String getActual() {
            return this.actual;
        }
    }
}

