/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.internal.Cast;

public abstract class CompositeFileTree
extends CompositeFileCollection
implements FileTreeInternal {
    protected List<? extends FileTreeInternal> getSourceCollections() {
        return (List)Cast.uncheckedNonnullCast(super.getSourceCollections());
    }

    @Override
    public FileTree plus(FileTree fileTree) {
        return new UnionFileTree(this, Cast.cast(FileTreeInternal.class, fileTree));
    }

    @Override
    public FileTree matching(final Closure filterConfigClosure) {
        return new FilteredFileTree(){

            @Override
            protected FileTree filter(FileTree set) {
                return set.matching(filterConfigClosure);
            }
        };
    }

    @Override
    public FileTree matching(final Action<? super PatternFilterable> filterConfigAction) {
        return new FilteredFileTree(){

            @Override
            protected FileTree filter(FileTree set) {
                return set.matching(filterConfigAction);
            }
        };
    }

    @Override
    public FileTree matching(final PatternFilterable patterns) {
        return new FilteredFileTree(){

            @Override
            protected FileTree filter(FileTree set) {
                return set.matching(patterns);
            }
        };
    }

    @Override
    public FileTree visit(Closure visitor) {
        return this.visit(AbstractFileTree.fileVisitorFrom(visitor));
    }

    @Override
    public FileTree visit(Action<? super FileVisitDetails> visitor) {
        for (FileTree fileTree : this.getSourceCollections()) {
            fileTree.visit(visitor);
        }
        return this;
    }

    @Override
    public FileTree visit(FileVisitor visitor) {
        for (FileTree fileTree : this.getSourceCollections()) {
            fileTree.visit(visitor);
        }
        return this;
    }

    @Override
    public FileTree getAsFileTree() {
        return this;
    }

    private abstract class FilteredFileTree
    extends CompositeFileTree {
        private FilteredFileTree() {
        }

        protected abstract FileTree filter(FileTree var1);

        @Override
        public String getDisplayName() {
            return CompositeFileTree.this.getDisplayName();
        }

        @Override
        public void visitContents(FileCollectionResolveContext context) {
            ResolvableFileCollectionResolveContext nestedContext = context.newContext();
            CompositeFileTree.this.visitContents(nestedContext);
            for (FileTree fileTree : nestedContext.resolveAsFileTrees()) {
                context.add(this.filter(fileTree));
            }
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            CompositeFileTree.this.visitDependencies(context);
        }
    }
}

