/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.util.HashSet;
import org.gradle.api.file.DuplicateFileCopyingException;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.tasks.WorkResult;
import org.gradle.util.DeprecationLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateHandlingCopyActionDecorator
implements CopyAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateHandlingCopyActionDecorator.class);
    private final CopyAction delegate;

    public DuplicateHandlingCopyActionDecorator(CopyAction delegate) {
        this.delegate = delegate;
    }

    @Override
    public WorkResult execute(CopyActionProcessingStream stream) {
        HashSet visitedFiles = new HashSet();
        return this.delegate.execute(action -> stream.process(details -> {
            if (!details.isDirectory()) {
                DuplicatesStrategy strategy = details.getDuplicatesStrategy();
                if (!visitedFiles.add(details.getRelativePath())) {
                    if (details.isDefaultDuplicatesStrategy()) {
                        DeprecationLogger.nagUserWithDeprecatedIndirectUserCodeCause("Copying or archiving duplicate paths with the default duplicates strategy", "Explicitly set the duplicates strategy to 'DuplicatesStrategy.INCLUDE' if you want to allow duplicate paths.", "Duplicate path: \"" + details.getRelativePath() + "\".");
                    }
                    if (strategy == DuplicatesStrategy.EXCLUDE) {
                        return;
                    }
                    if (strategy == DuplicatesStrategy.FAIL) {
                        throw new DuplicateFileCopyingException(String.format("Encountered duplicate path \"%s\" during copy operation configured with DuplicatesStrategy.FAIL", details.getRelativePath()));
                    }
                    if (strategy == DuplicatesStrategy.WARN) {
                        LOGGER.warn("Encountered duplicate path \"{}\" during copy operation configured with DuplicatesStrategy.WARN", (Object)details.getRelativePath());
                    }
                }
            }
            action.processFile(details);
        }));
    }
}

