/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.lang.reflect.Method;
import org.gradle.api.Describable;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.ImplementationAwareTaskAction;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

class StandardTaskAction
implements ImplementationAwareTaskAction,
Describable {
    private final Class<? extends Task> type;
    private final Method method;

    public StandardTaskAction(Class<? extends Task> type, Method method) {
        this.type = type;
        this.method = method;
    }

    @Override
    public void execute(Task task) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.method.getDeclaringClass().getClassLoader());
        try {
            this.doExecute(task, this.method.getName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected void doExecute(Task task, String methodName) {
        JavaMethod.of(task, Object.class, methodName, new Class[0]).invoke(task, new Object[0]);
    }

    @Override
    public ImplementationSnapshot getActionImplementation(ClassLoaderHierarchyHasher hasher) {
        return ImplementationSnapshot.of(this.type.getName(), hasher.getClassLoaderHash(this.method.getDeclaringClass().getClassLoader()));
    }

    @Override
    public String getDisplayName() {
        return "Execute " + this.method.getName();
    }
}

