/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.AbstractProviderWithValue;
import org.gradle.api.internal.provider.AbstractReadOnlyProvider;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ScalarSupplier;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;
import org.gradle.internal.state.Managed;
import org.gradle.util.GUtil;

public abstract class AbstractMinimalProvider<T>
implements ProviderInternal<T>,
ScalarSupplier<T>,
Managed {
    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
        return new TransformBackedProvider<S, T>(transformer, this);
    }

    @Override
    public <S> Provider<S> flatMap(Transformer<? extends Provider<? extends S>, ? super T> transformer) {
        return new FlatMapProvider(this, transformer);
    }

    @Override
    public boolean isPresent() {
        return this.getOrNull() != null;
    }

    @Override
    public T get(DisplayName owner) throws IllegalStateException {
        return this.get();
    }

    @Override
    public T getOrElse(T defaultValue) {
        Object value = this.getOrNull();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public Provider<T> orElse(T value) {
        return new OrElseFixedValueProvider<T>(this, value);
    }

    @Override
    public Provider<T> orElse(Provider<? extends T> provider) {
        return new OrElseProvider<T>(this, Providers.internal(provider));
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.maybeVisitBuildDependencies(context);
    }

    @Override
    public boolean isValueProducedByTask() {
        return false;
    }

    @Override
    public void visitProducerTasks(Action<? super Task> visitor) {
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        return false;
    }

    @Override
    public ProviderInternal<T> asProvider() {
        return this;
    }

    @Override
    public ScalarSupplier<T> asSupplier(DisplayName owner, Class<? super T> targetType, ValueSanitizer<? super T> sanitizer) {
        if (this.getType() != null && !targetType.isAssignableFrom(this.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of %s of type %s using a provider of type %s.", owner.getDisplayName(), targetType.getName(), this.getType().getName()));
        }
        if (this.getType() == null) {
            return new TypeSanitizingProvider<T>(owner, sanitizer, targetType, this);
        }
        return this;
    }

    @Override
    public ScalarSupplier<T> withFinalValue() {
        Object value = this.getOrNull();
        return Providers.nullableValue(value);
    }

    public String toString() {
        return String.format("provider(%s)", GUtil.elvis(this.getType(), "?"));
    }

    @Override
    public boolean immutable() {
        return false;
    }

    @Override
    public Class<?> publicType() {
        return Provider.class;
    }

    @Override
    public Object unpackState() {
        return this.getOrNull();
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.ProviderManagedFactory.FACTORY_ID;
    }

    private static class TypeSanitizingProvider<T>
    extends AbstractMappingProvider<T, T> {
        private final DisplayName owner;
        private final ValueSanitizer<? super T> sanitizer;
        private final Class<? super T> targetType;

        public TypeSanitizingProvider(DisplayName owner, ValueSanitizer<? super T> sanitizer, Class<? super T> targetType, ProviderInternal<? extends T> delegate) {
            super((Class)Cast.uncheckedNonnullCast(targetType), delegate);
            this.owner = owner;
            this.sanitizer = sanitizer;
            this.targetType = targetType;
        }

        @Override
        protected T mapValue(T v) {
            if (this.targetType.isInstance(v = Cast.uncheckedCast(this.sanitizer.sanitize(v)))) {
                return v;
            }
            throw new IllegalArgumentException(String.format("Cannot get the value of %s of type %s as the provider associated with this property returned a value of type %s.", this.owner.getDisplayName(), this.targetType.getName(), v.getClass().getName()));
        }
    }

    private static class OrElseProvider<T>
    extends AbstractReadOnlyProvider<T> {
        private final ProviderInternal<T> left;
        private final ProviderInternal<? extends T> right;

        public OrElseProvider(ProviderInternal<T> left, ProviderInternal<? extends T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return this.left.getType();
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            if (this.left.isPresent()) {
                return this.left.maybeVisitBuildDependencies(context);
            }
            return this.right.maybeVisitBuildDependencies(context);
        }

        @Override
        public boolean isPresent() {
            return this.left.isPresent() || this.right.isPresent();
        }

        @Override
        @Nullable
        public T getOrNull() {
            Object value = this.left.getOrNull();
            if (value == null) {
                value = this.right.getOrNull();
            }
            return value;
        }
    }

    private static class OrElseFixedValueProvider<T>
    extends AbstractProviderWithValue<T> {
        private final ProviderInternal<T> provider;
        private final T value;

        public OrElseFixedValueProvider(ProviderInternal<T> provider, T value) {
            this.provider = provider;
            this.value = value;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return this.provider.getType();
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            if (this.provider.isPresent()) {
                return this.provider.maybeVisitBuildDependencies(context);
            }
            return super.maybeVisitBuildDependencies(context);
        }

        @Override
        public T get() {
            Object value = this.provider.getOrNull();
            return value != null ? value : this.value;
        }
    }

    private static class FlatMapProvider<S, T>
    extends AbstractMinimalProvider<S> {
        private final Provider<? extends T> provider;
        private final Transformer<? extends Provider<? extends S>, ? super T> transformer;

        FlatMapProvider(ProviderInternal<? extends T> provider, Transformer<? extends Provider<? extends S>, ? super T> transformer) {
            this.provider = provider;
            this.transformer = transformer;
        }

        @Override
        @Nullable
        public Class<S> getType() {
            return null;
        }

        @Override
        public boolean isPresent() {
            T value = this.provider.getOrNull();
            if (value == null) {
                return false;
            }
            return this.map(value).isPresent();
        }

        @Override
        public S get() {
            T value = this.provider.get();
            return this.map(value).get();
        }

        @Override
        @Nullable
        public S getOrNull() {
            T value = this.provider.getOrNull();
            if (value == null) {
                return null;
            }
            return this.map(value).getOrNull();
        }

        private Provider<? extends S> map(T value) {
            Provider<? extends S> result = this.transformer.transform(value);
            if (result == null) {
                throw new IllegalStateException("Transformer for this provider returned a null value.");
            }
            return result;
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return Providers.internal(this.map(this.provider.get())).maybeVisitBuildDependencies(context);
        }

        @Override
        public String toString() {
            return "flatmap(" + this.provider + ")";
        }
    }
}

