/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.MultimapBuilder;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.com.google.common.io.LineProcessor;
import org.gradle.util.GFileUtils;

public class SourceClassesMappingFileAccessor {
    public static Multimap<String, String> readSourceClassesMappingFile(File mappingFile) {
        SetMultimap sourceClassesMapping = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
        if (!mappingFile.isFile()) {
            return sourceClassesMapping;
        }
        try {
            Files.asCharSource((File)mappingFile, (Charset)Charsets.UTF_8).readLines((LineProcessor)new LineProcessor<Void>((Multimap)sourceClassesMapping){
                private String currentFile;
                final /* synthetic */ Multimap val$sourceClassesMapping;
                {
                    this.val$sourceClassesMapping = multimap;
                }

                public boolean processLine(String line) throws IOException {
                    if (line.startsWith(" ")) {
                        this.val$sourceClassesMapping.put((Object)this.currentFile, (Object)line.substring(1));
                    } else {
                        this.currentFile = line;
                    }
                    return true;
                }

                public Void getResult() {
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        return sourceClassesMapping;
    }

    public static void writeSourceClassesMappingFile(File mappingFile, Multimap<String, String> mapping) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : mapping.asMap().entrySet()) {
            sb.append((String)entry.getKey()).append("\n");
            for (String className : (Collection)entry.getValue()) {
                sb.append(" ").append(className).append("\n");
            }
        }
        GFileUtils.writeFile(sb.toString(), mappingFile);
    }
}

